package org.lsst.ccs.gconsole.plugins.alert;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import static java.awt.Component.LEFT_ALIGNMENT;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;
import org.lsst.ccs.gconsole.base.Const;

/**
 *
 * @author onoprien
 */
public class MuteDialog extends JDialog {
    
    private boolean ok;
    private final JButton okButton;
    private final JTextField agentField, regExField, minutesField;
    
    MuteDialog(Component parent, String agentSeed, String regExSeed) {
        
        super(parent == null ? null : SwingUtilities.getWindowAncestor(parent), "Mute alerts", Dialog.ModalityType.APPLICATION_MODAL);
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(WindowEvent e) {
                dispose();
            }
        });
        
        JPanel inputPanel = new JPanel(new GridLayout(3,1));
        add(inputPanel, BorderLayout.CENTER);
        
        Box box = Box.createHorizontalBox();
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(new JLabel("Subsystem"));
        box.add(Box.createRigidArea(Const.HDIM));
        agentField = new JTextField(agentSeed);
        agentField.addCaretListener(e -> validateInput());
        box.add(agentField);
        box.add(Box.createRigidArea(Const.HDIM));
        box.setToolTipText("Subsystem name:");
        inputPanel.add(box);
        
        box = Box.createHorizontalBox();
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(new JLabel("Reg Ex:"));
        box.add(Box.createRigidArea(Const.HDIM));
        regExField = new JTextField(regExSeed);
        regExField.addCaretListener(e -> validateInput());
        box.add(regExField);
        box.add(Box.createRigidArea(Const.HDIM));
        box.setToolTipText("Regular expression to match against alert ID");
        inputPanel.add(box);
        
        box = Box.createHorizontalBox();
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(new JLabel("Duration:"));
        box.add(Box.createRigidArea(Const.HDIM));
        minutesField = new JTextField();
        minutesField.addCaretListener(e -> validateInput());
        box.add(minutesField);
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(new JLabel("minutes."));
        box.add(Box.createRigidArea(Const.HDIM));
        box.setToolTipText("Keep muted for the specified number of minutes. No more than 3 hours.");
        inputPanel.add(box);
        
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.setAlignmentX(LEFT_ALIGNMENT);
        buttonBox.setBorder(BorderFactory.createEmptyBorder(Const.VSPACE, Const.HSPACE, Const.VSPACE, Const.HSPACE));
        buttonBox.add(Box.createRigidArea(Const.HDIM2));
        buttonBox.add(Box.createHorizontalGlue());
        okButton = new JButton(" OK ");
        okButton.addActionListener(e -> {
            String agent = validateAgent();
            String regEx = validateRegEx();
            int seconds = validateMinutes() * 60;
            if (agent != null && regEx != null && seconds > 0) {
                ok = true;
                if (regEx.isBlank()) {
                    AlertViewer.sendCommandToMMM("muteAllAlertsForSubsystem", agent, seconds);
                } else {
                    AlertViewer.sendCommandToMMM("muteAlertsForSubsystem", agent, regEx, seconds);
                }
                dispose();
            }
        });
        buttonBox.add(okButton);
        buttonBox.add(Box.createRigidArea(Const.HDIM2));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            dispose();
        });
        buttonBox.add(cancelButton);
        buttonBox.add(Box.createRigidArea(Const.HDIM2));
        add(buttonBox, BorderLayout.SOUTH);
    }
    
    static MuteDialog show(Component parent, String agent, String regEx) {
        MuteDialog d = new MuteDialog(parent, agent, regEx);
        d.setSize(d.getPreferredSize());
        d.pack();
        d.setLocationRelativeTo(parent);
        d.setVisible(true);
        return d;
    }
    
// -- Local methods : ----------------------------------------------------------
    
    private String validateRegEx() {
        String text = regExField.getText().trim();
        try {
            Pattern.compile(text);
            regExField.setForeground(null);
            return text;
        } catch (PatternSyntaxException x) {
            regExField.setForeground(Color.RED);
            return null;
        }
    }
    
    private String validateAgent() {
        String text = agentField.getText().trim();
        if (Const.AGENT_NAME_PATTERN.matcher(text).matches()) {
            agentField.setForeground(null);
            return text;
        } else {
            agentField.setForeground(Color.RED);
            return null;
        }
    }
    
    private int validateMinutes() {
        String text = minutesField.getText().trim();
        try {
            int minutes = Integer.parseInt(text);
            if (minutes > 0 && minutes <= 60*3) {
                minutesField.setForeground(null);
                return minutes;
            } else {
                throw new NumberFormatException("Should be 0 < minutes <= 300");
            }
        } catch (NumberFormatException x) {
            minutesField.setForeground(Color.RED);
            return -1;
        }
    }
    
    private boolean validateInput() {
        String agent = validateAgent();
        String regEx = validateRegEx();
        int minutes = validateMinutes();
        boolean valid = agent != null && regEx != null && minutes != -1;
        okButton.setEnabled(valid);
        return valid;
    }
    
}
