package org.lsst.ccs.gconsole.util.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;


/**
 * Just a stub for experimenting with JComboBox mouse listeners
 *
 * @author onoprien
 */
public class TestComboBox<E> extends JComboBox<E> {

// -- Fields : -----------------------------------------------------------------

// -- Life cycle : -------------------------------------------------------------
    
    public TestComboBox(E[] items) {
        super(items);
    }
    
// -- Testing : ----------------------------------------------------------------
    
    public static void main(final String[] args) {

        SwingUtilities.invokeLater(() -> {
            try {
                JFrame top = new JFrame("test");
                top.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                init(top);
                top.setVisible(true);
            } catch (Throwable t) {
                System.out.println("Fatal Error: " + t.getMessage());
                System.exit(1);
            }
        });

    }
    
    static private void init(JFrame frame) {
        TestComboBox<String> combo = new TestComboBox<>(new String[] {"1", "2", "3"});
        combo.setEditable(false);
        
        combo.addPopupMenuListener(new PopupMenuListener() {
            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }
            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        
        combo.getEditor().getEditorComponent().addMouseListener(new MouseAdapter() {
            @Override
            public void mouseReleased(MouseEvent e) {
                System.out.println("mouseReleased "+ e.getButton() +" "+ e.isPopupTrigger());
                
            }

            @Override
            public void mousePressed(MouseEvent e) {
                System.out.println("mouseReleased "+ e.getButton() +" "+ e.isPopupTrigger());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                System.out.println("mouseReleased "+ e.getButton() +" "+ e.isPopupTrigger());
            }
            
        });
        
        frame.add(combo);
    }

}
