/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;

public class States
extends AbstractChannelsFilter {
    public static final String CREATOR_PATH = "Built-In/Special/States";
    private final String name;
    private final List<String> agents;

    @Create(category="AgentChannelsFilter", name="States", path="Built-In/Special/States", description="Channels filter that selects subsystem state channels.")
    public States(@Par(def="States", desc="Filter name.") String name, @Par(def="_null_", desc="List of subsystems accepted by this filter. If null, all subsystems are accepted.") List<String> agents) {
        this.name = name;
        this.agents = agents == null ? null : new ArrayList<String>(agents);
    }

    @Override
    public List<String> getDisplayPaths(String originPath) {
        String displayPath = originPath.replaceFirst("/states/", "/");
        return Collections.singletonList(displayPath);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return displayPath.replaceFirst("/", "/states/");
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList("/states/");
    }

    @Override
    public List<String> getAgents() {
        return this.agents == null ? null : Collections.unmodifiableList(this.agents);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

