package org.lsst.ccs.gconsole.plugins.trending;

import java.awt.Component;
import static java.awt.Component.LEFT_ALIGNMENT;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import static org.lsst.ccs.gconsole.base.Const.HDIM;
import static org.lsst.ccs.gconsole.base.Const.HSPACE;
import static org.lsst.ccs.gconsole.base.Const.VSPACE;

/**
 *
 * @author onoprien
 */
public class ApplyDialog {
    
    /** Enumeration of settings that can be applied. */
    static public enum What {TIME_RANGE, DATA_TYPE}
    
    /** Enumeration of target sets of plots the settings should be applied to. */
    static public enum Where {PLOT, PAGE, ALL}

// -- Fields : -----------------------------------------------------------------
    
    private final Set<What> what;
    private final Where where;

// -- Life cycle : -------------------------------------------------------------
    
    private ApplyDialog(Set<What> what, Where where) {
        this.what = what;
        this.where = where;
    }
    
// -- Displaying the dialog : --------------------------------------------------
    
    /**
     * Displays the dialog.
     * @param parent Parent component.
     * @return An instance whose getters can be used to retrieve user's selections.
     */
    public static ApplyDialog apply(Component parent) {
        
        JPanel panel = new JPanel();    
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        panel.setAlignmentX(LEFT_ALIGNMENT);
        
        Box row = Box.createHorizontalBox();
        row.setAlignmentX(LEFT_ALIGNMENT);
        row.setBorder(BorderFactory.createCompoundBorder(
                BorderFactory.createTitledBorder(" Apply "),
                BorderFactory.createEmptyBorder(VSPACE, HSPACE, VSPACE, HSPACE)));
        JCheckBox rangeBox = new JCheckBox("Time Range");
        rangeBox.setSelected(true);
        row.add(rangeBox);
        row.add(Box.createRigidArea(HDIM));
        JCheckBox typeBox = new JCheckBox("Data type");
        row.add(typeBox);
        row.add(Box.createHorizontalGlue());
        panel.add(row);
        
        rangeBox.addActionListener(e -> {
            if (!rangeBox.isSelected()) {
                typeBox.setSelected(true);
            }
        });
        typeBox.addActionListener(e -> {
            if (!typeBox.isSelected()) {
                rangeBox.setSelected(true);
            }
        });
        
        
        row = Box.createHorizontalBox();
        row.setAlignmentX(LEFT_ALIGNMENT);
        row.setBorder(BorderFactory.createCompoundBorder(
                BorderFactory.createTitledBorder(" To "),
                BorderFactory.createEmptyBorder(VSPACE, HSPACE, VSPACE, HSPACE)));
        ButtonGroup group = new ButtonGroup();
        JRadioButton plotRadio = new JRadioButton("Plot");
        group.add(plotRadio);
        row.add(plotRadio);
        row.add(Box.createRigidArea(HDIM));
        JRadioButton pageRadio = new JRadioButton("Page");
        group.add(pageRadio);
        row.add(pageRadio);
        row.add(Box.createRigidArea(HDIM));
        JRadioButton allRadio = new JRadioButton("All");
        group.add(allRadio);
        row.add(allRadio);
        pageRadio.setSelected(true);
        row.add(Box.createHorizontalGlue());
        panel.add(row);
        
        int response = JOptionPane.showConfirmDialog(parent, panel, "Apply time range and/or data type settings", JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);
        ApplyDialog out;
        if (response == JOptionPane.OK_OPTION) {
            Set<What> what = EnumSet.noneOf(What.class);
            Where where;
            if (rangeBox.isSelected()) {
                what.add(What.TIME_RANGE);
            }
            if (typeBox.isSelected()) {
                what.add(What.DATA_TYPE);
            }
            if (plotRadio.isSelected()) {
                where = Where.PLOT;
            } else if (pageRadio.isSelected()) {
                where = Where.PAGE;
            } else {
                where = Where.ALL;
            }
            out = new ApplyDialog(what, where);
        } else {
            out = new ApplyDialog(null, null);
        }
        return out;
    }
    
    
// -- Retrieving results : -----------------------------------------------------

    public Set<What> getWhat() {
        return Collections.unmodifiableSet(what);
    }

    public Where getWhere() {
        return where;
    }
    
    public boolean isCancelled() {
        return what == null;
    }
    
    
// -- Testing : ----------------------------------------------------------------
    
    @Override
    public String toString() {
        return new StringBuilder("Apply ").append(what).append(" to ").append(where).append(".").toString();
    }
    
    static public void main(String... args) {

        SwingUtilities.invokeLater(() -> {

            while (true) {
                ApplyDialog tw = ApplyDialog.apply(null);
                System.out.println(tw);
                if (tw.isCancelled()) {
                    break;
                }
            }
        });

    }

}
