package org.lsst.ccs.gconsole.base.filter;

import java.util.*;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

/**
 * Filter that selects subsystem core state channels.
 *
 * @author onoprien
 */
public class CoreStates extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    static public final String CREATOR_PATH = "Built-In/Special/Core States";
    
    private final String name;
    private final List<String> agents;
    
    private final int cutFront = AgentChannel.MARK_STATE.length() - 2;
    private final int cutBack = "State".length();
    static public List<String> CHANNELS = Collections.unmodifiableList(Arrays.asList(
            AgentChannel.MARK_STATE + "PhaseState",
            AgentChannel.MARK_STATE + "OperationalState",
            AgentChannel.MARK_STATE + "ConfigurationState",
            AgentChannel.MARK_STATE + "AlertState",
            AgentChannel.MARK_STATE + "CommandState"));

// -- Life cycle : -------------------------------------------------------------
    
    @Create(category = AgentChannelsFilter.CATEGORY,
            name = "Core States",
            path = CREATOR_PATH,
            description = "Selects core state channels, renames them to shorten the path.")
    public CoreStates(
            @Par(def = "Core states", desc = "Filter name.") String name,
            @Par(def = Par.NULL, desc = "List of subsystems accepted by this filter. If null, all subsystems are accepted.") List<String> agents)
    {
        this.name = name;
        this.agents = agents == null ? null : Collections.unmodifiableList(new ArrayList<>(agents));
    }
    
// -- Implementing filter : ----------------------------------------------------
    
    @Override
    public List<String> getDisplayPaths(AgentChannel channel) {
        String path = channel.getLocalPath();
        String displayPath = channel.getAgentName() + path.substring(cutFront, path.length() - cutBack);
        return Collections.singletonList(displayPath);
    }
    
    @Override
    public List<String> getOriginPaths(String displayPath) {
        return Collections.singletonList(displayPath.replaceFirst("/", AgentChannel.MARK_STATE) +"State");
    }

    @Override
    public List<String> getOriginChannels() {
        return CHANNELS;
    }

    @Override
    public List<String> getAgents() {
        return agents;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public List<String> getFields(boolean compact) {
       return Collections.singletonList("VALUE");
    }

}

