/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import org.freehep.jas.plugin.tree.DefaultFTreeNode;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeSorter;

public class SorterAlphaNumerical
implements FTreeNodeSorter {
    @Override
    public String algorithmName() {
        return "Alpha-Numerical";
    }

    @Override
    public String description() {
        return "Sorts nodes alphabetically and numerically";
    }

    @Override
    public int sort(FTreeNode node1, FTreeNode node2) {
        int num2;
        int result;
        int i;
        DefaultFTreeNode n1 = (DefaultFTreeNode)node1;
        DefaultFTreeNode n2 = (DefaultFTreeNode)node2;
        String name1 = n1.path().getLastPathComponent();
        String name2 = n2.path().getLastPathComponent();
        int l = name1.length();
        if (name2.length() < l) {
            l = name2.length();
        }
        int ld = -1;
        for (i = 0; i < l; ++i) {
            if (name1.charAt(i) == name2.charAt(i)) continue;
            ld = i;
            break;
        }
        if (ld == -1) {
            return name1.compareTo(name2);
        }
        for (i = ld - 1; i > -1 && Character.isDigit(name1.charAt(i)); --i) {
            --ld;
        }
        if (!Character.isDigit(name1.charAt(ld)) || !Character.isDigit(name2.charAt(ld))) {
            return name1.compareTo(name2);
        }
        int le1 = ld;
        int i2 = ld + 1;
        while (i2 < name1.length() && Character.isDigit(name1.charAt(i2))) {
            le1 = i2++;
        }
        int le2 = ld;
        int i3 = ld + 1;
        while (i3 < name2.length() && Character.isDigit(name2.charAt(i3))) {
            le2 = i3++;
        }
        int num1 = Integer.parseInt(name1.substring(ld, le1 + 1));
        int n = result = num1 > (num2 = Integer.parseInt(name2.substring(ld, le2 + 1))) ? 1 : -1;
        if (num1 == num2) {
            result = 0;
        }
        return result;
    }
}

