/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.channel;

import org.python.netty.channel.ChannelHandlerContext;
import org.python.netty.channel.ChannelInboundHandlerAdapter;
import org.python.netty.util.ReferenceCountUtil;
import org.python.netty.util.internal.TypeParameterMatcher;

public abstract class SimpleChannelInboundHandler<I>
extends ChannelInboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private final boolean autoRelease;

    protected SimpleChannelInboundHandler() {
        this(true);
    }

    protected SimpleChannelInboundHandler(boolean autoRelease) {
        this.matcher = TypeParameterMatcher.find(this, SimpleChannelInboundHandler.class, "I");
        this.autoRelease = autoRelease;
    }

    protected SimpleChannelInboundHandler(Class<? extends I> inboundMessageType) {
        this(inboundMessageType, true);
    }

    protected SimpleChannelInboundHandler(Class<? extends I> inboundMessageType, boolean autoRelease) {
        this.matcher = TypeParameterMatcher.get(inboundMessageType);
        this.autoRelease = autoRelease;
    }

    public boolean acceptInboundMessage(Object msg2) throws Exception {
        return this.matcher.match(msg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg2) throws Exception {
        boolean release = true;
        try {
            if (this.acceptInboundMessage(msg2)) {
                Object imsg = msg2;
                this.channelRead0(ctx, imsg);
            } else {
                release = false;
                ctx.fireChannelRead(msg2);
            }
        }
        finally {
            if (this.autoRelease && release) {
                ReferenceCountUtil.release(msg2);
            }
        }
    }

    protected abstract void channelRead0(ChannelHandlerContext var1, I var2) throws Exception;
}

