/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.gconsole.services.rest.LsstRestService;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.StateChange;
import org.lsst.ccs.localdb.statusdb.server.StateInfo;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.server.TrendingResult;

public class SimulatedRestService
extends LsstRestService {
    DataChannel.DataChannelList trendingChannels;
    Map<String, History> stringData;
    DataChannel.DataChannelList stateChannels;
    StateInfo.StateInfoList a0stateInfo;
    StateInfo.StateInfoList a1stateInfo;
    List<StateChange> a0stateChanges;
    List<StateChange> a1stateChanges;

    public SimulatedRestService() {
        LinkedList<DataChannel> channels = new LinkedList<DataChannel>();
        DataDesc d = new DataDesc();
        d.setDataPath(new DataPath("a0", "s0"));
        d.setDataType("state");
        channels.add(new DataChannel(d));
        d = new DataDesc();
        d.setDataPath(new DataPath("a0", "c00/c10/s1"));
        d.setDataType("state");
        channels.add(new DataChannel(d));
        d = new DataDesc();
        d.setDataPath(new DataPath("a0", "c01/c10/s1"));
        d.setDataType("state");
        channels.add(new DataChannel(d));
        d = new DataDesc();
        d.setDataPath(new DataPath("a0", "c00/c10/s2"));
        d.setDataType("state");
        channels.add(new DataChannel(d));
        d = new DataDesc();
        d.setDataPath(new DataPath("a1", "s0"));
        d.setDataType("state");
        channels.add(new DataChannel(d));
        this.stateChannels = new DataChannel.DataChannelList(channels, 0L);
        LinkedList<StateInfo> infoList = new LinkedList<StateInfo>();
        infoList.add(new StateInfo("s0", new String[]{"0", "1"}));
        infoList.add(new StateInfo("s1", new String[]{"0", "1", "2", "3", "4", "5", "6"}));
        infoList.add(new StateInfo("s2", new String[]{"0", "1", "2"}));
        this.a0stateInfo = new StateInfo.StateInfoList(infoList);
        infoList = new LinkedList();
        infoList.add(new StateInfo("s0", new String[]{"x", "y", "z"}));
        this.a1stateInfo = new StateInfo.StateInfoList(infoList);
        this.a0stateChanges = new LinkedList<StateChange>();
        StateChange sc = new StateChange();
        sc.setTime(100L);
        sc.addStateEvent("", "s0", "1");
        sc.addStateEvent("c00/c10", "s1", "0");
        sc.addStateEvent("c00/c10", "s2", "1");
        this.a0stateChanges.add(sc);
        sc = new StateChange();
        sc.setTime(110L);
        sc.addStateEvent("", "s0", "0");
        sc.addStateEvent("c01/c10", "s1", "2");
        this.a0stateChanges.add(sc);
        sc = new StateChange();
        sc.setTime(120L);
        sc.addStateEvent("c00/c10", "s1", "2");
        this.a0stateChanges.add(sc);
        sc = new StateChange();
        sc.setTime(130L);
        sc.addStateEvent("", "s0", "1");
        sc.addStateEvent("c01/c10", "s1", "1");
        sc.addStateEvent("c00/c10", "s2", "2");
        this.a0stateChanges.add(sc);
        sc = new StateChange();
        sc.setTime(140L);
        sc.addStateEvent("c01/c10", "s1", "5");
        this.a0stateChanges.add(sc);
        sc = new StateChange();
        sc.setTime(190L);
        sc.addStateEvent("c00/c10", "s2", "1");
        this.a0stateChanges.add(sc);
        sc = new StateChange();
        sc.setTime(200L);
        sc.addStateEvent("", "s0", "1");
        sc.addStateEvent("c00/c10", "s1", "0");
        sc.addStateEvent("c01/c10", "s1", "2");
        this.a0stateChanges.add(sc);
        this.a1stateChanges = new LinkedList<StateChange>();
        sc = new StateChange();
        sc.setTime(100L);
        sc.addStateEvent("", "s0", "x");
        this.a1stateChanges.add(sc);
        sc = new StateChange();
        sc.setTime(130L);
        sc.addStateEvent("", "s0", "y");
        this.a1stateChanges.add(sc);
        sc = new StateChange();
        sc.setTime(140L);
        sc.addStateEvent("", "s0", "x");
        this.a1stateChanges.add(sc);
        sc = new StateChange();
        sc.setTime(200L);
        sc.addStateEvent("", "s0", "z");
        this.a1stateChanges.add(sc);
        channels = new LinkedList();
        d = new DataDesc();
        d.setDataPath(new DataPath("a0", "string0"));
        DataChannel dc = new DataChannel(d);
        dc.getMetadata().put("type", "java.lang.String");
        channels.add(dc);
        d = new DataDesc();
        d.setDataPath(new DataPath("a1", "b/b0"));
        dc = new DataChannel(d);
        dc.getMetadata().put("type", "boolean");
        channels.add(dc);
        this.trendingChannels = new DataChannel.DataChannelList(channels, 0L);
        this.stringData = new HashMap<String, History>();
        this.stringData.put("a0/string0", new History("string", new long[]{100L, 120L, 140L, 150L, 160L, 180L}, new String[]{"0", "1", "2", "2", "2", "1"}));
        this.stringData.put("a1/b/b0", new History("boolean", new long[]{110L, 130L, 140L, 160L, 200L}, new String[]{"false", "false", "true", "true", "true"}));
    }

    public List<StateChange> getStateTransitions(long begin, long end, String agent, Collection<String> components, Collection<String> states) {
        List<StateChange> in;
        System.out.println("Fetching state transitions: " + begin + " - " + end + ", agent " + agent + ", states: " + states + ", components: " + components);
        switch (agent) {
            case "a0": {
                in = this.a0stateChanges;
                break;
            }
            case "a1": {
                in = this.a1stateChanges;
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        LinkedList<StateChange> out = new LinkedList<StateChange>();
        for (StateChange sc : in) {
            long t = sc.getTime();
            if (t < begin || t >= end) continue;
            out.add(sc);
        }
        return out;
    }

    public TrendingResult[] getTrendingData(long begin, long end, String flavor, int nBins, String ... paths) {
        System.out.println("Fetching trending data: " + begin + " - " + end + ", flavor " + flavor + ", bins " + nBins + ", paths: " + Arrays.toString(paths));
        int n = paths.length;
        TrendingResult[] out = new TrendingResult[n];
        for (int i = 0; i < n; ++i) {
            History h = this.stringData.get(paths[i]);
            if (h == null) {
                out[i] = null;
                continue;
            }
            ArrayList<TrendingData> tds = new ArrayList<TrendingData>();
            for (int ii = 0; ii < h.times.length; ++ii) {
                long t = h.times[ii];
                if (t < begin || t >= end) continue;
                TrendingData.AxisValue av = new TrendingData.AxisValue("", t);
                TrendingData.DataValue[] dv = new TrendingData.DataValue[]{new TrendingData.DataValue("value", h.values[ii])};
                TrendingData td = new TrendingData();
                td.setAxisValue(av);
                td.setDataValue(dv);
                tds.add(td);
            }
            TrendingResult tr = new TrendingResult();
            tr.setChannelMetadata(Collections.singletonList(new ChannelMetaData("type", h.type, begin, end)));
            tr.setTrendingDataArray(tds.toArray(new TrendingData[0]));
            out[i] = tr;
        }
        return out;
    }

    public StateInfo.StateInfoList getStateInfo(String agent) {
        System.out.println("REST service: request state info for agent " + agent);
        switch (agent) {
            case "a0": {
                return this.a0stateInfo;
            }
            case "a1": {
                return this.a1stateInfo;
            }
        }
        return new StateInfo.StateInfoList(Collections.emptyList());
    }

    public DataChannel.DataChannelList getStateList(long begin) {
        System.out.println("REST service: request state list.");
        return this.stateChannels;
    }

    public DataChannel.DataChannelList getTrendingList(long begin) {
        System.out.println("REST service: request trending channels list.");
        return this.trendingChannels;
    }

    public void refreshConnection(boolean queue) {
    }

    public void shutdown() {
    }

    public void start() {
    }

    public void initialize() {
    }

    private static class History {
        String type;
        long[] times;
        String[] values;

        public History(String type, long[] times, String[] values) {
            this.type = type;
            this.times = times;
            this.values = values;
        }
    }
}

