package org.lsst.ccs.gconsole.util.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

/**
 *
 * @author onoprien
 */
public class InputFilteringPanel extends JLayeredPane {

// -- Fields : -----------------------------------------------------------------
    
    private final JComponent content;
    private final JPanel filter;

    private boolean blocked;
    
    private ArrayList<Listener> listeners;
    int i=0;

// -- Life cycle : -------------------------------------------------------------
    
    public InputFilteringPanel(JComponent payload) {
        this.content = payload;
        setPreferredSize(content.getPreferredSize());
        add(content, Integer.valueOf(1));
        filter = new JPanel();
        filter.setOpaque(false);
        add(filter, Integer.valueOf(0));
        Dimension paneSize = getSize();
        content.setBounds(0, 0, paneSize.width, paneSize.height);
        filter.setBounds(0, 0, paneSize.width, paneSize.height);
        addComponentListener(new ComponentAdapter() {
            @Override
            public void componentResized(ComponentEvent e) {
                Dimension newSize = getSize();
                content.setBounds(0, 0, newSize.width, newSize.height);
                filter.setBounds(0, 0, newSize.width, newSize.height);
            }
        });
        MouseAdapter m = new MouseAdapter() {
            @Override
            public void mouseMoved(MouseEvent e) {
                e.consume();
            }
            @Override
            public void mouseDragged(MouseEvent e) {
                e.consume();
            }
            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                e.consume();
            }
            @Override
            public void mouseExited(MouseEvent e) {
                e.consume();
            }
            @Override
            public void mouseEntered(MouseEvent e) {
                e.consume();
            }
            @Override
            public void mouseReleased(MouseEvent e) {
                e.consume();
                showPopup(e);
            }
            @Override
            public void mousePressed(MouseEvent e) {
                e.consume();
                showPopup(e);
            }
            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
                onBlock(e);
            }
        };
        filter.addMouseListener(m);
        filter.addMouseMotionListener(m);
        filter.addMouseWheelListener(m);
    }
    

// -- Getters and setters : ----------------------------------------------------
    
    public JComponent getContent() {
        return content;
    }

    public boolean isBlocked() {
        return blocked;
    }

    public void setBlocked(boolean blocked) {
        if (blocked != this.blocked) {
            this.blocked = blocked;
            if (blocked) {
                setLayer(filter, 2);
                content.setFocusable(false);
            } else {
                setLayer(filter, 0);
                content.setFocusable(true);
            }
            notifyListeners();
        }
    }
    
    
// -- Handling listeners : -----------------------------------------------------
    
    public interface Listener {
        void onChange(Event event);
    }
    
    static public class Event extends EventObject {

        private final boolean active;
        
        protected Event(InputFilteringPanel source) {
            super(source);
            active = getSource().isBlocked();
        }

        @Override
        public InputFilteringPanel getSource() {
            return (InputFilteringPanel) super.getSource();
        }

        public boolean isActive() {
            return active;
        }
        
        public JComponent getComponent() {
            return getSource().getContent();
        }
    }
    
    public void addListener(Listener listener) {
        if (listeners == null) {
            listeners = new ArrayList<>(1);
        } else {
            listeners.ensureCapacity(listeners.size()+1);
        }
        listeners.add(listener);
    }
    
    public void removeListener(Listener listener) {
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                listeners = null;
            } else {
                listeners.trimToSize();
            }
        }
    }
    
    public void removeAllListeners() {
        listeners = null;
    }
    
    protected void notifyListeners() {
        if (listeners != null) {
            Event e = new Event(this);
            SwingUtilities.invokeLater(() -> {
                listeners.forEach(l -> l.onChange(e));
            });
        }
    }
    
// -- Interactions : -----------------------------------------------------------
    
    protected void showPopup(MouseEvent e) {
        if (blocked && e.isPopupTrigger()) {
            JPopupMenu popupMenu = new JPopupMenu();
            AbstractAction a = new AbstractAction("Enable Input") {
                @Override
                public void actionPerformed(ActionEvent e) {
                    setBlocked(false);
                }                
            };
            JMenuItem menuItem = new JMenuItem(a);
            popupMenu.add(menuItem);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }
    
    protected void onBlock(MouseEvent e) {
    }

// -- Testing : ----------------------------------------------------------------
    
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            
            JPanel contentPane = new JPanel();
            InputFilteringPanel filteringPane = new InputFilteringPanel(contentPane);
            contentPane.setBorder(BorderFactory.createLineBorder(Color.GREEN, 5));
            JButton b = new JButton("Button");
            b.addActionListener(e -> System.out.println("Button Pressed"));
            contentPane.add(b);
            contentPane.add(new JLabel(" Label "));
            b = new JButton("Enable filtering");
            b.addActionListener(e -> {
                boolean was = filteringPane.isBlocked();
                ((JButton)e.getSource()).setText("Toggle filtering");
                filteringPane.setBlocked(!was);
            });
            contentPane.add(b);
            
            filteringPane.setOpaque(true);

            JFrame frame = new JFrame("InputFilteringPanel Demo");
            frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            frame.setContentPane(filteringPane);
            frame.setSize(500, 500);
            frame.pack();
            frame.setVisible(true);

        });
    }

}
