/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.lock;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.services.lock.LockService;
import org.lsst.ccs.services.AgentLockService;

public class Locker {
    private final AgentLockService lockService;
    private final String agentName;
    private AgentInfo info;
    private Map<String, Dictionary> dictionaries;
    private AgentLock lock;
    private int level;
    private int maxLevel;
    private LockService.State state;
    boolean adjusting;
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();
    private final ChangeEvent changeEvent = new ChangeEvent(this);

    Locker(String name, AgentLockService lockService) {
        this.agentName = name;
        this.lockService = lockService;
    }

    void onLock(AgentLock lock) {
        if (lock instanceof AgentLockInfo) {
            switch (((AgentLockInfo)lock).getStatus()) {
                case RELEASED: 
                case REJECTED: {
                    lock = null;
                    break;
                }
                case REQUESTED: {
                    return;
                }
            }
        }
        this.lock = lock;
        if (lock == null) {
            this.state = LockService.State.UNLOCKED;
            this.maxLevel = this.lockService.getMaxLevel(this.lockService.getUserId(), this.agentName);
        } else if (lock.getOwner().equals(this.lockService.getUserId())) {
            if (this.lockService.getDetachableAgents().contains(lock.getAgentName())) {
                this.state = LockService.State.ATTACHED;
                this.maxLevel = lock.getMaxLevel();
            } else {
                this.state = LockService.State.DETACHED;
                this.maxLevel = this.lockService.getMaxLevel(this.lockService.getUserId(), this.agentName);
            }
        } else {
            this.state = LockService.State.LOCKED;
            this.maxLevel = -1;
        }
        this.level = this.lockService.getLevelForAgent(this.agentName);
        this.notifyListeners();
    }

    void onLevel(int level) {
        if (this.level != level) {
            this.level = level;
            this.notifyListeners();
        }
    }

    void onAdjust(boolean adjusting) {
        if (this.adjusting != adjusting) {
            this.adjusting = adjusting;
            this.notifyListeners();
        }
    }

    void onOnline(AgentInfo info, Map<String, Dictionary> dictionaries) {
        this.info = info;
        this.dictionaries = info == null ? null : new HashMap<String, Dictionary>(dictionaries);
        this.onLock(this.lockService.getExistingLockForAgent(this.agentName));
    }

    void onLogin(String oldUser, String newUser) {
        this.onLock(this.lock);
    }

    public String getName() {
        return this.agentName;
    }

    public AgentInfo getInfo() {
        return this.info;
    }

    public AgentLock getLock() {
        return this.lock;
    }

    public int getLevel() {
        return this.level;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public LockService.State getState() {
        return this.state;
    }

    public boolean isOnline() {
        return this.dictionaries != null;
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    public Map<String, Dictionary> getDictionaries() {
        return this.dictionaries == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.dictionaries);
    }

    public boolean addListener(ChangeListener listener) {
        return this.listeners.addIfAbsent(listener);
    }

    public boolean removeListener(ChangeListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean removeAllListeners() {
        boolean out = !this.listeners.isEmpty();
        this.listeners.clear();
        return out;
    }

    void notifyListeners() {
        this.listeners.forEach(listener -> {
            try {
                listener.stateChanged(this.changeEvent);
            }
            catch (RuntimeException x) {
                Console.getConsole().getLogger().error((Object)("Error processing lock change event from " + this.getName()), (Throwable)x);
            }
        });
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Locker) {
            return this.getName().equals(((Locker)obj).getName());
        }
        return false;
    }
}

