/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.agent.command;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Option;

public class CommandTargetAgent
extends Agent {
    public CommandTargetAgent() {
        super("worker", AgentInfo.AgentType.WORKER);
    }

    @Command(type=Command.CommandType.QUERY, description="Test sending ACK/NACK. Delays are in seconds.", autoAck=false)
    public Object command(boolean accept, int delayBeforeAck, int delayAfterAck, int timeout, boolean returnException) {
        if (delayBeforeAck > 0) {
            try {
                Thread.sleep((long)delayBeforeAck * 1000L);
            }
            catch (InterruptedException x) {
                return "Interrupted while waiting to send ACK/NACK";
            }
        }
        if (accept) {
            if (timeout > 0) {
                this.sendAck(Duration.ofSeconds(timeout));
            } else {
                this.sendAck(null);
            }
        } else {
            this.sendNack((Serializable)((Object)"Sending NACK as requested."));
            return "NACK";
        }
        if (delayAfterAck > 0) {
            try {
                Thread.sleep((long)delayAfterAck * 1000L);
            }
            catch (InterruptedException x) {
                return "Interrupted while waiting to send the result";
            }
        }
        return returnException ? new RuntimeException("Requsted exception result") : "Done.";
    }

    @Option.List(value={@Option(name="uppercase", description="U"), @Option(name="space", description="S")})
    @Command(type=Command.CommandType.QUERY, description="Test")
    public Object commandWithOptions(Options opts, List<String> list, String s) {
        StringBuilder sb = new StringBuilder("+");
        if (opts.hasOption(new SupportedOption("uppercase"))) {
            sb.append("U");
        }
        if (opts.hasOption(new SupportedOption("space"))) {
            sb.append("S");
        }
        sb.append("+");
        return String.join((CharSequence)sb.toString(), list) + "=" + s;
    }
}

