/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.plugins.tracer.FilterStep;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.MultistepFilter;
import org.lsst.ccs.gconsole.plugins.tracer.Tracer;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;
import org.openide.awt.ColorComboBox;

public final class TracerEditor
extends JDialog {
    private final int C_OR = 0;
    private final int C_MODE = 1;
    private final int C_INVERT = 2;
    private final int C_FORMAT = 3;
    private final int C_TARGET = 4;
    private final int C_METHOD = 5;
    private final int C_CODE = 6;
    private final int C_COLOR = 7;
    private final int C_FLAG = 8;
    private final String[] columnNames = new String[]{"OR", "Mode", "Invert", "Format", "Target", "Operation", "Parameters", "Color", "Flag"};
    private final Class[] columnClasses = new Class[]{Boolean.class, FilterStep.Mode.class, Boolean.class, Boolean.class, FilterStep.Target.class, FilterStep.Method.class, String.class, Color.class, FilteredMessage.Flag.class};
    private final JTable table;
    private final Model model;
    private String title;
    private JButton insertButton;
    private JButton removeButton;
    private JTextField titleField;
    private JButton upButton;
    private JButton downButton;
    private JButton saveButton;
    private JButton saveAsButton;
    private final JButton okButton;
    private final Tracer tracer;
    private boolean cancelled = false;

    private TracerEditor(Tracer tracer, Window parent) {
        super(parent, "Edit Tracer Filter", Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TracerEditor.this.cancelled = true;
            }
        });
        this.tracer = tracer;
        this.title = tracer == null ? "Messages" : tracer.getDescriptor().getName();
        this.model = new Model();
        this.table = new Table(this.model);
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(1);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            int first = this.table.getSelectedRow();
            int count = this.table.getSelectedRowCount();
            this.insertButton.setEnabled(count > 0);
            this.removeButton.setEnabled(count > 0);
            this.upButton.setEnabled(first > 0);
            this.downButton.setEnabled(count > 0 && first + count < this.table.getRowCount());
        });
        this.add((Component)new JScrollPane(this.table), "Center");
        JComboBox<Enum> combo = new JComboBox<Enum>();
        for (FilterStep.Mode state : FilterStep.Mode.values()) {
            combo.addItem(state);
        }
        DefaultCellEditor editor = new DefaultCellEditor(combo);
        editor.setClickCountToStart(1);
        this.table.getColumnModel().getColumn(1).setCellEditor(editor);
        combo = new JComboBox();
        for (FilterStep.Target target : FilterStep.Target.values()) {
            combo.addItem(target);
        }
        editor = new DefaultCellEditor(combo);
        editor.setClickCountToStart(1);
        this.table.getColumnModel().getColumn(4).setCellEditor(editor);
        combo = new JComboBox();
        for (Enum enum_ : FilterStep.Method.values()) {
            combo.addItem(enum_);
        }
        editor = new DefaultCellEditor(combo);
        editor.setClickCountToStart(1);
        this.table.getColumnModel().getColumn(5).setCellEditor(editor);
        this.table.getColumnModel().getColumn(6).setCellRenderer(new CodeRenderer());
        this.table.getColumnModel().getColumn(6).setCellEditor(new CodeEditor());
        this.table.getColumnModel().getColumn(7).setCellRenderer(new ColorRenderer());
        this.table.getColumnModel().getColumn(7).setCellEditor(new ColorEditor());
        Box controls = Box.createHorizontalBox();
        controls.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.add((Component)controls, "North");
        JButton button = new JButton("Add");
        button.setToolTipText("Add step");
        button.addActionListener(e -> {
            TableCellEditor ce = this.table.getCellEditor();
            if (ce == null || ce.stopCellEditing()) {
                this.model.insertRow(this.model.getRowCount());
            }
        });
        controls.add(button);
        controls.add(Box.createHorizontalStrut(10));
        this.insertButton = new JButton("Insert");
        this.insertButton.setToolTipText("Insert step");
        this.insertButton.setEnabled(false);
        this.insertButton.addActionListener(e -> {
            TableCellEditor ce = this.table.getCellEditor();
            if (ce == null || ce.stopCellEditing()) {
                int i = this.table.getSelectedRow();
                this.model.insertRow(i < 0 ? 0 : i);
            }
        });
        controls.add(this.insertButton);
        controls.add(Box.createHorizontalStrut(10));
        this.removeButton = new JButton("Remove");
        this.removeButton.setToolTipText("Remove selected step");
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(e -> {
            TableCellEditor ce = this.table.getCellEditor();
            if (ce == null || ce.stopCellEditing()) {
                this.model.removeRows(this.table.getSelectedRows());
            }
        });
        controls.add(this.removeButton);
        controls.add(Box.createRigidArea(Const.HDIM2));
        controls.add(Box.createHorizontalGlue());
        String tt = "Choose tab title for the viewer";
        JLabel jLabel = new JLabel("Title: ");
        jLabel.setToolTipText(tt);
        controls.add(jLabel);
        this.titleField = new JTextField(this.title);
        this.titleField.setToolTipText(tt);
        this.titleField.addActionListener(e -> {
            this.title = this.titleField.getText().trim();
        });
        controls.add(this.titleField);
        controls.add(Box.createHorizontalGlue());
        controls.add(Box.createRigidArea(Const.HDIM2));
        this.upButton = new JButton(" Up ");
        this.upButton.setToolTipText("Move selected step up in sequence");
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(e -> this.move(-1));
        controls.add(this.upButton);
        controls.add(Box.createHorizontalStrut(10));
        this.downButton = new JButton("Down");
        this.downButton.setToolTipText("Move selected step down in sequence");
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(e -> this.move(1));
        controls.add(this.downButton);
        controls = Box.createHorizontalBox();
        controls.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.add((Component)controls, "South");
        this.saveButton = new JButton("Save");
        this.saveButton.setEnabled(tracer.getDescriptor().getPath() != null);
        this.saveButton.addActionListener(e -> {
            if (this.apply()) {
                PersistenceService.getService().save(tracer.save());
            }
        });
        controls.add(this.saveButton);
        controls.add(Box.createHorizontalStrut(10));
        this.saveAsButton = new JButton("Save As...");
        this.saveAsButton.addActionListener(e -> {
            if (this.apply()) {
                PersistenceService.getService().saveAs(tracer.save(), "Save", this.saveAsButton);
            }
        });
        controls.add(this.saveAsButton);
        controls.add(Box.createHorizontalStrut(20));
        controls.add(Box.createHorizontalGlue());
        JButton applyButton = new JButton("Apply");
        applyButton.addActionListener(e -> this.apply());
        controls.add(applyButton);
        controls.add(Box.createHorizontalStrut(10));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(e -> {
            if (this.apply()) {
                this.dispose();
            }
        });
        controls.add(this.okButton);
        controls.add(Box.createHorizontalStrut(10));
        button = new JButton("Cancel");
        button.addActionListener(e -> this.cancel());
        controls.add(button);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(170);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(170);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(800);
        this.table.getColumnModel().getColumn(7).setPreferredWidth(170);
        this.table.clearSelection();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public static Tracer edit(Tracer tracer, Component parent) {
        Window owner;
        try {
            owner = (Window)((JComponent)parent).getTopLevelAncestor();
        }
        catch (ClassCastException | NullPointerException x) {
            owner = Console.getConsole().getWindow();
            parent = owner;
        }
        TracerEditor dialog = new TracerEditor(tracer, owner);
        dialog.setPreferredSize(new Dimension(800, 600));
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if (dialog.cancelled) {
            throw new CancellationException();
        }
        return tracer;
    }

    private void move(int dir) {
        int begNext;
        TableCellEditor ce = this.table.getCellEditor();
        if (ce != null && !ce.stopCellEditing()) {
            return;
        }
        int begSel = this.table.getSelectedRow();
        int k = this.table.getSelectedRowCount();
        if (k == 0) {
            return;
        }
        int endSel = begSel + k - 1;
        int n = this.table.getRowCount();
        boolean isOrFragment = true;
        for (int i = 0; i < k; ++i) {
            isOrFragment = isOrFragment && this.isOR(begSel + i);
        }
        int n2 = begNext = dir > 0 ? endSel + 1 : begSel - 1;
        if (begNext < 0 || begNext >= n) {
            return;
        }
        boolean bl = isOrFragment = isOrFragment && this.isOR(begNext);
        if (isOrFragment) {
            if (dir > 0) {
                this.model.move(begSel, endSel, begNext, begNext);
                this.table.getSelectionModel().setSelectionInterval(begSel + 1, endSel + 1);
            } else {
                this.model.move(begNext, begNext, begSel, endSel);
                this.table.getSelectionModel().setSelectionInterval(begSel - 1, endSel - 1);
            }
        } else {
            if (this.isOR(begSel)) {
                while (begSel > 0 && this.isOR(begSel - 1)) {
                    --begSel;
                }
            }
            if (this.isOR(endSel)) {
                while (endSel + 1 < n && this.isOR(endSel + 1)) {
                    ++endSel;
                }
            }
            int n3 = begNext = dir > 0 ? endSel + 1 : begSel - 1;
            if (begNext < 0 || begNext >= n) {
                return;
            }
            int endNext = begNext;
            if (this.isOR(endNext)) {
                int bound;
                int n4 = bound = dir > 0 ? n : -1;
                while (endNext + dir != bound && this.isOR(endNext + dir)) {
                    endNext += dir;
                }
            }
            k = endNext - begNext + 1;
            if (dir > 0) {
                this.model.move(begSel, endSel, begNext, endNext);
                this.table.getSelectionModel().setSelectionInterval(begSel + k, endSel + k);
            } else {
                this.model.move(endNext, begNext, begSel, endSel);
                this.table.getSelectionModel().setSelectionInterval(begSel - k, endSel - k);
            }
        }
    }

    private boolean isOR(int rowIndex) {
        return this.model.rows.get((int)rowIndex).or;
    }

    private void validateTable() {
        boolean allValid = this.model.rows.stream().allMatch(step -> step.valid);
        this.okButton.setEnabled(allValid);
        this.saveButton.setEnabled(allValid && this.tracer.getDescriptor().getPath() != null);
        this.saveAsButton.setEnabled(allValid);
    }

    private boolean apply() {
        try {
            MultistepFilter filter = this.model.makeFilter();
            this.tracer.setFilter(filter);
            this.title = this.titleField.getText().trim();
            if (this.title != null && !this.title.isEmpty() && !this.title.equals(this.tracer.getDescriptor().getName())) {
                this.tracer.getDescriptor().setName(this.title);
                if (this.tracer.getPanel() != null) {
                    Console.getConsole().getPanelManager().set(this.tracer.getPanel(), Panel.TITLE, this.title);
                }
            }
            return true;
        }
        catch (Exception x) {
            return false;
        }
    }

    private void cancel() {
        this.cancelled = true;
        this.dispose();
    }

    private void editCode(Step step, Component parent) {
        block2 : switch (step.target) {
            case TEMPLATE: {
                String pattern;
                String template;
                if (step.code.length == 2) {
                    template = step.code[0];
                    pattern = step.code[1];
                } else {
                    template = "";
                    pattern = "";
                }
                TextFieldPanel templatePanel = new TextFieldPanel(template, "Template:", null);
                TextFieldPanel patternPanel = new TextFieldPanel(pattern, "Pattern:", null);
                Box box = Box.createVerticalBox();
                box.add(templatePanel);
                box.add(Box.createRigidArea(new Dimension(0, 10)));
                box.add(patternPanel);
                box.add(Box.createRigidArea(new Dimension(10, 5)));
                int ok = JOptionPane.showConfirmDialog(parent, box, "Filter definition", 2, -1);
                if (ok != 0) break;
                try {
                    step.code = new String[]{templatePanel.get(), patternPanel.get()};
                    step.delegate = null;
                }
                catch (NullPointerException nullPointerException) {}
                break;
            }
            default: {
                switch (step.method) {
                    case REGEX: {
                        this.enterCode(step, "Regular expression:", null, parent);
                        break block2;
                    }
                    case WILDCARD: {
                        this.enterCode(step, "Wildcard:", null, parent);
                        break block2;
                    }
                    case CONTAINS: 
                    case EQUALS: {
                        this.enterCode(step, "String:", null, parent);
                        break block2;
                    }
                    case CLASS: {
                        this.enterCode(step, "Class name:", "Enter full or short class name", parent);
                        break block2;
                    }
                    case NAME: {
                        try {
                            Tracer.Descriptor desc = step.delegate == null ? null : step.delegate.getDescriptor();
                            Tracer t = (Tracer)PersistenceService.getService().make(desc, "Select filter", parent, "Tracer");
                            if (t == null) break block2;
                            step.delegate = t;
                            step.code = FilterStep.getCode(t);
                        }
                        catch (IllegalArgumentException | NullPointerException | CancellationException runtimeException) {}
                        break block2;
                    }
                }
            }
        }
    }

    private void enterCode(Step step, String title, String description, Component parent) {
        TextFieldPanel p = new TextFieldPanel(step.code[0], title, description);
        int ok = JOptionPane.showConfirmDialog(parent, p, "Filter definition", 2, -1);
        if (ok == 0) {
            step.code = new String[]{p.get()};
            step.delegate = null;
        }
    }

    private static class Step {
        boolean or;
        FilterStep.Mode mode;
        boolean invert;
        boolean format;
        FilterStep.Target target;
        FilterStep.Method method;
        String[] code;
        Color color;
        FilteredMessage.Flag flag;
        Tracer delegate;
        boolean valid = true;

        Step() {
            this.or = false;
            this.mode = FilterStep.Mode.ON;
            this.invert = false;
            this.format = true;
            this.target = FilterStep.Target.MESSAGE;
            this.method = FilterStep.Method.CONTAINS;
            this.code = new String[]{""};
            this.color = null;
            this.flag = null;
            this.delegate = null;
        }

        Step(boolean or, FilterStep step) {
            this.or = or;
            this.mode = step.getMode();
            this.invert = step.isInverted();
            this.format = step.isFormatting();
            this.target = step.getTarget();
            this.method = step.getMethod();
            this.code = step.getCode();
            this.color = step.getColor();
            this.flag = step.getFlag();
            this.delegate = step.getDelegate();
        }

        Step(Tracer tracer) {
            this.or = false;
            this.mode = FilterStep.Mode.ON;
            this.invert = false;
            this.format = true;
            this.target = FilterStep.Target.MESSAGE;
            this.method = FilterStep.Method.NAME;
            this.code = FilterStep.getCode(tracer);
            this.color = null;
            this.flag = null;
            this.delegate = tracer;
        }
    }

    private class Model
    extends AbstractTableModel {
        ArrayList<Step> rows;

        Model() {
            MessageFilter filter;
            MessageFilter messageFilter = filter = TracerEditor.this.tracer == null ? null : TracerEditor.this.tracer.getFilter();
            if (filter == null) {
                this.rows = new ArrayList(1);
                this.rows.add(new Step());
            } else if (filter instanceof MultistepFilter) {
                MultistepFilter msFilter = (MultistepFilter)filter;
                int n = msFilter.ors.length;
                this.rows = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    this.rows.add(new Step(msFilter.ors[i], msFilter.steps[i]));
                }
            } else {
                this.rows = new ArrayList(1);
                Tracer copy = (Tracer)PersistenceService.getService().make(TracerEditor.this.tracer.save());
                if (copy == null) {
                    this.rows.add(new Step());
                } else {
                    this.rows.add(new Step(copy));
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return TracerEditor.this.columnClasses[columnIndex];
        }

        @Override
        public String getColumnName(int column) {
            return TracerEditor.this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return TracerEditor.this.columnNames.length - 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Step step = this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return step.or;
                }
                case 1: {
                    return step.mode;
                }
                case 2: {
                    return step.invert;
                }
                case 3: {
                    return step.format;
                }
                case 4: {
                    return step.target;
                }
                case 5: {
                    return step.method;
                }
                case 6: {
                    return step.code;
                }
                case 7: {
                    return step.color;
                }
                case 8: {
                    return step.flag;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            Step step = this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    step.or = (Boolean)value;
                    break;
                }
                case 1: {
                    step.mode = (FilterStep.Mode)((Object)value);
                    break;
                }
                case 2: {
                    step.invert = (Boolean)value;
                    break;
                }
                case 3: {
                    step.format = (Boolean)value;
                    break;
                }
                case 4: {
                    step.target = (FilterStep.Target)((Object)value);
                    switch (step.method) {
                        case NAME: {
                            if (step.target == FilterStep.Target.MESSAGE) break;
                            step.method = FilterStep.Method.CONTAINS;
                            break;
                        }
                        case CLASS: {
                            if (step.target == FilterStep.Target.MESSAGE || step.target == FilterStep.Target.OBJECT) break;
                            step.method = FilterStep.Method.CONTAINS;
                        }
                    }
                    this.validateRow(step, rowIndex, columnIndex);
                    break;
                }
                case 5: {
                    step.method = (FilterStep.Method)((Object)value);
                    switch (step.method) {
                        case NAME: {
                            if (step.target == FilterStep.Target.MESSAGE) break;
                            step.target = FilterStep.Target.MESSAGE;
                            break;
                        }
                        case CLASS: {
                            if (step.target == FilterStep.Target.MESSAGE || step.target == FilterStep.Target.OBJECT) break;
                            step.target = FilterStep.Target.MESSAGE;
                        }
                    }
                    this.validateRow(step, rowIndex, columnIndex);
                    break;
                }
                case 6: {
                    step.code = (String[])value;
                    this.validateRow(step, rowIndex, columnIndex);
                    break;
                }
                case 7: {
                    step.color = (Color)value;
                    break;
                }
                case 8: {
                    step.flag = (FilteredMessage.Flag)((Object)value);
                }
            }
        }

        private void validateRow(Step step, int rowIndex, int columnIndex) {
            boolean wasValid = step.valid;
            try {
                this.makeFilter(step);
                step.valid = true;
            }
            catch (Exception x) {
                step.valid = false;
            }
            if (wasValid != step.valid) {
                TracerEditor.this.validateTable();
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        void insertRow(int i) {
            this.rows.add(i, new Step());
            this.fireTableRowsInserted(i, i);
        }

        void removeRows(int[] ii) {
            if (ii.length == 0) {
                return;
            }
            Arrays.sort(ii);
            int i = ii.length;
            while (i > 0) {
                this.rows.remove(ii[--i]);
            }
            this.fireTableRowsDeleted(ii[0], ii[ii.length - 1]);
            TracerEditor.this.validateTable();
        }

        private void move(int b1, int e1, int b2, int e2) {
            int i;
            int n = this.rows.size();
            ArrayList<Step> newRows = new ArrayList<Step>(n);
            for (i = 0; i < b1; ++i) {
                newRows.add(this.rows.get(i));
            }
            for (i = b2; i <= e2; ++i) {
                newRows.add(this.rows.get(i));
            }
            for (i = b1; i <= e1; ++i) {
                newRows.add(this.rows.get(i));
            }
            for (i = e2 + 1; i < n; ++i) {
                newRows.add(this.rows.get(i));
            }
            this.rows = newRows;
            this.fireTableRowsUpdated(b1, e2);
        }

        private MultistepFilter makeFilter() {
            int nSteps = this.rows.size();
            if (nSteps == 0) {
                return null;
            }
            FilterStep[] steps = new FilterStep[nSteps];
            boolean[] ors = new boolean[nSteps];
            for (int i = 0; i < nSteps; ++i) {
                Step step = this.rows.get(i);
                ors[i] = step.or;
                steps[i] = this.makeFilter(step);
            }
            return new MultistepFilter(steps, ors);
        }

        private FilterStep makeFilter(Step step) {
            if (step.method == FilterStep.Method.NAME) {
                return new FilterStep(step.delegate, step.mode, step.invert, step.format, step.color, step.flag);
            }
            return new FilterStep(step.mode, step.invert, step.format, step.target, step.method, step.code, step.color, step.flag);
        }
    }

    private class Table
    extends JTable {
        Table(TableModel model) {
            super(model);
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            JTableHeader th = new JTableHeader(this.columnModel){

                @Override
                public String getToolTipText(MouseEvent e) {
                    int index = this.columnModel.getColumnIndexAtX(e.getPoint().x);
                    int realIndex = this.columnModel.getColumn(index).getModelIndex();
                    return Table.this.getToolTip(realIndex);
                }
            };
            th.setReorderingAllowed(false);
            return th;
        }

        String getToolTip(int column) {
            switch (column) {
                case 0: {
                    return "Check if this step is a part of an OR group";
                }
                case 1: {
                    StringBuilder sb = new StringBuilder("<html><h3>Mode:</h3><dl>");
                    for (FilterStep.Mode mode : FilterStep.Mode.values()) {
                        sb.append("<dt>").append((Object)mode).append("</dt><dd>").append(mode.getToolTip()).append("</dd>");
                    }
                    return sb.append("</dl></html>").toString();
                }
                case 2: {
                    return "Check if this step acceptance criteria should be inverted";
                }
                case 3: {
                    return "<html>Check if the target string produced by this step should be saved and passed to subsequent filters</html>";
                }
                case 4: {
                    StringBuilder sb = new StringBuilder("<html><b>Target to which this step should be applied:</b><dl>");
                    for (FilterStep.Target target : FilterStep.Target.values()) {
                        sb.append("<dt>").append((Object)target).append("</dt><dd>").append(target.getToolTip()).append("</dd>");
                    }
                    return sb.append("</dl></html>").toString();
                }
                case 5: {
                    StringBuilder sb = new StringBuilder("<html>Operation to be applied to the target.<dl>");
                    for (FilterStep.Method method : FilterStep.Method.values()) {
                        sb.append("<dt>").append((Object)method).append("</dt><dd>").append(method.getToolTip()).append("</dd>");
                    }
                    return sb.append("</dl></html>").toString();
                }
                case 6: {
                    return "Operation parameters (regex, pattern, template definition, etc.)";
                }
                case 7: {
                    return "Color to be assigned to messages that satisfy this filter.";
                }
                case 8: {
                    return "Flag to be added to messages that satisfy this filter.";
                }
            }
            return null;
        }
    }

    private class CodeRenderer
    extends DefaultTableCellRenderer {
        private Color defSelected;
        private Color defUnselected;

        private CodeRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String label;
            if (value == null) {
                value = new String[]{""};
            }
            Step step = ((TracerEditor)TracerEditor.this).model.rows.get(row);
            if (step.method == FilterStep.Method.NAME) {
                label = step.code[0];
                if (step.code.length > 1) {
                    label = label + " ...";
                }
            } else if (step.target == FilterStep.Target.TEMPLATE) {
                if (step.code.length == 2) {
                    label = step.code[0] + " <=> " + step.code[1];
                    if (label.length() > 30) {
                        label = "... <=> ...";
                    }
                } else {
                    label = "";
                }
            } else {
                label = step.code[0];
            }
            if (this.defSelected == null) {
                super.getTableCellRendererComponent(table, label, true, hasFocus, row, column);
                this.defSelected = this.getBackground();
                super.getTableCellRendererComponent(table, label, false, hasFocus, row, column);
                this.defUnselected = this.getBackground();
            }
            super.getTableCellRendererComponent(table, label, isSelected, hasFocus, row, column);
            if (step.valid) {
                this.setBackground(isSelected ? this.defSelected : this.defUnselected);
            } else {
                this.setBackground(Color.RED);
            }
            return this;
        }
    }

    private class CodeEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        Step step;
        private final CodeRenderer renderer;

        CodeEditor() {
            this.renderer = new CodeRenderer();
            this.renderer.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        TracerEditor.this.editCode(CodeEditor.this.step, CodeEditor.this.renderer);
                        CodeEditor.this.fireEditingStopped();
                    }
                }
            });
        }

        public String[] getCellEditorValue() {
            return this.step.code;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.step = ((TracerEditor)TracerEditor.this).model.rows.get(row);
            return this.renderer.getTableCellRendererComponent(table, value, true, true, row, column);
        }
    }

    private class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;

        private ColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 3, 2, 3, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 3, 2, 3, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
            if (value != null) {
                this.setOpaque(true);
                this.setBackground((Color)value);
                this.setText("    ");
            } else {
                this.setOpaque(false);
                this.setText("None");
            }
            return this;
        }
    }

    private class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final ColorComboBox combo = new ColorComboBox(new Color[]{null, Color.RED, Color.GREEN, Color.BLUE, Color.BLACK}, new String[]{"None", "Red", "Green", "Blue", "Black"}, true);

        ColorEditor() {
        }

        @Override
        public Color getCellEditorValue() {
            return this.combo.getSelectedColor();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.combo.setSelectedColor((Color)value);
            return this.combo;
        }
    }

    private static class TextFieldPanel
    extends JPanel
    implements Supplier<String> {
        private JTextField field;

        TextFieldPanel(String seed, String title, String description) {
            this.setLayout(new BoxLayout(this, 1));
            JLabel label = new JLabel(title);
            label.setAlignmentX(0.0f);
            this.add(label);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            this.field = new JTextField(40);
            this.field.setAlignmentX(0.0f);
            if (seed != null) {
                this.field.setText(seed);
            }
            this.field.setToolTipText(description);
            this.add(this.field);
        }

        @Override
        public String get() {
            return this.field.getText();
        }
    }
}

