/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeListener;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.Browser;
import org.lsst.ccs.gconsole.services.lock.LockService;
import org.lsst.ccs.gconsole.services.lock.Locker;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;

public class BrowserOneSubsystem
extends Browser {
    private Descriptor descriptor;
    private AgentPanel agentPanel;
    private LockLabel lockLabel;
    private JLabel levelLabel;
    private JFormattedTextField levelField;
    private Locker agent;
    private LockService.Listener lockServiceProxyListener;
    private ChangeListener agentHandleListener;

    @Override
    public JComponent getPanel() {
        if (this.browserPanel == null) {
            super.getPanel();
            this.agentPanel = new AgentPanel();
            this.browserPanel.add((Component)this.agentPanel, "Center");
            Box lockPanel = Box.createHorizontalBox();
            this.browserPanel.add((Component)lockPanel, "North");
            lockPanel.add(Box.createRigidArea(Const.HDIM));
            this.lockLabel = new LockLabel();
            lockPanel.add(this.lockLabel);
            lockPanel.add(Box.createRigidArea(Const.HDIM));
            this.levelLabel = new JLabel("Level:");
            lockPanel.add(this.levelLabel);
            lockPanel.add(Box.createRigidArea(Const.HDIM));
            this.levelField = new JFormattedTextField((Object)0);
            lockPanel.add(this.levelField);
            this.levelField.setColumns(3);
            this.levelField.setMaximumSize(new Dimension(this.levelField.getPreferredSize().width, Integer.MAX_VALUE));
            this.levelField.addActionListener(e -> {
                try {
                    String s = this.levelField.getText();
                    int level = Integer.parseInt(s);
                    this.service.executeOperation(LockService.Operation.LEVEL, this.getAgentName(), level);
                }
                catch (NumberFormatException x) {
                    Console.getConsole().error("Illegal level format", x);
                }
            });
            lockPanel.add(Box.createRigidArea(Const.HDIM));
            lockPanel.add(this.stateLabel);
            lockPanel.add(Box.createHorizontalGlue());
            this.agentHandleListener = e -> this.updateLockPanel();
            this.lockServiceProxyListener = new LockService.Listener(){

                @Override
                public void agentsAdded(Locker ... agentHandles) {
                    if (BrowserOneSubsystem.this.agent == null) {
                        String name = BrowserOneSubsystem.this.getAgentName();
                        for (Locker agentHandle : agentHandles) {
                            if (!name.equals(agentHandle.getName())) continue;
                            BrowserOneSubsystem.this.agent = agentHandle;
                            BrowserOneSubsystem.this.agent.addListener(BrowserOneSubsystem.this.agentHandleListener);
                            BrowserOneSubsystem.this.updateLockPanel();
                            BrowserOneSubsystem.this.agentPanel.setAgent(BrowserOneSubsystem.this.agent);
                            break;
                        }
                    }
                }

                @Override
                public void agentsRemoved(Locker ... agentHandles) {
                    if (BrowserOneSubsystem.this.agent != null) {
                        for (Locker agentHandle : agentHandles) {
                            if (!BrowserOneSubsystem.this.agent.equals(agentHandle)) continue;
                            BrowserOneSubsystem.this.agentPanel.setAgent(null);
                            BrowserOneSubsystem.this.agent.removeListener(BrowserOneSubsystem.this.agentHandleListener);
                            BrowserOneSubsystem.this.agent = null;
                            BrowserOneSubsystem.this.updateLockPanel();
                            break;
                        }
                    }
                }
            };
            this.service.addListener(this.lockServiceProxyListener);
        }
        return this.browserPanel;
    }

    @Override
    public void shutdown() {
        if (this.agent != null) {
            this.agent.removeListener(this.agentPanel);
        }
        LockService.getService().removeListener(this.lockServiceProxyListener);
        super.shutdown();
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public String getAgentName() {
        return this.descriptor.getAgent();
    }

    private void updateLockPanel() {
        if (this.agent == null) {
            this.stateLabel.setText("OFFLINE");
        }
        Browser.RenderedLock rl = this.renderLock(this.agent);
        this.lockLabel.update(rl);
        this.levelField.setValue(this.agent == null ? 0 : this.agent.getLevel());
    }

    @Override
    public Descriptor save() {
        if (this.agentPanel == null) {
            this.descriptor.setAgentPanel(null);
        } else {
            this.descriptor.setAgentPanel(this.agentPanel.save());
        }
        if (this.browserPanel != null) {
            this.descriptor.setPage(DataPanelDescriptor.get(this.browserPanel));
        }
        return this.descriptor;
    }

    @Override
    public void restore(Serializable descriptor) {
        if (descriptor instanceof Descriptor) {
            AgentPanel.Descriptor apDesc;
            this.descriptor = (Descriptor)descriptor;
            if (this.agentPanel != null && (apDesc = this.descriptor.getAgentPanel()) != null) {
                this.agentPanel.restore(apDesc);
            }
        }
    }

    private final class LockLabel
    extends JLabel
    implements HasPopupItems {
        private Browser.RenderedLock renderedLock;

        LockLabel() {
            this.setMinimumSize(new Dimension(BrowserOneSubsystem.this.ICON_UNLOCKED.getIconWidth(), BrowserOneSubsystem.this.ICON_UNLOCKED.getIconHeight()));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Action act;
                    if (e.getClickCount() == 2 && LockLabel.this.renderedLock != null && (act = ((LockLabel)LockLabel.this).renderedLock.defaultAction) != null) {
                        act.actionPerformed(null);
                    }
                }
            });
        }

        void update(Browser.RenderedLock renderedLock) {
            this.renderedLock = renderedLock;
            this.setIcon(renderedLock.icon);
            this.setToolTipText(renderedLock.tooltip);
            this.setEnabled(renderedLock.enabled);
        }

        public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component componentt, Point point) {
            if (this.renderedLock != null && this.renderedLock.availableActions != null) {
                this.renderedLock.availableActions.forEach(a -> menu.add(new JMenuItem((Action)a)));
            }
            return menu;
        }
    }

    public static class Descriptor
    extends Browser.Descriptor {
    }
}

