/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPreferences;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindowSelector;
import org.lsst.ccs.gconsole.services.rest.LsstRestService;
import org.lsst.ccs.localdb.statusdb.server.AlertEvent;
import org.lsst.ccs.localdb.statusdb.server.AlertInfo;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.StateChange;
import org.lsst.ccs.localdb.statusdb.server.StateInfo;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.server.TrendingResult;
import org.lsst.ccs.utilities.logging.Logger;

public class RestSource {
    public static final String VALUE_KEY = "value";
    static final String ALERT = "alert";
    static final String STATE = "state";
    static final String STRING = "string";
    static final String BOOL = "boolean";
    static final String DOUBLE = "double";
    static final String ARRAY = "array";
    static final String UNKNOWN = "";
    static final String[] BOOL_VALUES = new String[]{"false", "true"};
    static final String[] ALERT_VALUES = new String[]{"NOMINAL", "WARNING", "ALARM"};
    static final int MIN_BEGIN = 604800;
    static final String FLAVOR_RAW = "raw";
    static final String FLAVOR_STAT = "stat";
    private static final Pattern STATE_PATH = Pattern.compile("(?<agent>[\\w\\-]+)/states/(?:(?<component>[\\w\\-/]*)/)?(?<state>[\\w\\-]+)");
    private static final Pattern ALERT_PATH = Pattern.compile("(?<agent>[\\w\\-]+)/alerts/(?<alert>[\\w\\-/]+)");
    private static final Pattern LONG = Pattern.compile("[\\d]+");
    private final LsstTrendingPlugin plugin;
    private final TrendingPreferences pref;
    private final LsstRestService restService;
    private final Executor dataFetcher;
    private final Logger logger;
    private final Map<String, String> channels = new LinkedHashMap<String, String>();
    private volatile int begin;
    private static final Map<String, Map<String, String[]>> stateValues = new ConcurrentHashMap<String, Map<String, String[]>>();
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();
    private final TimeWindowSelector.Listener timeListener;
    private final ChangeListener restListener;

    RestSource(LsstTrendingPlugin plugin) {
        this.plugin = plugin;
        this.pref = plugin.getPreferences();
        this.restService = (LsstRestService)plugin.getConsole().getConsoleLookup().lookup(LsstRestService.class);
        this.dataFetcher = plugin.getExecutor();
        this.logger = plugin.getConsole().getLogger();
        this.timeListener = event -> this.onTimeWindowChange(event.getTimeWindow());
        this.restListener = event -> this.onRestServerChange();
    }

    RestSource(LsstRestService restService) {
        this.plugin = null;
        this.pref = null;
        this.restService = restService;
        this.dataFetcher = r -> r.run();
        this.logger = Logger.getLogger((String)"test");
        this.timeListener = null;
        this.restListener = null;
    }

    void start() {
        this.plugin.getTimeWindowSelector().addListener(this.timeListener);
        this.restService.addListener(this.restListener);
        this.onTimeWindowChange(this.plugin.getSelectedTimeWindow());
    }

    void stop() {
        TimeWindowSelector ts = this.plugin.getTimeWindowSelector();
        if (ts != null) {
            ts.removeListener(this.timeListener);
        }
        this.restService.removeListener(this.restListener);
    }

    public void refresh() {
        this.dataFetcher.execute(this::refreshChannelList);
    }

    private void onRestServerChange() {
        this.refresh();
    }

    private void onTimeWindowChange(TimeWindow timeWindow) {
        int time = timeWindow == null ? 604800 : (int)Math.max(604800L, (System.currentTimeMillis() - timeWindow.getLowerEdge()) / 1000L + 3600L);
        if (time != this.begin) {
            this.begin = time;
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshChannelList() {
        List<Object> alertChannels;
        List<Object> stateChannels;
        List<Object> dataChannels;
        try {
            DataChannel.DataChannelList channelList = this.restService.getTrendingList(this.begin);
            dataChannels = channelList == null || channelList.list == null || channelList.list.isEmpty() ? Collections.emptyList() : channelList.list;
        }
        catch (RuntimeException e) {
            this.logger.warn((Object)"Unable to retrieve the list of channels from the REST server.");
            dataChannels = Collections.emptyList();
        }
        try {
            DataChannel.DataChannelList channelList = this.restService.getStateList(this.begin);
            stateChannels = channelList == null || channelList.list == null || channelList.list.isEmpty() ? Collections.emptyList() : channelList.list;
        }
        catch (RuntimeException e) {
            this.logger.warn((Object)"Unable to retrieve the list of states from the REST server.");
            stateChannels = Collections.emptyList();
        }
        try {
            AlertInfo.AlertInfoList channelList = this.restService.getAlertList(this.begin);
            alertChannels = channelList == null || channelList.list == null || channelList.list.isEmpty() ? Collections.emptyList() : channelList.list;
        }
        catch (RuntimeException e) {
            this.logger.warn((Object)"Unable to retrieve the list of alerts from the REST server.");
            alertChannels = Collections.emptyList();
        }
        Map<String, String> map = this.channels;
        synchronized (map) {
            if (this.channels.size() != dataChannels.size() + stateChannels.size() + alertChannels.size()) {
                this.channels.clear();
                HashSet agents = new HashSet(128);
                dataChannels.forEach(c -> {
                    String path = String.join((CharSequence)"/", c.getPath());
                    String type = RestSource.convertType((String)c.getMetadata().get("type"));
                    this.channels.put(path, type);
                    agents.add(c.getPath()[0]);
                });
                HashMap cache = new HashMap();
                HashMap<String, Map> agent2values = new HashMap<String, Map>();
                String[] S0 = new String[]{};
                stateChannels.forEach(c -> {
                    String[] ss = c.getPath();
                    String agent = ss[0];
                    String path = agent + "/states/" + String.join((CharSequence)"/", Arrays.asList(ss).subList(1, ss.length));
                    String type = (String)c.getMetadata().get("type");
                    if (type != null && type.contains(".")) {
                        String[] values = (String[])cache.get(type);
                        if (values == null) {
                            try {
                                Class<?> cl = Class.forName(type);
                                if (cl.isEnum()) {
                                    values = Arrays.stream(cl.getEnumConstants()).map(e -> e.toString()).collect(Collectors.toList()).toArray(S0);
                                }
                            }
                            catch (ClassNotFoundException e2) {
                                cache.put(type, S0);
                            }
                        }
                        if (values != null && values != S0) {
                            Map<String, String[]> state2values = (Map<String, String[]>)agent2values.get(agent);
                            if (state2values == null) {
                                state2values = Collections.synchronizedMap(new HashMap());
                                agent2values.put(agent, state2values);
                            }
                            String state = ss[ss.length - 1];
                            state2values.putIfAbsent(state, values);
                        }
                    }
                    this.channels.put(path, STATE);
                });
                agent2values.forEach((agent, state2values) -> {
                    Map<String, String[]> old = stateValues.get(agent);
                    if (old == null) {
                        stateValues.put((String)agent, (Map<String, String[]>)state2values);
                    } else {
                        state2values.forEach((state, values) -> old.putIfAbsent((String)state, (String[])values));
                    }
                });
                alertChannels.forEach(c -> {
                    String agent = c.getSubsystemName();
                    if (agents.contains(agent)) {
                        String alertID = c.getAlertId();
                        long id = c.getId();
                        String path = agent + "/alerts/" + alertID;
                        this.channels.put(path, Long.toString(id));
                    }
                });
                this.fireEvent();
            }
        }
    }

    public void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    protected void fireEvent() {
        SwingUtilities.invokeLater(() -> {
            ChangeEvent event = new ChangeEvent(this);
            this.listeners.forEach(listener -> {
                block2: {
                    try {
                        listener.stateChanged(event);
                    }
                    catch (RuntimeException x) {
                        if (this.logger == null) break block2;
                        this.logger.error((Object)(listener + " threw an exception while processing RestSource event"), (Throwable)x);
                    }
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChannels() {
        Map<String, String> map = this.channels;
        synchronized (map) {
            return new ArrayList<String>(this.channels.keySet());
        }
    }

    public ArrayList<TrendData> get(List<Trend> trends, long begin, long end, Boolean raw, Integer nBins) {
        nBins = nBins == null ? this.pref.getNBins() : nBins.intValue();
        raw = raw == null ? this.pref.isUseRawData() : raw.booleanValue();
        boolean separateStrings = raw == false || nBins != 0;
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put(ALERT, ALERT);
        filter.put(STATE, STATE);
        if (separateStrings) {
            filter.put(STRING, STRING);
            filter.put(BOOL, STRING);
        }
        LinkedHashMap<String, ArrayList<Trend>> groupTrends = new LinkedHashMap<String, ArrayList<Trend>>(2 * trends.size());
        ArrayList<String> groups = new ArrayList<String>(trends.size());
        for (Trend trend : trends) {
            String string = this.getType(trend);
            String group = filter.getOrDefault(string, DOUBLE);
            ArrayList<Trend> tt = (ArrayList<Trend>)groupTrends.get(group);
            if (tt == null) {
                tt = new ArrayList<Trend>(trends.size());
                groupTrends.put(group, tt);
            }
            tt.add(trend);
            groups.add(group);
        }
        LinkedHashMap<String, List<TrendData>> groupOut = new LinkedHashMap<String, List<TrendData>>(2 * trends.size());
        for (Map.Entry entry : groupTrends.entrySet()) {
            groupOut.put((String)entry.getKey(), this.getGroup((List)entry.getValue(), begin, end, raw, nBins));
        }
        ArrayList<TrendData> arrayList = new ArrayList<TrendData>(trends.size());
        LinkedHashMap linkedHashMap = new LinkedHashMap(2 * trends.size());
        for (Map.Entry e : groupOut.entrySet()) {
            linkedHashMap.put((String)e.getKey(), ((List)e.getValue()).iterator());
        }
        for (String group : groups) {
            arrayList.add((TrendData)((Iterator)linkedHashMap.get(group)).next());
        }
        return arrayList;
    }

    List<TrendData> getGroup(List<Trend> trends, long begin, long end, boolean raw, int nBins) {
        if (trends.isEmpty()) {
            return Collections.emptyList();
        }
        boolean cache = true;
        long beginCache = 0L;
        long endCache = Long.MAX_VALUE;
        for (Trend trend : trends) {
            TrendData data = trend.getData();
            if (data == null) {
                cache = false;
            } else {
                switch (data.getType()) {
                    case "double": {
                        cache = cache && data.isRawUnbinned() && raw && nBins == 0;
                        cache = cache && begin >= data.getLowT();
                        break;
                    }
                    case "state": 
                    case "alert": {
                        break;
                    }
                    case "string": 
                    case "boolean": {
                        cache = cache && (data.isRawUnbinned() && raw && nBins == 0 || data.getBins() == nBins);
                        break;
                    }
                    default: {
                        cache = false;
                    }
                }
            }
            if (!cache) break;
            beginCache = Math.max(beginCache, data.getLowT());
            endCache = Math.min(endCache, data.getHighT());
        }
        cache = cache && beginCache < endCache;
        long beginQuery = begin;
        long endQuery = end;
        if (cache) {
            if (beginCache <= begin && endCache > begin) {
                beginQuery = endCache;
            }
            if (beginCache < end && endCache >= end) {
                endQuery = beginCache;
            }
        }
        int nTrends = trends.size();
        Result[] r = beginQuery < endQuery ? this.fetch(trends, beginQuery, endQuery, raw, nBins) : new Result[nTrends];
        ArrayList<TrendData> out = new ArrayList<TrendData>(nTrends);
        for (int i = 0; i < nTrends; ++i) {
            out.add(this.merge(trends.get(i), r[i], begin, end, raw, nBins));
        }
        return out;
    }

    Result[] fetch(List<Trend> trends, long begin, long end, boolean raw, int nBins) {
        String type;
        if (trends.isEmpty()) {
            return new Result[0];
        }
        switch (type = this.getType(trends.get(0))) {
            case "state": {
                return this.fetchState(trends, begin, end);
            }
            case "alert": {
                return this.fetchAlert(trends, begin, end);
            }
        }
        return this.fetchTrending(trends, begin, end, raw, nBins);
    }

    Result[] fetchTrending(List<Trend> trends, long begin, long end, boolean raw, int nBins) {
        TrendingResult[] out;
        String[] paths = trends.stream().map(trend -> trend.getDescriptor().getPath()).collect(Collectors.toList()).toArray(new String[0]);
        if (raw && nBins == 0) {
            out = this.restService.getTrendingData(begin, end, FLAVOR_RAW, nBins, paths);
        } else {
            String type;
            switch (type = this.getType(trends.get(0))) {
                case "string": 
                case "boolean": {
                    out = this.restService.getTrendingData(begin, end, FLAVOR_RAW, 0, paths);
                    break;
                }
                default: {
                    String flavor = nBins > 0 ? (raw ? null : FLAVOR_STAT) : (raw ? FLAVOR_RAW : FLAVOR_STAT);
                    out = this.restService.getTrendingData(begin, end, flavor, nBins, paths);
                }
            }
        }
        return Result.make(paths, begin, end, raw, nBins, out);
    }

    Result[] fetchState(List<Trend> trends, long begin, long end) {
        String[] paths = trends.stream().map(trend -> trend.getDescriptor().getPath()).collect(Collectors.toList()).toArray(new String[0]);
        LinkedHashMap<String, String> path2agent = new LinkedHashMap<String, String>(trends.size() * 2);
        LinkedHashMap<String, StateQueryInfo> agent2info = new LinkedHashMap<String, StateQueryInfo>(trends.size() * 2);
        for (Trend trend2 : trends) {
            String path = trend2.getDescriptor().getPath();
            StateID id = StateID.parse(path);
            if (id == null) continue;
            path2agent.put(path, id.agent);
            StateQueryInfo info = (StateQueryInfo)agent2info.get(id.agent);
            if (info == null) {
                info = new StateQueryInfo(id.agent);
                agent2info.put(id.agent, info);
            }
            info.components.add(id.component);
            info.states.add(id.state);
        }
        HashMap<String, List<StateChange>> agent2result = new HashMap<String, List<StateChange>>(agent2info.size() * 2);
        for (StateQueryInfo info : agent2info.values()) {
            agent2result.put(info.agent, this.restService.getStateTransitions(begin, end, info.agent, info.components, info.states));
        }
        List[] listArray = new List[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            listArray[i] = (List)agent2result.get(path2agent.get(paths[i]));
        }
        return Result.make(paths, begin, end, listArray);
    }

    Result[] fetchAlert(List<Trend> trends, long begin, long end) {
        int n = trends.size();
        String[] paths = new String[n];
        String[] ids = new String[n];
        Iterator<Trend> it = trends.iterator();
        for (int i = 0; i < n; ++i) {
            Trend trend = it.next();
            paths[i] = trend.getDescriptor().getPath();
            ids[i] = this.channels.getOrDefault(paths[i], "NO_SUCH_ALERT");
        }
        List<AlertEvent> out = this.restService.geAlerts(begin, end, ids);
        return Result.make(paths, begin, end, out);
    }

    TrendData merge(Trend trend, Result result, long begin, long end, boolean raw, int nBins) {
        String resultType;
        String type = this.getType(trend);
        if (result != null && (resultType = result.getType()) != null && !UNKNOWN.equals(resultType) && !resultType.equals(type)) {
            trend.setType(resultType);
            type = resultType;
        }
        long beginQuery = result == null ? Long.MAX_VALUE : result.begin;
        long endQuery = result == null ? 0L : result.end;
        Data cache = null;
        Data query = null;
        if (beginQuery <= begin) {
            if (endQuery >= end) {
                if (DOUBLE.equals(type)) {
                    return this.mergeDouble(null, result, begin, end, raw, nBins);
                }
                query = Data.make(result, begin, end, raw, nBins);
                return this.stitch(query, null, begin, end, raw, nBins, trend);
            }
            if (endQuery >= begin) {
                if (DOUBLE.equals(type)) {
                    return trend.getData();
                }
                query = Data.make(result, begin, endQuery, raw, nBins);
                cache = Data.make(trend, endQuery, end, raw, nBins);
                return this.stitch(query, cache, begin, end, raw, nBins, trend);
            }
            if (DOUBLE.equals(type)) {
                return RestSource.cut(trend.getData(), begin, end);
            }
            cache = Data.make(trend, begin, end, raw, nBins);
            return this.stitch(cache, null, begin, end, raw, nBins, trend);
        }
        if (beginQuery < end && endQuery >= end) {
            if (DOUBLE.equals(type)) {
                return this.mergeDouble(trend, result, begin, end, raw, nBins);
            }
            cache = Data.make(trend, begin, beginQuery, raw, nBins);
            query = Data.make(result, beginQuery, end, raw, nBins);
            return this.stitch(cache, query, begin, end, raw, nBins, trend);
        }
        if (DOUBLE.equals(type)) {
            return RestSource.cut(trend.getData(), begin, end);
        }
        cache = Data.make(trend, begin, end, raw, nBins);
        return this.stitch(cache, null, begin, end, raw, nBins, trend);
    }

    TrendData mergeDouble(Trend trend, Result queryData, long begin, long end, boolean raw, int nBins) {
        List metaList;
        String key;
        long[] times;
        TrendData cachedData = trend == null ? null : trend.getData();
        TrendingResult newData = queryData == null ? null : (TrendingResult)queryData.data;
        Map<Object, Object> values = new HashMap();
        Map<String, ArrayList<TrendData.MetaValue>> meta = new HashMap();
        int oldN = 0;
        int index = 0;
        long[] oldTime = null;
        if (cachedData != null) {
            oldTime = cachedData.getTimes();
            index = Arrays.binarySearch(oldTime, begin);
            if (index < 0) {
                index = -index - 1;
            }
            oldN = oldTime.length - index;
        }
        int newN = 0;
        TrendingData[] dataArray = null;
        if (newData != null && (dataArray = newData.getTrendingDataArray()) != null) {
            newN = dataArray.length;
        }
        int n = oldN + newN;
        if (oldN == 0) {
            times = new long[n];
        } else {
            times = Arrays.copyOfRange(oldTime, index, index + n);
            for (String key2 : cachedData.getOnPointKeys()) {
                values.put(key2, Arrays.copyOfRange(cachedData.getValues(key2), index, index + n));
            }
        }
        index = oldN;
        if (newN > 0) {
            for (TrendingData td : dataArray) {
                for (TrendingData.DataValue dv : td.getDatavalue()) {
                    String key3 = dv.getName();
                    double[] vv = (double[])values.get(key3);
                    if (vv == null) {
                        vv = new double[n];
                        values.put(key3, vv);
                    }
                    vv[index] = dv.getValue();
                }
                times[index++] = td.getAxisvalue().getValue();
            }
        }
        if (cachedData != null) {
            Map<String, ArrayList<TrendData.MetaValue>> cachedMeta = cachedData.getOffPointMetadata();
            for (Map.Entry<String, ArrayList<TrendData.MetaValue>> e : cachedMeta.entrySet()) {
                key = e.getKey();
                ArrayList<TrendData.MetaValue> newList = new ArrayList<TrendData.MetaValue>();
                for (TrendData.MetaValue mp : e.getValue()) {
                    TrendData.MetaValue mv = TrendData.MetaValue.trim(mp, begin, end);
                    if (mv == null) continue;
                    newList.add(mv);
                }
                if (newList.isEmpty()) continue;
                meta.put(key, newList);
            }
        }
        if (newData != null && (metaList = newData.getChannelMetadata()) != null) {
            for (ChannelMetaData md : metaList) {
                key = md.getName();
                ArrayList<TrendData.MetaValue> mvList = (ArrayList<TrendData.MetaValue>)meta.get(key);
                if (mvList == null) {
                    TrendData.MetaValue mv = TrendData.MetaValue.trim(md, begin, end);
                    if (mv == null) continue;
                    mvList = new ArrayList<TrendData.MetaValue>();
                    mvList.add(mv);
                    meta.put(key, mvList);
                    continue;
                }
                TrendData.MetaValue last = (TrendData.MetaValue)mvList.get(mvList.size() - 1);
                TrendData.MetaValue mv = TrendData.MetaValue.trim(md, last.getStop(), end);
                if (mv == null) continue;
                TrendData.MetaValue merge = TrendData.MetaValue.merge(last, mv);
                if (merge == null) {
                    mvList.add(mv);
                    continue;
                }
                mvList.set(mvList.size() - 1, merge);
            }
        }
        if (values.isEmpty()) {
            values = Collections.emptyMap();
        } else if (values.size() == 1) {
            Map.Entry e = values.entrySet().iterator().next();
            values = Collections.singletonMap((String)e.getKey(), (double[])e.getValue());
        }
        if (meta.isEmpty()) {
            meta = Collections.emptyMap();
        } else {
            meta.values().forEach(list -> list.trimToSize());
        }
        TrendData trd = new TrendData(times, values, meta, new long[]{begin, end}, raw, nBins);
        return trd;
    }

    TrendData stitch(Data d1, Data d2, long begin, long end, boolean raw, int nBins, Trend trend) {
        String type;
        if (d1 == null) {
            return null;
        }
        String[] names = null;
        switch (type = this.getType(trend)) {
            case "boolean": 
            case "string": 
            case "state": 
            case "alert": {
                names = Data.mergeNames(trend.getValues(), d1, d2);
                break;
            }
            default: {
                throw new IllegalArgumentException("cannot stitch data of type " + type);
            }
        }
        boolean endpointsAllowed = !raw || nBins != 0 || STATE.equals(type) || ALERT.equals(type);
        int n = 0;
        boolean needsBefore = endpointsAllowed && RestSource.valid(d1.beforeValue()) && (!RestSource.valid(d1.firstTime()) || d1.firstTime() > begin + Math.max((end - begin) / 50L, 1L));
        boolean bl = needsBefore = needsBefore || d1.size() == 0 && d2 != null && RestSource.valid(d2.beforeValue()) && (!RestSource.valid(d2.firstTime()) || d2.firstTime() > begin + Math.max((end - begin) / 50L, 1L));
        if (needsBefore) {
            ++n;
        }
        n += d1.size();
        Data lastData = d1;
        boolean needsBetween = false;
        if (d2 != null) {
            boolean bl2 = needsBetween = (STATE.equals(type) || ALERT.equals(type)) && d2.size() > 0 && RestSource.valid(d1.afterValue()) && !RestSource.equal(d1.afterValue(), d2.firstValue());
            if (needsBetween) {
                ++n;
            }
            lastData = d2;
            n += d2.size();
        }
        boolean needsAfter = endpointsAllowed && RestSource.valid(lastData.afterValue()) && (!RestSource.valid(lastData.lastTime()) || lastData.lastTime() < end - Math.max((end - begin) / 50L, 1L));
        boolean bl3 = needsAfter = needsAfter || endpointsAllowed && d2 != null && d2.size() == 0 && RestSource.valid(d1.afterValue()) && (!RestSource.valid(d1.lastTime()) || d1.lastTime() < end - Math.max((end - begin) / 50L, 1L));
        if (needsAfter) {
            ++n;
        }
        long[] times = new long[n];
        double[] values = new double[n];
        int index = 0;
        if (needsBefore) {
            times[index] = begin;
            double d = values[index++] = RestSource.valid(d1.beforeValue()) ? d1.beforeValue() : d2.beforeValue();
        }
        while (d1.hasNext()) {
            d1.next();
            times[index] = d1.time();
            values[index++] = d1.value();
        }
        if (d2 != null) {
            if (needsBetween) {
                times[index] = d2.firstTime();
                values[index++] = d1.afterValue();
            }
            while (d2.hasNext()) {
                d2.next();
                times[index] = d2.time();
                values[index++] = d2.value();
            }
        }
        if (needsAfter) {
            times[index] = end;
            values[index++] = RestSource.valid(lastData.afterValue()) ? lastData.afterValue() : d1.afterValue();
        }
        return new TrendData(times, values, new long[]{begin, end}, names, this.getType(trend), raw, nBins);
    }

    static TrendData cut(TrendData data, long begin, long end) {
        long[] times;
        int stop;
        if (data == null || end <= begin) {
            return null;
        }
        long[] dataTimeRange = data.getTimeRange();
        if (dataTimeRange[0] > begin || dataTimeRange[1] < end) {
            return null;
        }
        Map<String, Object> values = new HashMap<String, double[]>();
        Map<String, ArrayList<TrendData.MetaValue>> meta = new HashMap();
        long[] oldTime = data.getTimes();
        int start = Arrays.binarySearch(oldTime, begin);
        if (start < 0) {
            start = -start - 1;
        }
        stop = (stop = Arrays.binarySearch(oldTime, end)) < 0 ? -stop - 1 : ++stop;
        if (stop > start) {
            times = Arrays.copyOfRange(oldTime, start, stop);
            for (String string : data.getOnPointKeys()) {
                values.put(string, Arrays.copyOfRange(data.getValues(string), start, stop));
            }
        } else {
            times = new long[]{};
            for (String string : data.getOnPointKeys()) {
                values.put(string, new double[0]);
            }
        }
        Map<String, ArrayList<TrendData.MetaValue>> cachedMeta = data.getOffPointMetadata();
        for (Map.Entry<String, ArrayList<TrendData.MetaValue>> entry : cachedMeta.entrySet()) {
            String key = entry.getKey();
            ArrayList<TrendData.MetaValue> newList = new ArrayList<TrendData.MetaValue>();
            for (TrendData.MetaValue mp : entry.getValue()) {
                TrendData.MetaValue mv = TrendData.MetaValue.trim(mp, begin, end);
                if (mv == null) continue;
                newList.add(mv);
            }
            if (newList.isEmpty()) continue;
            meta.put(key, newList);
        }
        if (values.isEmpty()) {
            values = Collections.emptyMap();
        } else if (values.size() == 1) {
            Map.Entry entry = values.entrySet().iterator().next();
            values = Collections.singletonMap((String)entry.getKey(), (double[])entry.getValue());
        }
        if (meta.isEmpty()) {
            meta = Collections.emptyMap();
        } else {
            meta.values().forEach(list -> list.trimToSize());
        }
        return new TrendData(times, values, meta, new long[]{begin, end}, true, 0);
    }

    private static String convertType(String rawType) {
        if (rawType == null) {
            return UNKNOWN;
        }
        switch (rawType) {
            case "java.lang.String": {
                return STRING;
            }
            case "trending": {
                return UNKNOWN;
            }
            case "boolean": {
                return BOOL;
            }
            case "double": 
            case "int": 
            case "long": {
                return DOUBLE;
            }
            case "state": {
                return STATE;
            }
        }
        if (rawType.contains("[]")) {
            return ARRAY;
        }
        if (rawType.contains("org.lsst.ccs.")) {
            return STRING;
        }
        return rawType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getType(Trend trend) {
        String type = trend.getType();
        if (type == null) {
            String path = trend.getDescriptor().getPath();
            Map<String, String> map = this.channels;
            synchronized (map) {
                type = this.channels.get(path);
            }
            if (type == null) {
                if (STATE_PATH.matcher(path).matches()) {
                    type = STATE;
                }
            } else if (LONG.matcher(type).matches()) {
                type = ALERT;
            }
            if (type != null) {
                trend.setType(type);
                String[] values = null;
                switch (type) {
                    case "boolean": {
                        values = BOOL_VALUES;
                        break;
                    }
                    case "state": {
                        StateInfo.StateInfoList infoList;
                        StateID sid = StateID.parse(trend.getDescriptor().getPath());
                        Map<String, String[]> state2values = stateValues.get(sid.agent);
                        if (state2values == null) {
                            StateInfo.StateInfoList infoList2 = this.restService.getStateInfo(sid.agent);
                            if (infoList2 == null) break;
                            state2values = new HashMap<String, String[]>();
                            for (StateInfo info : infoList2.stateInfoList) {
                                String[] vv = new ArrayList(info.getStateValues()).toArray(new String[0]);
                                state2values.put(info.getStateClass(), vv);
                            }
                            values = state2values.get(sid.state);
                            state2values = Collections.synchronizedMap(state2values);
                            stateValues.put(sid.agent, state2values);
                            break;
                        }
                        values = state2values.get(sid.state);
                        if (values != null || (infoList = this.restService.getStateInfo(sid.agent)) == null) break;
                        for (StateInfo info : infoList.stateInfoList) {
                            String[] vv = new ArrayList(info.getStateValues()).toArray(new String[0]);
                            state2values.put(info.getStateClass(), vv);
                        }
                        values = state2values.get(sid.state);
                        break;
                    }
                    case "alert": {
                        values = ALERT_VALUES;
                        break;
                    }
                    default: {
                        if (!type.contains(".")) break;
                        try {
                            Class<?> c = Class.forName(type);
                            if (!c.isEnum()) break;
                            values = Arrays.stream(c.getEnumConstants()).map(e -> e.toString()).collect(Collectors.toList()).toArray(new String[0]);
                            break;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                trend.setValues(values);
            }
        }
        return type == null ? UNKNOWN : type;
    }

    private static boolean equal(double d1, double d2) {
        return Math.round(d1) == Math.round(d2);
    }

    private static boolean valid(double d) {
        return d > -0.5;
    }

    private static boolean valid(long l) {
        return l > 0L;
    }

    private static int toInt(double d) {
        return (int)Math.round(d);
    }

    private static Set<String> getValidStateValues(StateID sid) {
        Map<String, String[]> state2values = stateValues.get(sid.agent);
        if (state2values == null) {
            return Collections.emptySet();
        }
        String[] values = state2values.get(sid.state);
        return values == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(values));
    }

    private static final class DataStringQuery
    implements Data {
        private long begin;
        private long end;
        private long[] times;
        private String[] values;
        private int size;
        private Map<String, Double> str2value;
        int index;

        DataStringQuery(Result result, long begin, long end, boolean raw, int nBins) {
            this.begin = begin;
            this.end = end;
            this.str2value = new HashMap<String, Double>();
            switch (result.getType()) {
                case "state": {
                    this.initState(result);
                    break;
                }
                case "alert": {
                    this.initAlert(result);
                    break;
                }
                default: {
                    this.initString(result, raw, nBins);
                }
            }
            this.index = 0;
        }

        void initString(Result result, boolean raw, int nBins) {
            TrendingData[] tds;
            if (result != null && (tds = result.getTrendingResult().getTrendingDataArray()) != null && tds.length > 0) {
                long gap = nBins == 0 ? (raw ? 0L : Long.MAX_VALUE) : (this.end - this.begin) / (long)nBins;
                this.times = new long[tds.length + 2];
                this.values = new String[tds.length + 2];
                Object prev = null;
                for (int i = 0; i < tds.length; ++i) {
                    TrendingData td = tds[i];
                    long t = td.getAxisvalue().getValue();
                    String s = tds[i].getStrValue(RestSource.VALUE_KEY);
                    if (s == null) continue;
                    if (t < this.begin) {
                        this.values[0] = s;
                        continue;
                    }
                    if (t < this.end) {
                        this.str2value.put(s, null);
                        if (gap == 0L || this.index < 2 || !s.equals(this.values[this.index]) || !s.equals(this.values[this.index - 1]) || t - this.times[this.index - 1] > gap) {
                            ++this.index;
                        }
                        this.times[this.index] = t;
                        this.values[this.index] = s;
                        continue;
                    }
                    this.values[this.index + 1] = s;
                    break;
                }
                this.size = this.index;
                if (!Objects.equals(this.values[0], this.values[1])) {
                    this.values[0] = null;
                }
                if (!Objects.equals(this.values[this.size], this.values[this.size + 1])) {
                    this.values[this.size + 1] = null;
                }
            }
        }

        void initState(Result result) {
            List<StateChange> data = result.getStateChanges();
            if (data.isEmpty()) {
                return;
            }
            StateID sid = StateID.parse(result.path);
            Set validValues = RestSource.getValidStateValues(sid);
            this.times = new long[2 * data.size() + 2];
            this.values = new String[2 * data.size() + 2];
            this.index = 0;
            String prev = null;
            boolean skip = true;
            ListIterator<StateChange> it = data.listIterator();
            while (it.hasNext()) {
                StateChange sc = it.next();
                String value = sc.getState(sid.component, sid.state);
                if (value == null || !validValues.contains(value)) continue;
                long t = sc.getTime();
                if (!skip || t >= this.begin) {
                    if (skip) {
                        this.values[0] = prev;
                        skip = false;
                    }
                    if (t >= this.end) break;
                    if (prev != null && !prev.equals(value)) {
                        this.times[++this.index] = t;
                        this.values[this.index] = prev;
                    }
                    this.times[++this.index] = t;
                    this.values[this.index] = value;
                }
                prev = value;
            }
            this.size = this.index++;
            this.values[this.index] = prev;
        }

        void initAlert(Result result) {
            List<AlertEvent> data = result.getAlerts();
            if (data.isEmpty()) {
                return;
            }
            AlertID sid = AlertID.parse(result.path);
            if (sid == null) {
                return;
            }
            HashSet<String> validValues = new HashSet<String>(Arrays.asList(ALERT_VALUES));
            this.times = new long[2 * data.size() + 2];
            this.values = new String[2 * data.size() + 2];
            this.index = 0;
            String prev = null;
            boolean skip = true;
            ListIterator<AlertEvent> it = data.listIterator();
            while (it.hasNext()) {
                AlertEvent sc = it.next();
                String value = sc.getSeverity().toString();
                if (value == null || !validValues.contains(value) || !sid.alertID.equals(sc.getAlertId())) continue;
                long t = sc.getTime();
                if (!skip || t >= this.begin) {
                    if (skip) {
                        this.values[0] = prev;
                        skip = false;
                    }
                    if (t >= this.end) break;
                    if (prev != null && !prev.equals(value)) {
                        this.times[++this.index] = t;
                        this.values[this.index] = prev;
                    }
                    this.times[++this.index] = t;
                    this.values[this.index] = value;
                }
                prev = value;
            }
            this.size = this.index++;
            if (this.size == 0) {
                this.values[0] = prev;
            }
            this.values[this.index] = prev;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void rewind() {
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public long time() {
            return this.times[this.index];
        }

        @Override
        public double value() {
            return this.str2value.get(this.values[this.index]);
        }

        @Override
        public long begin() {
            return this.begin;
        }

        @Override
        public long end() {
            return this.end;
        }

        @Override
        public long firstTime() {
            return this.size > 0 ? this.times[1] : -1L;
        }

        @Override
        public double firstValue() {
            return this.size > 0 ? this.str2value.get(this.values[1]) : -1.0;
        }

        @Override
        public long lastTime() {
            return this.size > 0 ? this.times[this.size] : -1L;
        }

        @Override
        public double lastValue() {
            return this.size > 0 ? this.str2value.get(this.values[this.size]) : -1.0;
        }

        @Override
        public double beforeValue() {
            Double d = this.values == null || this.values[0] == null ? -1.0 : this.str2value.get(this.values[0]);
            return d == null ? -1.0 : d;
        }

        @Override
        public double afterValue() {
            Double d = this.values == null || this.values[this.size + 1] == null ? -1.0 : this.str2value.get(this.values[this.size + 1]);
            return d == null ? -1.0 : d;
        }

        @Override
        public void setMap(String[] names) {
            this.str2value = new HashMap<String, Double>();
            for (int i = 0; i < names.length; ++i) {
                this.str2value.put(names[i], Double.valueOf(i));
            }
        }

        @Override
        public Set<String> valueSet() {
            return this.str2value.keySet();
        }
    }

    private static final class DataStringCache
    implements Data {
        private long begin;
        private long end;
        private int from;
        private int to;
        private long[] times;
        private double[] values;
        private double before;
        private double after;
        private boolean fixedNames;
        private String[] names;
        private int index;

        DataStringCache(Trend trend, long begin, long end, boolean raw, int nBins) {
            this.begin = begin;
            this.end = end;
            this.fixedNames = trend.getValues() != null;
            TrendData data = trend.getData();
            if (data != null && data.getTimes().length > 0) {
                this.times = data.getTimes();
                this.values = data.getValues();
                this.names = data.getNames();
                this.from = Arrays.binarySearch(this.times, begin);
                if (this.from < 0) {
                    this.from = -this.from - 1;
                } else if (this.from > 0 && this.times[this.from - 1] == this.times[this.from]) {
                    --this.from;
                }
                this.to = Arrays.binarySearch(this.times, end);
                if (this.to < 0) {
                    this.to = -this.to - 1;
                } else if (this.to > 0 && this.times[this.to - 1] == this.times[this.to]) {
                    --this.to;
                }
            }
            this.index = this.from - 1;
            String type = trend.getType();
            if (RestSource.STATE.equals(type) || RestSource.ALERT.equals(type)) {
                this.before = this.from > 0 ? this.values[this.from - 1] : (this.times.length > 1 && this.times[0] == this.times[1] ? this.values[0] : -1.0);
                this.after = this.to - this.from > 0 ? this.values[this.to - 1] : this.before;
            } else {
                boolean rawUnbinned;
                boolean bl = rawUnbinned = raw && nBins == 0;
                if (rawUnbinned) {
                    this.after = -1.0;
                    this.before = -1.0;
                } else {
                    this.before = this.from > 0 && this.from < this.values.length && RestSource.equal(this.values[this.from - 1], this.values[this.from]) ? this.values[this.from] : -1.0;
                    this.after = this.to < this.values.length && this.to - 1 >= 0 && RestSource.equal(this.values[this.to - 1], this.values[this.to]) ? this.values[this.to] : -1.0;
                }
            }
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void rewind() {
            this.index = this.from - 1;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.to - 1;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public long time() {
            return this.times[this.index];
        }

        @Override
        public double value() {
            return this.values[this.index];
        }

        @Override
        public long begin() {
            return this.begin;
        }

        @Override
        public long end() {
            return this.end;
        }

        @Override
        public long firstTime() {
            return this.size() == 0 ? -1L : this.times[this.from];
        }

        @Override
        public double firstValue() {
            return this.size() == 0 ? -1.0 : this.values[this.from];
        }

        @Override
        public long lastTime() {
            return this.size() == 0 ? -1L : this.times[this.to - 1];
        }

        @Override
        public double lastValue() {
            return this.size() == 0 ? -1.0 : this.values[this.to - 1];
        }

        @Override
        public double beforeValue() {
            return this.before;
        }

        @Override
        public double afterValue() {
            return this.after;
        }

        @Override
        public void setMap(String[] names) {
            if (!this.fixedNames && !Objects.deepEquals(this.names, names)) {
                int i;
                HashMap<String, Integer> string2new = new HashMap<String, Integer>();
                for (i = 0; i < names.length; ++i) {
                    string2new.put(names[i], i);
                }
                for (i = this.from; i < this.to; ++i) {
                    this.values[i] = ((Integer)string2new.get(this.names[RestSource.toInt(this.values[i])])).intValue();
                }
                if (RestSource.valid(this.before)) {
                    this.before = ((Integer)string2new.get(this.names[RestSource.toInt(this.before)])).intValue();
                }
                if (RestSource.valid(this.after)) {
                    this.after = ((Integer)string2new.get(this.names[RestSource.toInt(this.after)])).intValue();
                }
                this.names = names;
            }
        }

        @Override
        public Set<String> valueSet() {
            if (this.fixedNames) {
                return new LinkedHashSet<String>(Arrays.asList(this.names));
            }
            LinkedHashSet<String> out = new LinkedHashSet<String>();
            for (int i = this.from; i < this.to; ++i) {
                out.add(this.names[RestSource.toInt(this.values[i])]);
            }
            if (RestSource.valid(this.before)) {
                out.add(this.names[RestSource.toInt(this.before)]);
            }
            if (RestSource.valid(this.after)) {
                out.add(this.names[RestSource.toInt(this.after)]);
            }
            return out;
        }
    }

    private static interface Data {
        public static Data make(Trend trend, long begin, long end, boolean raw, int nBins) {
            return new DataStringCache(trend, begin, end, raw, nBins);
        }

        public static Data make(Result result, long begin, long end, boolean raw, int nBins) {
            if (result == null) {
                return null;
            }
            switch (result.getType()) {
                case "string": 
                case "boolean": 
                case "state": 
                case "alert": {
                    return new DataStringQuery(result, begin, end, raw, nBins);
                }
            }
            return null;
        }

        public static String[] mergeNames(String[] names, Data d1, Data d2) {
            if (names == null) {
                TreeSet<String> all = new TreeSet<String>();
                all.addAll(d1.valueSet());
                if (d2 != null) {
                    all.addAll(d2.valueSet());
                }
                names = all.toArray(new String[0]);
            }
            d1.setMap(names);
            if (d2 != null) {
                d2.setMap(names);
            }
            return names;
        }

        public int size();

        public void rewind();

        public boolean hasNext();

        public void next();

        public long time();

        public double value();

        public long begin();

        public long end();

        public long firstTime();

        public double firstValue();

        public long lastTime();

        public double lastValue();

        public double beforeValue();

        public double afterValue();

        public void setMap(String[] var1);

        public Set<String> valueSet();
    }

    private static class StateQueryInfo {
        final String agent;
        final Set<String> states = new LinkedHashSet<String>();
        final Set<String> components = new LinkedHashSet<String>();

        StateQueryInfo(String agent) {
            this.agent = agent;
        }
    }

    private static class AlertID {
        final String agent;
        final String alertID;

        public AlertID(String agent, String alertID) {
            this.agent = agent;
            this.alertID = alertID;
        }

        static AlertID parse(String path) {
            Matcher m = ALERT_PATH.matcher(path);
            if (m.matches()) {
                return new AlertID(m.group("agent"), m.group(RestSource.ALERT));
            }
            return null;
        }
    }

    private static class StateID {
        final String agent;
        final String component;
        final String state;

        public StateID(String agent, String component, String state) {
            this.agent = agent;
            this.component = component;
            this.state = state;
        }

        static StateID parse(String path) {
            Matcher m = STATE_PATH.matcher(path);
            if (m.matches()) {
                String comp = m.group("component");
                return new StateID(m.group("agent"), comp == null ? RestSource.UNKNOWN : comp, m.group(RestSource.STATE));
            }
            return null;
        }
    }

    static class Result {
        final String path;
        final long begin;
        final long end;
        final boolean raw;
        final int bins;
        final Object data;

        Result(String path, long begin, long end, boolean raw, int bins, Object data) {
            this.path = path;
            this.begin = begin;
            this.end = end;
            this.raw = raw;
            this.bins = bins;
            this.data = data;
        }

        static Result[] make(String[] paths, long begin, long end, boolean raw, int bins, TrendingResult[] results) {
            int n = paths.length;
            Result[] out = new Result[n];
            for (int i = 0; i < n; ++i) {
                out[i] = results == null ? null : new Result(paths[i], begin, end, raw, bins, results[i]);
            }
            return out;
        }

        static Result[] make(String[] paths, long begin, long end, List<StateChange>[] results) {
            int n = paths.length;
            Result[] out = new Result[n];
            for (int i = 0; i < n; ++i) {
                out[i] = results == null ? null : new Result(paths[i], begin, end, true, 0, results[i]);
            }
            return out;
        }

        static Result[] make(String[] paths, long begin, long end, List<AlertEvent> result) {
            int n = paths.length;
            Result[] out = new Result[n];
            if (result != null) {
                for (int i = 0; i < n; ++i) {
                    out[i] = new Result(paths[i], begin, end, true, 0, result);
                }
            }
            return out;
        }

        String getType() {
            if (this.data instanceof TrendingResult) {
                TrendingResult tr = (TrendingResult)this.data;
                List mdl = tr.getChannelMetadata();
                if (mdl == null) {
                    return RestSource.UNKNOWN;
                }
                for (ChannelMetaData md : mdl) {
                    if (!"type".equals(md.getName())) continue;
                    return RestSource.convertType(md.getValue());
                }
                return RestSource.UNKNOWN;
            }
            if (STATE_PATH.matcher(this.path).matches()) {
                return RestSource.STATE;
            }
            if (ALERT_PATH.matcher(this.path).matches()) {
                return RestSource.ALERT;
            }
            return RestSource.UNKNOWN;
        }

        TrendingResult getTrendingResult() {
            return (TrendingResult)this.data;
        }

        List<StateChange> getStateChanges() {
            return (List)this.data;
        }

        List<AlertEvent> getAlerts() {
            return (List)this.data;
        }

        boolean isRaw() {
            return this.raw && this.bins == 0;
        }
    }
}

