/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionListener;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.freehep.jas.services.PreferencesTopic;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.base.InputBlocker;
import org.lsst.ccs.gconsole.util.ThreadUtil;
import org.lsst.ccs.gconsole.util.swing.BoxedComboBox;
import org.lsst.ccs.gconsole.util.swing.BoxedSpinner;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;

class SelfDestructor {
    private static final String PROP_BEFORE = "org.lsst.ccs.gui.self-destruct.before";
    private static final String PROP_AFTER = "org.lsst.ccs.gui.self-destruct.after";
    private static final String PROP_SAFE = "org.lsst.ccs.gui.safe";
    private static final int DEFAULT_BEFORE = 7200;
    private static final int DEFAULT_AFTER = 7200;
    private static final String DEFAULT_SAFE = "Block 1800";
    private static int beforeShutdown;
    private static int afterShutdown;
    private static EnumSet<SafeAct> safeAct;
    private static int beforeSafe;
    private static boolean inSafe;
    private static long lastTouch;
    private static PeriodicTask task;
    private static JLabel timeLeftLabel;
    private static final AWTEventListener inputListener;
    private static boolean initialized;

    SelfDestructor() {
    }

    static void restart() {
        ThreadUtil.invokeLater(() -> {
            Console c = Console.getConsole();
            if (!initialized) {
                initialized = true;
                c.addProperty(PROP_BEFORE, 7200);
                c.addProperty(PROP_AFTER, 7200);
                c.addProperty(PROP_SAFE, DEFAULT_SAFE);
                c.getConsoleLookup().add((Object)new Pref());
            }
            beforeShutdown = (Integer)c.getProperty(PROP_BEFORE);
            afterShutdown = (Integer)c.getProperty(PROP_AFTER);
            String s = (String)c.getProperty(PROP_SAFE);
            try {
                String[] ss = s.split("\\s");
                int n = ss.length - 1;
                safeAct = EnumSet.noneOf(SafeAct.class);
                beforeSafe = Integer.parseInt(ss[n]);
                for (int i = 0; i < n; ++i) {
                    safeAct.add(SafeAct.valueOf(ss[i]));
                }
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException x) {
                safeAct = EnumSet.of(SafeAct.Block);
                beforeSafe = 1800;
            }
            Toolkit.getDefaultToolkit().removeAWTEventListener(inputListener);
            if (task != null) {
                task.cancel(true);
                task = null;
            }
            timeLeftLabel = null;
            if (beforeShutdown > 0 || beforeSafe > 0) {
                Toolkit.getDefaultToolkit().addAWTEventListener(inputListener, 24L);
                lastTouch = System.currentTimeMillis();
                task = Console.getConsole().getScheduler().scheduleAtFixedRate(SelfDestructor::check, 1L, 1L, TimeUnit.MINUTES);
            }
        });
    }

    private static void check() {
        try {
            SwingUtilities.invokeLater(() -> {
                Console c = Console.getConsole();
                if (timeLeftLabel != null) {
                    return;
                }
                long sinceLastTouch = System.currentTimeMillis() - lastTouch;
                if (beforeShutdown > 0 && sinceLastTouch > (long)beforeShutdown * 1000L) {
                    try {
                        SelfDestructor.startShutdown();
                    }
                    catch (Throwable x) {
                        SelfDestructor.emergencyShutdown(x);
                    }
                } else if (!inSafe && beforeSafe > 0 && sinceLastTouch > (long)beforeSafe * 1000L) {
                    SelfDestructor.startSafeMode();
                }
            });
        }
        catch (Throwable x) {
            SelfDestructor.emergencyShutdown(x);
        }
    }

    private static void startShutdown() {
        if (task != null) {
            task.cancel(true);
            task = null;
        }
        String killLabel = "Shut down";
        String cancelLabel = "Keep alive";
        String s = SelfDestructor.countdown(afterShutdown, "Idle CCS console", "<center>This console will be shut down due to inactivity in", "Keep alive", "Shut down", "Keep alive");
        if (s == null) {
            s = "Shut down";
        }
        switch (s) {
            case "Shut down": {
                if (task != null) {
                    task.cancel(true);
                }
                try {
                    Console.getConsole().shutdownAgent();
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                SelfDestructor.restart();
            }
        }
    }

    public static void emergencyShutdown(Throwable x) {
        try {
            Runnable r;
            if (x == null) {
                Thread.dumpStack();
                r = () -> Console.getConsole().getLogger().error((Object)"Emergency shutdown");
            } else {
                r = () -> Console.getConsole().getLogger().error((Object)"Emergency shutdown", x);
            }
            Thread t = new Thread(r, "Emergency shutdown logger");
            t.setDaemon(true);
            t.start();
            t.join(2000L);
        }
        catch (Throwable throwable) {
        }
        finally {
            System.exit(1);
        }
    }

    private static void startSafeMode() {
        if (inSafe) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("This console has been idle for a while. To prevent accidental actions, it will enter safe mode in ");
        String keepLabel = "Cancel";
        String s = SelfDestructor.countdown(60, "Entering safe mode", sb.toString(), "Cancel", "Cancel");
        if (s == null) {
            InputBlocker.setBlockAll(true);
            inSafe = true;
        }
    }

    static void setSafe(boolean safe) {
        inSafe = safe;
    }

    private static String countdown(int seconds, String title, String message, String defaultOption, String ... options) {
        if (seconds <= 0) {
            return null;
        }
        if (options.length == 0) {
            options = new String[]{defaultOption};
        }
        long start = System.currentTimeMillis();
        timeLeftLabel = new JLabel();
        JOptionPane pane = new JOptionPane(timeLeftLabel, 1, -1, null, options, defaultOption);
        JDialog dialog = pane.createDialog(Console.getConsole().getWindow(), title);
        dialog.setDefaultCloseOperation(2);
        ActionListener act = e -> {
            int minutes;
            if (timeLeftLabel == null) {
                return;
            }
            int remainSeconds = seconds - (int)((System.currentTimeMillis() - start) / 1000L);
            if (remainSeconds < 0) {
                dialog.dispose();
                pane.setValue("");
            }
            StringBuilder sb = new StringBuilder("<html>");
            sb.append(message).append("<p>");
            int hours = remainSeconds / 3600;
            if (hours > 0) {
                sb.append(hours).append(" hours ");
            }
            if ((minutes = (remainSeconds %= 3600) / 60) > 0) {
                sb.append(minutes).append(" minutes ");
            }
            sb.append(remainSeconds %= 60).append(" seconds.");
            timeLeftLabel.setText(sb.toString());
        };
        act.actionPerformed(null);
        Timer timer = new Timer(1000, act);
        timer.start();
        dialog.pack();
        dialog.setVisible(true);
        timer.stop();
        timeLeftLabel = null;
        String out = (String)pane.getValue();
        if (out == null) {
            return defaultOption;
        }
        if (out.equals("")) {
            return null;
        }
        return out;
    }

    static {
        inputListener = e -> {
            lastTouch = System.currentTimeMillis();
        };
    }

    private static final class PrefGUI
    extends JPanel {
        private final JCheckBox killBox;
        private final JCheckBox warnBox;
        private final JSpinner killSpinner;
        private final JSpinner warnSpinner;
        private final JComboBox<TimeUnit> killCombo;
        private final JComboBox<TimeUnit> warnCombo;
        private final JLabel warnLabel;
        private final JCheckBox safeBox;
        private final JComboBox<TimeUnit> safeTimeCombo;
        private final JLabel safeLabel;
        private final JSpinner safeSpinner;

        PrefGUI() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createTitledBorder("Idle console shutdown"));
            Box line = Box.createHorizontalBox();
            this.add(line);
            line.add(Box.createRigidArea(Const.HDIM));
            this.killBox = new JCheckBox("Shut down if idle for ");
            line.add(this.killBox);
            this.killBox.addActionListener(e -> this.enableComponents());
            this.killSpinner = new BoxedSpinner(new SpinnerNumberModel(1, 1, 100, 1));
            line.add(this.killSpinner);
            line.add(Box.createRigidArea(Const.HDIM));
            this.killCombo = new BoxedComboBox<TimeUnit>(new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES});
            line.add(this.killCombo);
            line.add(Box.createRigidArea(Const.HDIM));
            line.add(Box.createHorizontalGlue());
            line = Box.createHorizontalBox();
            this.add(line);
            line.add(Box.createRigidArea(new Dimension(30, 0)));
            this.warnBox = new JCheckBox("Warn ");
            line.add(this.warnBox);
            this.warnSpinner = new BoxedSpinner(new SpinnerNumberModel(1, 1, 100, 1));
            this.warnCombo = new BoxedComboBox<TimeUnit>(new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES});
            this.warnBox.addActionListener(e -> {
                boolean warningEnabled = this.warnBox.isSelected();
                this.warnSpinner.setEnabled(warningEnabled);
                this.warnCombo.setEnabled(warningEnabled);
            });
            line.add(this.warnSpinner);
            line.add(Box.createRigidArea(Const.HDIM));
            line.add(this.warnCombo);
            this.warnLabel = new JLabel(" before shutdown.");
            line.add(this.warnLabel);
            line.add(Box.createRigidArea(Const.HDIM));
            line.add(Box.createHorizontalGlue());
            this.add(Box.createRigidArea(new Dimension(0, 15)));
            line = Box.createHorizontalBox();
            this.add(line);
            line.add(Box.createRigidArea(Const.HDIM));
            this.safeBox = new JCheckBox("Enter safe mode");
            line.add(this.safeBox);
            this.safeBox.addActionListener(e -> this.enableComponents());
            line.add(Box.createRigidArea(Const.HDIM));
            line.add(Box.createHorizontalGlue());
            line = Box.createHorizontalBox();
            this.add(line);
            line.add(Box.createRigidArea(new Dimension(30, 0)));
            this.safeLabel = new JLabel(" if idle for ");
            line.add(this.safeLabel);
            this.safeSpinner = new BoxedSpinner(new SpinnerNumberModel(1, 1, 100, 1));
            line.add(this.safeSpinner);
            line.add(Box.createRigidArea(Const.HDIM));
            this.safeTimeCombo = new BoxedComboBox<TimeUnit>(new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES});
            line.add(this.safeTimeCombo);
            line.add(Box.createRigidArea(Const.HDIM));
            line.add(Box.createHorizontalGlue());
            this.add(Box.createVerticalGlue());
        }

        void set() {
            this.set(beforeShutdown, this.killBox, this.killSpinner, this.killCombo);
            this.set(afterShutdown, this.warnBox, this.warnSpinner, this.warnCombo);
            this.set(beforeSafe, this.safeBox, this.safeSpinner, this.safeTimeCombo);
            this.enableComponents();
        }

        void get() {
            Console c = Console.getConsole();
            c.setProperty(SelfDestructor.PROP_BEFORE, this.get(this.killBox, this.killSpinner, this.killCombo));
            c.setProperty(SelfDestructor.PROP_AFTER, this.get(this.warnBox, this.warnSpinner, this.warnCombo));
            c.setProperty(SelfDestructor.PROP_SAFE, Integer.toString(this.get(this.safeBox, this.safeSpinner, this.safeTimeCombo)));
        }

        private void enableComponents() {
            if (this.killBox.isSelected()) {
                this.killSpinner.setEnabled(true);
                this.killCombo.setEnabled(true);
                this.warnBox.setEnabled(true);
                boolean warningEnabled = this.warnBox.isSelected();
                this.warnSpinner.setEnabled(warningEnabled);
                this.warnCombo.setEnabled(warningEnabled);
                this.warnLabel.setEnabled(true);
            } else {
                this.killSpinner.setEnabled(false);
                this.killCombo.setEnabled(false);
                this.warnBox.setEnabled(false);
                this.warnSpinner.setEnabled(false);
                this.warnCombo.setEnabled(false);
                this.warnLabel.setEnabled(false);
            }
            boolean enable = this.safeBox.isSelected();
            this.safeLabel.setEnabled(enable);
            this.safeTimeCombo.setEnabled(enable);
            this.safeSpinner.setEnabled(enable);
        }

        private void set(int seconds, JCheckBox box, JSpinner spinner, JComboBox combo) {
            boolean enabled = seconds > 0;
            box.setSelected(enabled);
            seconds = Math.abs(seconds);
            if ((seconds /= 60) % 60 == 0) {
                if ((seconds /= 60) % 24 == 0) {
                    seconds /= 24;
                    combo.setSelectedItem((Object)TimeUnit.DAYS);
                } else {
                    combo.setSelectedItem((Object)TimeUnit.HOURS);
                }
            } else {
                combo.setSelectedItem((Object)TimeUnit.MINUTES);
            }
            spinner.setValue(seconds);
        }

        private int get(JCheckBox box, JSpinner spinner, JComboBox<TimeUnit> combo) {
            int seconds = (Integer)spinner.getValue();
            TimeUnit unit = (TimeUnit)((Object)combo.getSelectedItem());
            seconds = (int)unit.toSeconds(seconds);
            if (!box.isSelected()) {
                seconds = -seconds;
            }
            return seconds;
        }
    }

    private static class Pref
    implements PreferencesTopic {
        private Pref() {
        }

        public String[] path() {
            return new String[]{"LSST"};
        }

        public JComponent component() {
            PrefGUI panel = new PrefGUI();
            panel.set();
            return panel;
        }

        public boolean apply(JComponent jc) {
            try {
                PrefGUI panel = (PrefGUI)jc;
                panel.get();
                SelfDestructor.restart();
                return true;
            }
            catch (RuntimeException x) {
                return false;
            }
        }
    }

    private static enum Unit {
        days,
        hours,
        minutes;

    }

    private static enum SafeAct {
        Detach,
        Block;

    }
}

