/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.gconsole.base.InputBlocker;
import org.lsst.ccs.gconsole.base.SelfDestructor;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.base.panel.PanelType;
import org.lsst.ccs.gconsole.jas3.Jas3Console;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusAggregator;
import org.lsst.ccs.gconsole.services.optpage.LsstOptionalPageService;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class Console
extends Subsystem {
    private static final Jas3Console agent = new Jas3Console();
    private final AgentStatusAggregator aggregator = new AgentStatusAggregator();
    private int statusMessageID = 0;
    private final TreeMap<Integer, String> statusMessageHistory = new TreeMap();
    private final int STATUS_HISTORY_SIZE = 30;
    private ScheduledExecutorService junkPublisher;

    protected Console() {
        super("CCS-Graphical-Console", AgentInfo.AgentType.CONSOLE);
    }

    public void preStart() {
        SelfDestructor.restart();
        InputBlocker.initialize();
        this.aggregator.initialize();
        this.getConsoleLookup().add((Object)this.aggregator);
        try {
            Enumeration<URL> e2 = ((Object)((Object)this)).getClass().getClassLoader().getResources("gui/lookup.txt");
            while (e2.hasMoreElements()) {
                URL url = e2.nextElement();
                try {
                    InputStream ins = url.openStream();
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(ins));){
                        String[] ss;
                        String line;
                        while ((line = in.readLine()) != null && (ss = line.trim().split("=")).length == 2) {
                            if (ss[0].isEmpty()) {
                                this.getConsoleLookup().add((Object)ss[1]);
                                continue;
                            }
                            this.getConsoleLookup().add((Object)ss[1], ss[0]);
                        }
                    }
                    finally {
                        if (ins == null) continue;
                        ins.close();
                    }
                }
                catch (IOException ins) {}
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        AbstractAction act = new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.save();
            }
        };
        this.addMenu(act, "", "File:-2:3", "Session:1");
        act = new AbstractAction("Save As..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.saveAs();
            }
        };
        this.addMenu(act, "", "File:-2:3", "Session:2");
        act = new AbstractAction("Restore"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.restore();
            }
        };
        this.addMenu(act, "", "File:-2:3", "Session:3");
        act = new AbstractAction("Restore From..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.restoreFrom();
            }
        };
        this.addMenu(act, "", "File:-2:3", "Session:4");
        act = new AbstractAction("CCS Console Developer's Guide"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.showInBrowser("https://confluence.slac.stanford.edu/display/LSSTCAM/Graphical+Console+Plugin+Developer%27s+Guide");
            }
        };
        this.addMenu(act, "", "Help", "Documentation:300");
        final PanelManager panMan = this.getPanelManager();
        AbstractAction saveAsAct = new AbstractAction("Save..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = panMan.getSelectedPanel(PanelType.DATA);
                try {
                    Consumer task = (Consumer)panMan.get(c, Panel.ON_SAVE_AS);
                    task.accept((JComponent)c);
                }
                catch (ClassCastException | IllegalArgumentException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        };
        saveAsAct.setEnabled(false);
        this.addMenu(saveAsAct, "", "File:-2:4", "Page:1");
        AbstractAction editAct = new AbstractAction("Edit..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = panMan.getSelectedPanel(PanelType.DATA);
                try {
                    Consumer task = (Consumer)panMan.get(c, Panel.ON_EDIT);
                    task.accept((JComponent)c);
                }
                catch (ClassCastException | IllegalArgumentException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        };
        editAct.setEnabled(false);
        this.addMenu(editAct, "", "File:-2:4", "Page:2");
        panMan.addListener(e -> {
            Component c;
            Panel eventType = e.getStandardKey();
            if ((eventType == Panel.SELECTED || eventType == Panel.OPEN) && (c = panMan.getSelectedPanel(PanelType.DATA)) instanceof JComponent) {
                JComponent panel = (JComponent)c;
                saveAsAct.setEnabled(panMan.get((Component)panel, Panel.ON_SAVE_AS) != null);
                editAct.setEnabled(panMan.get((Component)panel, Panel.ON_EDIT) != null);
            }
        });
    }

    public void afterStart() {
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(new AgentPresenceListener(){

            public void disconnected(AgentInfo ... agents) {
                SwingUtilities.invokeLater(() -> {
                    for (AgentInfo agent : agents) {
                        Console.getConsole().removeMenu("CCS Subsystems", agent.getName());
                    }
                });
            }
        });
    }

    public void preShutdown() {
        this.aggregator.shutdown();
    }

    public static Console getConsole() {
        return agent;
    }

    public <T> T getSingleton(Class<T> clazz) {
        if (AgentStatusAggregator.class.equals(clazz)) {
            return (T)this.aggregator;
        }
        if (PanelManager.class.equals(clazz)) {
            return (T)this.getPanelManager();
        }
        if (AgentService.class.isAssignableFrom(clazz)) {
            return (T)this.getAgentService(clazz);
        }
        return (T)this.getConsoleLookup().lookup(clazz);
    }

    public abstract FreeHEPLookup getConsoleLookup();

    public abstract Window getWindow();

    public Logger getLoggerUI() {
        return Logger.getLogger((String)"org.lsst.ccs.ui");
    }

    public abstract Path getHomeDirectory();

    public abstract PanelManager getPanelManager();

    public AgentStatusAggregator getStatusAggregator() {
        return this.aggregator;
    }

    public abstract void error(String var1);

    public abstract void error(String var1, Exception var2);

    public abstract void showInBrowser(String var1);

    public abstract void setStatusMessage(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setStatusMessage(String message, int id) {
        TreeMap<Integer, String> treeMap = this.statusMessageHistory;
        synchronized (treeMap) {
            block14: {
                block15: {
                    if (id == 0) {
                        if (message == null) {
                            this.statusMessageHistory.clear();
                            this.statusMessageID = 0;
                            this.setStatusMessage(null);
                            break block14;
                        } else {
                            int n = this.statusMessageID = this.statusMessageHistory.isEmpty() ? 1 : this.statusMessageHistory.lastKey() + 1;
                            if (this.statusMessageID == Integer.MAX_VALUE) {
                                this.statusMessageHistory.clear();
                                this.statusMessageID = 1;
                            }
                            while (true) {
                                if (this.statusMessageHistory.size() <= 30) {
                                    this.statusMessageHistory.put(this.statusMessageID, message);
                                    this.setStatusMessage(message);
                                    return this.statusMessageID;
                                }
                                this.statusMessageHistory.pollFirstEntry();
                            }
                        }
                    }
                    if (id != this.statusMessageID) break block15;
                    if (message == null) {
                        this.statusMessageHistory.remove(id);
                        Map.Entry<Integer, String> e = this.statusMessageHistory.lastEntry();
                        if (e == null) {
                            this.statusMessageID = 0;
                            this.setStatusMessage(null);
                            break block14;
                        } else {
                            this.statusMessageID = e.getKey();
                            this.setStatusMessage(e.getValue());
                        }
                        break block14;
                    } else {
                        this.statusMessageHistory.replace(id, message);
                        this.setStatusMessage(message);
                    }
                    break block14;
                }
                if (message == null) {
                    this.statusMessageHistory.remove(id);
                } else {
                    this.statusMessageHistory.replace(id, message);
                }
            }
            return id;
        }
    }

    public abstract void setBlockInput(boolean var1);

    public LsstOptionalPageService getOptionalPageService() {
        return (LsstOptionalPageService)this.getConsoleLookup().lookup(LsstOptionalPageService.class);
    }

    public abstract Object addProperty(String var1, Object var2);

    public abstract Object removeProperty(String var1);

    public abstract Object getProperty(String var1);

    public abstract Object setProperty(String var1, Object var2);

    public void setProperties(Map<String, Object> properties) {
        properties.forEach((key, value) -> this.setProperty((String)key, value));
    }

    public abstract void addPropertyListener(PropertyListener var1, String var2);

    public abstract boolean removePropertyListener(PropertyListener var1);

    public abstract void addPreference(String[] var1, String var2, String var3);

    public abstract void addMenu(Action var1, String var2, String ... var3);

    public abstract boolean removeMenu(String ... var1);

    public abstract void insertToolbarAction(Action var1, int var2);

    public abstract void insertStatusBarComponent(JComponent var1, int var2);

    public abstract void removeStatusBarComponent(JComponent var1);

    @Command(type=Command.CommandType.ACTION, level=99, description="Publish status messages for testing the messaging system. Any previously requested junk publishing is stopped.")
    public String testLoadStatusBus(@Argument(description="Approximate size of each message, KB. 0 means stop publishing.", defaultValue="0") int size, @Argument(description="Messages per minute on each thread. 0 means stop publishing.", defaultValue="6") int frequency, final @Argument(description="Keep publishing for the specified number of seconds. 0 means publish one message on each thread.", defaultValue="0") int time, @Argument(description="Number of threads.", defaultValue="1") int threads) {
        if (this.junkPublisher != null) {
            this.junkPublisher.shutdownNow();
            this.junkPublisher = null;
        }
        if (size <= 0 || frequency <= 0 || threads <= 0) {
            return "Stopped publishing";
        }
        this.junkPublisher = Executors.newScheduledThreadPool(threads, r -> {
            Thread t = new Thread(r);
            t.setName("Junk Publisher");
            t.setDaemon(true);
            return t;
        });
        int period = (int)Math.round(60000.0 / (double)frequency);
        Random random = new Random();
        final int n = size * 1000;
        for (int i = 0; i < threads; ++i) {
            final byte[] payload = new byte[n];
            random.nextBytes(payload);
            Runnable run = new Runnable(){
                private final byte[] load;
                private final long deadline;
                boolean first;
                private final AgentMessagingLayer ml;
                {
                    this.load = payload;
                    this.deadline = System.currentTimeMillis() + (long)(time * 1000);
                    this.first = true;
                    this.ml = Console.this.getMessagingAccess();
                }

                @Override
                public void run() {
                    StatusData mess = new StatusData(new KeyValueData("junk", (Serializable)Arrays.copyOf(this.load, n)));
                    if (System.currentTimeMillis() >= this.deadline) {
                        if (this.first) {
                            this.ml.sendStatusMessage((StatusMessage)mess);
                        }
                        Console.this.junkPublisher.shutdownNow();
                    } else {
                        this.ml.sendStatusMessage((StatusMessage)mess);
                    }
                    this.first = false;
                }
            };
            this.getLogger().info((Object)("Scheduling: " + period));
            this.junkPublisher.scheduleAtFixedRate(run, period / threads * i, period, TimeUnit.MILLISECONDS);
        }
        return "OK";
    }

    public abstract void restore();

    public abstract void restoreFrom();

    public abstract void save();

    public abstract void saveAs();

    public static interface PropertyListener {
        public void propertiesChanged(Object var1, Map<String, Object> var2);
    }
}

