/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.Transient;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.LsstMonitorPlugin;
import org.lsst.ccs.gconsole.plugins.monitor.MeshTable;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorDisplay;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTable;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTable;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.persist.Persistable;

@Deprecated
public class TreeView
extends AbstractMonitorView {
    private Descriptor descriptor;
    private final InterNode root;
    DefaultTreeModel treeModel;
    private final Tree tree;
    private final JScrollPane scrollPane;
    private List<MonitorField> fields = Arrays.asList(MonitorField.VALUE, MonitorField.UNITS, MonitorField.LOW_ALARM, MonitorField.ALERT_LOW, MonitorField.HIGH_ALARM, MonitorField.ALERT_HIGH, MonitorField.DESCR);
    private List<MonitorField> compactFields = Arrays.asList(MonitorField.VALUE);
    private boolean doScroll = true;

    public TreeView() {
        this.root = new InterNode("Camera Control System");
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new Tree(this.treeModel);
        this.scrollPane = new JScrollPane(this.tree);
        this.descriptor = new Descriptor();
        this.root.init(Collections.emptyList());
    }

    @Override
    protected void resetChannels() {
        this.updateDescriptor(this.root);
        this.root.clear();
        this.root.init(this.data.entrySet());
        this.treeModel.reload();
        this.root.restoreExpansion();
    }

    @Override
    public JComponent getPanel() {
        return this.scrollPane;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        super.setFilter(filter);
        List<String> ff = filter.getFields(true);
        if (ff != null) {
            this.compactFields = new ArrayList<MonitorField>(ff.size());
            for (String field : ff) {
                this.compactFields.add(MonitorField.getInstance(field));
            }
        }
        if ((ff = filter.getFields(false)) != null) {
            this.fields = new ArrayList<MonitorField>(ff.size());
            for (String field : ff) {
                this.fields.add(MonitorField.getInstance(field));
            }
        }
    }

    @Override
    public Descriptor save() {
        this.getDescriptor().setNodes(null);
        this.updateDescriptor(this.root);
        return this.descriptor.clone();
    }

    @Override
    public void restore(Persistable.Descriptor descriptor) {
        if (descriptor instanceof Descriptor) {
            Descriptor desc = (Descriptor)descriptor;
            this.getDescriptor().setNodes((TreeMap)desc.getNodes().clone());
            this.root.restoreExpansion();
        }
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    private void updateDescriptor(Node node) {
        TreeMap<String, Serializable> nodes = this.getDescriptor().getNodes();
        if (nodes == null) {
            nodes = new TreeMap();
            this.getDescriptor().setNodes(nodes);
        }
        String path = node == this.root ? "" : node.getPathString() + "/";
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            this.updateDescriptor((Node)en.nextElement(), path, nodes);
        }
    }

    private void updateDescriptor(Node node, String path, TreeMap<String, Serializable> map) {
        Serializable desc = node.save();
        path = path + node.toString();
        if (desc == null || desc instanceof InterNodeDescriptor && ((InterNodeDescriptor)desc).isDefault()) {
            map.remove(path);
        } else {
            map.put(path, desc);
        }
        path = path + "/";
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            this.updateDescriptor((Node)en.nextElement(), path, map);
        }
    }

    private class Node
    extends DefaultMutableTreeNode {
        Node() {
        }

        Node(String name) {
            super(name);
        }

        void clear() {
            Enumeration<TreeNode> en = this.children();
            while (en.hasMoreElements()) {
                ((Node)en.nextElement()).clear();
            }
            this.removeAllChildren();
        }

        Serializable save() {
            return null;
        }

        void restore(Serializable storageBean) {
        }

        protected String getPathString() {
            StringJoiner sj = new StringJoiner("/");
            for (TreeNode node : this.getPath()) {
                if (node == TreeView.this.root) continue;
                sj.add(node.toString());
            }
            return sj.toString();
        }
    }

    private class InterNode
    extends Node {
        private InterNodeDescriptor desc;
        private Collection<Map.Entry<String, DisplayChannel>> data;

        InterNode(String name) {
            super(name);
        }

        /*
         * WARNING - void declaration
         */
        void init(Collection<Map.Entry<String, DisplayChannel>> data) {
            InterNodeDescriptor.Sort sortAlgorithm;
            ArrayList<Map.Entry<String, DisplayChannel>> processedData;
            this.data = data;
            if (this.desc == null) {
                String pathKey = this.getPathString();
                TreeMap<String, Serializable> nodes = TreeView.this.getDescriptor().getNodes();
                Serializable serializable = nodes == null ? null : nodes.get(pathKey);
                this.desc = serializable == null || !(serializable instanceof InterNodeDescriptor) ? new InterNodeDescriptor() : (InterNodeDescriptor)serializable;
            }
            if (this.desc.isSection()) {
                processedData = new ArrayList(data.size());
                for (Map.Entry entry : data) {
                    String processedKey = ((String)entry.getKey()).replaceFirst("/+", "//");
                    processedData.add(new AbstractMap.SimpleImmutableEntry<String, DisplayChannel>(processedKey, (DisplayChannel)entry.getValue()));
                }
            } else {
                processedData = new ArrayList<Map.Entry<String, DisplayChannel>>(data);
            }
            if (!InterNodeDescriptor.Sort.NONE.equals(sortAlgorithm = this.desc.getSort())) {
                processedData.sort(sortAlgorithm);
            }
            if (this.desc.isFlat()) {
                TreeMap<String, Serializable> treeMap = TreeView.this.getDescriptor().getNodes();
                String key = this.getPathString();
                if (!key.isEmpty()) {
                    key = key + "/";
                }
                key = key + SectionedTable.class.getName();
                Serializable disDesc = treeMap == null ? null : treeMap.get(key);
                SectionedTable.Descriptor descriptor = !(disDesc instanceof SectionedTable.Descriptor) ? null : (SectionedTable.Descriptor)disDesc;
                SectionedTable sectionedTable = SectionedTable.getInstance(processedData, this.desc.isCompact() ? TreeView.this.compactFields : TreeView.this.fields, descriptor);
                MonitorTableNode dNode = new MonitorTableNode(sectionedTable);
                sectionedTable.setListener(dNode);
                this.add(dNode);
            } else {
                MonitorTable tableModel;
                ArrayList<Map.Entry<String, DisplayChannel>> arrayList = new ArrayList<Map.Entry<String, DisplayChannel>>(processedData.size());
                ArrayList<Map.Entry<String, DisplayChannel>> mesh = new ArrayList<Map.Entry<String, DisplayChannel>>(processedData.size());
                LinkedHashMap branches = new LinkedHashMap();
                for (Map.Entry<String, DisplayChannel> entry : processedData) {
                    String[] pathSegments = entry.getKey().split("/+");
                    if (pathSegments.length < 2) {
                        arrayList.add(entry);
                        continue;
                    }
                    if (this.desc.isMesh() && (pathSegments.length == 2 || pathSegments.length == 3)) {
                        void var8_15;
                        if (this.desc.isFlip()) {
                            String dp = pathSegments.length == 2 ? pathSegments[1] + "/" + pathSegments[0] : pathSegments[0] + "/" + pathSegments[2] + "/" + pathSegments[1];
                            AbstractMap.SimpleImmutableEntry<String, DisplayChannel> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<String, DisplayChannel>(dp, entry.getValue());
                        }
                        mesh.add((Map.Entry<String, DisplayChannel>)var8_15);
                        continue;
                    }
                    ArrayList<AbstractMap.SimpleImmutableEntry<String, DisplayChannel>> branch = (ArrayList<AbstractMap.SimpleImmutableEntry<String, DisplayChannel>>)branches.get(pathSegments[0]);
                    if (branch == null) {
                        branch = new ArrayList<AbstractMap.SimpleImmutableEntry<String, DisplayChannel>>();
                        branches.put(pathSegments[0], branch);
                    }
                    StringJoiner sj = new StringJoiner("/");
                    for (int i = 1; i < pathSegments.length; ++i) {
                        sj.add(pathSegments[i]);
                    }
                    branch.add(new AbstractMap.SimpleImmutableEntry<String, DisplayChannel>(sj.toString(), entry.getValue()));
                }
                if (!arrayList.isEmpty()) {
                    tableModel = SectionedTable.getInstance(arrayList, this.desc.isCompact() ? TreeView.this.compactFields : TreeView.this.fields, null);
                    MonitorTableNode monitorTableNode = new MonitorTableNode(tableModel);
                    tableModel.setListener(monitorTableNode);
                    this.add(monitorTableNode);
                }
                if (!mesh.isEmpty()) {
                    tableModel = MeshTable.getInstance(mesh, this.desc.isCompact() ? TreeView.this.compactFields : TreeView.this.fields);
                    MonitorTableNode monitorTableNode = new MonitorTableNode(tableModel);
                    tableModel.setListener(monitorTableNode);
                    this.add(monitorTableNode);
                }
                if (!branches.isEmpty()) {
                    for (Map.Entry entry : branches.entrySet()) {
                        InterNode child = new InterNode((String)entry.getKey());
                        this.add(child);
                        ((ArrayList)entry.getValue()).trimToSize();
                        child.init((Collection)entry.getValue());
                    }
                }
            }
        }

        protected void rebuild() {
            if (this.data != null && !this.data.isEmpty()) {
                TreeView.this.updateDescriptor(this);
                Collection<Map.Entry<String, DisplayChannel>> data = this.data;
                this.clear();
                this.init(data);
                TreeView.this.treeModel.nodeStructureChanged(this);
                this.restoreExpansion();
                TreeView.this.tree.expandPath(new TreePath(this.getPath()));
            }
        }

        @Override
        void clear() {
            super.clear();
            this.data = null;
        }

        @Override
        InterNodeDescriptor save() {
            InterNodeDescriptor descriptor = new InterNodeDescriptor(this.desc);
            descriptor.setExpanded(TreeView.this.tree.isExpanded(new TreePath(this.getPath())));
            return descriptor;
        }

        void restoreExpansion() {
            Enumeration<TreeNode> en = this.depthFirstEnumeration();
            while (en.hasMoreElements()) {
                TreeNode node = en.nextElement();
                if (!(node instanceof InterNode)) continue;
                InterNode n = (InterNode)node;
                if (!n.desc.isExpanded()) continue;
                TreeView.this.tree.expandPath(new TreePath(n.getPath()));
            }
        }

        public InterNodeDescriptor getDescriptor() {
            return this.desc;
        }

        Collection<Map.Entry<String, DisplayChannel>> getData() {
            return this.data;
        }
    }

    final class Tree
    extends JTree
    implements MonitorDisplay {
        Tree(TreeModel model) {
            super(model);
            this.setRootVisible(true);
            this.setShowsRootHandles(true);
            this.setRowHeight(0);
            this.setCellRenderer(new TreeRenderer(false));
            this.setCellEditor(new TreeEditor());
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (TreeView.this.tree.getRowForLocation(e.getX(), e.getY()) != -1) {
                        TreeView.this.tree.startEditingAtPath(TreeView.this.tree.getPathForLocation(e.getX(), e.getY()));
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
            this.setEditable(true);
            this.getSelectionModel().setSelectionMode(1);
            this.setScrollsOnExpand(false);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            int limit;
            int out = super.getScrollableUnitIncrement(visibleRect, orientation, direction);
            if (orientation == 1 && out > (limit = visibleRect.height / 8)) {
                return limit;
            }
            return out;
        }

        @Override
        public void saveData(OutputStream out, String mimeType) {
            List<AgentChannel> channels = TreeView.this.data.values().stream().map(handle -> handle.getChannel()).filter(channel -> channel != null).collect(Collectors.toList());
            LsstMonitorPlugin.saveData(out, mimeType, channels, TreeView.this.fields);
        }

        @Override
        public void scrollPathToVisible(TreePath path) {
            if (TreeView.this.doScroll) {
                super.scrollPathToVisible(path);
            }
        }

        @Override
        public void startEditingAtPath(TreePath path) {
            TreeView.this.doScroll = false;
            super.startEditingAtPath(path);
            TreeView.this.doScroll = true;
        }
    }

    public static class Descriptor
    extends AbstractMonitorView.Descriptor {
        private TreeMap<String, Serializable> nodes;

        public TreeMap<String, Serializable> getNodes() {
            return this.nodes;
        }

        public void setNodes(TreeMap<String, Serializable> nodes) {
            this.nodes = nodes;
        }

        @Override
        public Descriptor clone() {
            Descriptor desc = (Descriptor)super.clone();
            if (desc.nodes != null) {
                desc.nodes = new TreeMap<String, Serializable>((SortedMap<String, Serializable>)desc.nodes);
            }
            return desc;
        }
    }

    public static class InterNodeDescriptor
    implements Serializable {
        static final int FLAT = 1;
        static final int MESH = 2;
        static final int FLIP = 4;
        static final int COMPACT = 8;
        static final int SECTION = 16;
        static final int EXPANDED = 32;
        static final int SORT = 64;
        private int flags;

        public InterNodeDescriptor() {
        }

        public InterNodeDescriptor(InterNodeDescriptor other) {
            this.flags = other.flags;
        }

        @Transient
        public boolean isDefault() {
            return this.flags == 0;
        }

        public int getFlags() {
            return this.flags;
        }

        @Transient
        public DisplayMode getDisplayMode() {
            if (this.isFlat()) {
                return DisplayMode.FLAT;
            }
            if (this.isMesh()) {
                return this.isFlip() ? DisplayMode.FLIPPED_MESH : DisplayMode.MESH;
            }
            return DisplayMode.TREE;
        }

        @Transient
        public boolean isFlat() {
            return (this.flags & 1) > 0;
        }

        @Transient
        public boolean isMesh() {
            return (this.flags & 2) > 0;
        }

        @Transient
        public boolean isFlip() {
            return (this.flags & 4) > 0;
        }

        @Transient
        public boolean isCompact() {
            return (this.flags & 8) > 0;
        }

        @Transient
        public boolean isSection() {
            return (this.flags & 0x10) > 0;
        }

        @Transient
        public boolean isExpanded() {
            return (this.flags & 0x20) > 0;
        }

        @Transient
        public Sort getSort() {
            return (this.flags & 0x40) > 0 ? Sort.ALPHABETIC : Sort.NONE;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }

        @Transient
        public void setDisplayMode(DisplayMode value) {
            switch (value) {
                case TREE: {
                    this.setFlat(false);
                    this.setMesh(false);
                    this.setFlip(false);
                    break;
                }
                case FLAT: {
                    this.setFlat(true);
                    this.setMesh(false);
                    this.setFlip(false);
                    break;
                }
                case MESH: {
                    this.setFlat(false);
                    this.setMesh(true);
                    this.setFlip(false);
                    break;
                }
                case FLIPPED_MESH: {
                    this.setFlat(false);
                    this.setMesh(true);
                    this.setFlip(true);
                }
            }
        }

        @Transient
        public void setFlat(boolean value) {
            this.setBits(value, 1);
        }

        @Transient
        public void setMesh(boolean value) {
            this.setBits(value, 2);
        }

        @Transient
        public void setFlip(boolean value) {
            this.setBits(value, 4);
        }

        @Transient
        public void setCompact(boolean value) {
            this.setBits(value, 8);
        }

        @Transient
        public void setSection(boolean value) {
            this.setBits(value, 16);
        }

        @Transient
        public void setExpanded(boolean value) {
            this.setBits(value, 32);
        }

        @Transient
        public void setSort(Sort value) {
            this.setBits(Sort.ALPHABETIC.equals(value), 64);
        }

        private void setBits(boolean value, int mask) {
            this.flags = value ? (this.flags |= mask) : (this.flags &= ~mask);
        }

        public static enum DisplayMode {
            TREE,
            FLAT,
            MESH,
            FLIPPED_MESH;

        }

        public static enum Sort implements Comparator<Map.Entry<String, DisplayChannel>>
        {
            NONE{

                @Override
                public int compare(Map.Entry<String, DisplayChannel> o1, Map.Entry<String, DisplayChannel> o2) {
                    throw new UnsupportedOperationException("This value indicates no sorting");
                }
            }
            ,
            ALPHABETIC{

                @Override
                public int compare(Map.Entry<String, DisplayChannel> e1, Map.Entry<String, DisplayChannel> e2) {
                    return e1.getKey().compareTo(e2.getKey());
                }
            };


            @Override
            public abstract int compare(Map.Entry<String, DisplayChannel> var1, Map.Entry<String, DisplayChannel> var2);
        }
    }

    protected class MonitorTableNode
    extends DisplayNode {
        private final MonitorTable model;
        private final JPanel renderPanel;
        private final JPanel editPanel;

        MonitorTableNode(MonitorTable tableModel) {
            this(tableModel, tableModel.getClass().getName());
        }

        MonitorTableNode(MonitorTable tableModel, String name) {
            super(name);
            this.model = tableModel;
            if (TreeView.this.formatter != null) {
                this.model.setFormat(TreeView.this.formatter);
            }
            JTable table = this.model.getTable();
            this.renderPanel = new JPanel(new BorderLayout());
            this.renderPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0), BorderFactory.createLineBorder(Color.BLACK)));
            if (this.model.showHeader()) {
                this.renderPanel.add((Component)table.getTableHeader(), "North");
            }
            this.renderPanel.add((Component)table, "Center");
            table = this.model.getTable();
            this.editPanel = new JPanel(new BorderLayout());
            this.editPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0), BorderFactory.createLineBorder(Color.BLACK)));
            if (this.model.showHeader()) {
                this.editPanel.add((Component)table.getTableHeader(), "North");
            }
            this.editPanel.add((Component)table, "Center");
        }

        @Override
        JComponent getRendererComponent() {
            return this.renderPanel;
        }

        @Override
        JComponent getEditorComponent() {
            return this.editPanel;
        }

        @Override
        void clear() {
            this.model.destroy();
            super.clear();
        }

        @Override
        Serializable save() {
            return this.model.save();
        }
    }

    protected abstract class DisplayNode
    extends Node
    implements MonitorTable.Listener {
        DisplayNode() {
            super("display");
        }

        DisplayNode(String name) {
            super(name);
        }

        abstract JComponent getRendererComponent();

        abstract JComponent getEditorComponent();

        @Override
        public void stateChanged(MonitorTable.Event e) {
            if (this.parent == null) {
                return;
            }
            switch (e.getReason()) {
                case CELLS: {
                    TreeView.this.treeModel.nodeChanged(this);
                    break;
                }
                case TABLE: {
                    InterNode p = (InterNode)this.parent;
                    p.rebuild();
                    TreeView.this.tree.startEditingAtPath(new TreePath(p.getPath()));
                }
            }
        }
    }

    class TreeEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final TreeRenderer renderer;
        private Object editorValue;
        private final JPopupMenu popup;
        private final Action compactAct;
        private final Action sectionAct;
        private final EnumMap<InterNodeDescriptor.DisplayMode, AbstractAction> modeAct;
        private final EnumMap<InterNodeDescriptor.Sort, AbstractAction> sortAct;

        public TreeEditor() {
            JCheckBoxMenuItem menuItem;
            AbstractAction act;
            this.renderer = new TreeRenderer(true);
            this.popup = new JPopupMenu();
            JMenu menu = new JMenu("Display mode...");
            this.modeAct = new EnumMap(InterNodeDescriptor.DisplayMode.class);
            for (final InterNodeDescriptor.DisplayMode displayMode : InterNodeDescriptor.DisplayMode.values()) {
                act = new AbstractAction(displayMode.toString()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (TreeEditor.this.editorValue instanceof InterNode) {
                            InterNode node = (InterNode)TreeEditor.this.editorValue;
                            TreeEditor.this.modeAct.values().forEach(act -> act.putValue("SwingSelectedKey", act.equals(this)));
                            node.getDescriptor().setDisplayMode(displayMode);
                            node.rebuild();
                        }
                    }
                };
                this.modeAct.put(displayMode, act);
                menuItem = new JCheckBoxMenuItem(act);
                menu.add(menuItem);
            }
            this.popup.add(menu);
            menu = new JMenu("Order...");
            this.sortAct = new EnumMap(InterNodeDescriptor.Sort.class);
            for (Enum enum_ : InterNodeDescriptor.Sort.values()) {
                act = new AbstractAction(enum_.toString()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (TreeEditor.this.editorValue instanceof InterNode) {
                            InterNode node = (InterNode)TreeEditor.this.editorValue;
                            InterNodeDescriptor.Sort selectedMode = null;
                            for (Map.Entry ee : TreeEditor.this.sortAct.entrySet()) {
                                AbstractAction action = (AbstractAction)ee.getValue();
                                boolean isChosen = action == this;
                                action.putValue("SwingSelectedKey", isChosen);
                                if (!isChosen) continue;
                                selectedMode = (InterNodeDescriptor.Sort)ee.getKey();
                            }
                            node.getDescriptor().setSort(selectedMode);
                            node.rebuild();
                        }
                    }
                };
                this.sortAct.put((InterNodeDescriptor.Sort)enum_, act);
                menuItem = new JCheckBoxMenuItem(act);
                menu.add(menuItem);
            }
            this.popup.add(menu);
            this.compactAct = new AbstractAction("Compact"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TreeEditor.this.editorValue instanceof InterNode) {
                        InterNode node = (InterNode)TreeEditor.this.editorValue;
                        Boolean v = (Boolean)this.getValue("SwingSelectedKey");
                        node.getDescriptor().setCompact(Boolean.TRUE.equals(v));
                        node.rebuild();
                    }
                }
            };
            menuItem = new JCheckBoxMenuItem(this.compactAct);
            this.popup.add(menuItem);
            this.sectionAct = new AbstractAction("Sectioned"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TreeEditor.this.editorValue instanceof InterNode) {
                        InterNode node = (InterNode)TreeEditor.this.editorValue;
                        Boolean v = (Boolean)this.getValue("SwingSelectedKey");
                        node.getDescriptor().setSection(Boolean.TRUE.equals(v));
                        node.rebuild();
                    }
                }
            };
            menuItem = new JCheckBoxMenuItem(this.sectionAct);
            this.popup.add(menuItem);
            this.renderer.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                private void maybeShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        TreeEditor.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.editorValue = value;
            if (this.editorValue instanceof InterNode) {
                InterNode node = (InterNode)this.editorValue;
                this.compactAct.putValue("SwingSelectedKey", node.getDescriptor().isCompact());
                this.sectionAct.putValue("SwingSelectedKey", node.getDescriptor().isSection());
                for (Map.Entry<InterNodeDescriptor.DisplayMode, AbstractAction> entry : this.modeAct.entrySet()) {
                    entry.getValue().putValue("SwingSelectedKey", entry.getKey().equals((Object)node.getDescriptor().getDisplayMode()));
                }
                for (Map.Entry<Enum, AbstractAction> entry : this.sortAct.entrySet()) {
                    entry.getValue().putValue("SwingSelectedKey", ((InterNodeDescriptor.Sort)entry.getKey()).equals(node.getDescriptor().getSort()));
                }
            }
            return this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorValue;
        }
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        private final boolean editable;

        TreeRenderer(boolean editable) {
            this.editable = editable;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof InterNode) {
                Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                return c;
            }
            if (value instanceof DisplayNode) {
                DisplayNode node = (DisplayNode)value;
                return this.editable ? node.getEditorComponent() : node.getRendererComponent();
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
    }
}

