/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.gconsole.plugins.demo.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;

/**
 * 
 *
 * @author onoprien
 */
public class LayMan implements LayoutManager2 {
    
    public LayMan(LayoutManager2 layman) {
        delegate = layman;
    }
    
    private final LayoutManager2 delegate;

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        System.out.println("Begin LayMan.preferredLayoutSize(Container parent) on "+ parent.getName());
        Dimension out = delegate.preferredLayoutSize(parent);
        System.out.println("End LayMan.preferredLayoutSize(Container parent) on "+ parent.getName() +" "+ out);
        return out;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        System.out.println("Begin LayMan.addLayoutComponent(Component comp, Object constraints on "+ comp.getName() +", constraints: "+ constraints);
        delegate.addLayoutComponent(comp, constraints);
        System.out.println("End LayMan.addLayoutComponent(Component comp, Object constraints on "+ comp.getName());
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        System.out.println("Begin LayMan.maximumLayoutSize(Container target) on "+ target.getName());
        Dimension out =  delegate.maximumLayoutSize(target);
        System.out.println("End LayMan.maximumLayoutSize(Container target) on "+ target.getName() +" "+ out);
        return out;
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        System.out.println("Begin LayMan.getLayoutAlignmentX(Container target) on "+ target.getName());
        float out = delegate.getLayoutAlignmentX(target);
        System.out.println("End LayMan.getLayoutAlignmentX(Container target) on "+ target.getName() +" "+ out);
        return out;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        System.out.println("Begin LayMan.getLayoutAlignmentY(Container target) on "+ target.getName());
        float out = delegate.getLayoutAlignmentY(target);
        System.out.println("End LayMan.getLayoutAlignmentY(Container target) on "+ target.getName() +" "+ out);
        return out;
    }

    @Override
    public void invalidateLayout(Container target) {
        System.out.println("Begin LayMan.invalidateLayout(Container target) on "+ target.getName());
        delegate.invalidateLayout(target);
        System.out.println("End LayMan.invalidateLayout(Container target) on "+ target.getName());
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        System.out.println("Begin LayMan.addLayoutComponent(String name, Component comp) on "+ comp.getName() +", name: "+ name);
        delegate.addLayoutComponent(name, comp);
        System.out.println("End LayMan.addLayoutComponent(String name, Component comp) on "+ comp.getName());
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        System.out.println("Begin LayMan.removeLayoutComponent(Component comp) on "+ comp.getName());
        delegate.removeLayoutComponent(comp);
        System.out.println("End LayMan.removeLayoutComponent(Component comp) on "+ comp.getName());
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        System.out.println("Begin LayMan.minimumLayoutSize(Container parent) on "+ parent.getName());
        Dimension out =  delegate.minimumLayoutSize(parent);
        System.out.println("End LayMan.minimumLayoutSize(Container parent) on "+ parent.getName() +" "+ out);
        return out;
    }

    @Override
    public void layoutContainer(Container parent) {
        System.out.println("Begin LayMan.layoutContainer(Container parent) on "+ parent.getName());
        delegate.layoutContainer(parent);
        System.out.println("End LayMan.layoutContainer(Container parent) on "+ parent.getName());
    }


}
