/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class DataProviderInfo
implements Serializable {
    private static final long serialVersionUID = -905853368743117573L;
    private final String path;
    private final String key;
    private final Map<Attribute, String> attributes = new LinkedHashMap<Attribute, String>();

    public DataProviderInfo(String path, Type dataType, String name, Map<Attribute, String> attributes) {
        this.key = name;
        this.path = path;
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
        this.attributes.put(Attribute.DATA_TYPE, dataType.name());
    }

    public DataProviderInfo(String path, Type dataType, String name) {
        this(path, dataType, name, null);
    }

    public DataProviderInfo(String path, String name, Map<Attribute, String> attributes) {
        this.key = name;
        this.path = path;
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    public void addAttribute(Attribute attribute, String value) {
        if (value != null && !value.isEmpty()) {
            this.attributes.put(attribute, value);
        }
    }

    public String getAttributeValue(Attribute attr) {
        return this.attributes.get((Object)attr);
    }

    public String getKey() {
        return this.key;
    }

    public String getPath() {
        return this.path;
    }

    public String getFullPath() {
        if (this.path == null || this.path.isEmpty()) {
            return this.key;
        }
        if (this.path.endsWith(this.key)) {
            return this.path;
        }
        return this.path + "/" + this.key;
    }

    public Attribute[] getAttributes() {
        return this.attributes.keySet().toArray(new Attribute[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("path: ").append(this.getPath()).append(", key: ").append(this.getKey()).append(", att: [");
        for (Attribute a : this.getAttributes()) {
            sb.append("'").append(a.getName()).append("'='").append(this.getAttributeValue(a)).append("',");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataProviderInfo)) {
            return false;
        }
        DataProviderInfo other = (DataProviderInfo)obj;
        if (!Objects.equals(this.path, other.path)) {
            return false;
        }
        if (!Objects.equals(this.key, other.key)) {
            return false;
        }
        return Objects.equals(this.attributes, other.attributes);
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Objects.hashCode(this.path);
        hash = 37 * hash + Objects.hashCode(this.key);
        hash = 37 * hash + Objects.hashCode(this.attributes);
        return hash;
    }

    public static enum Attribute {
        DESCRIPTION("description", true),
        UNITS("units", true),
        TYPE("type", true),
        FORMAT("format", true),
        PAGE("page", false),
        SECTION("section", false),
        ALARMHI("alarmhi", false),
        ALARMLO("alarmlo", false),
        STATE("state", true),
        DATA_GROUP("dataGroup", true),
        DATA_TYPE("dataType", false),
        PUBLISHED_PATH("publishedPath", false),
        RTD_TYPE("rtdType", true),
        CONFIG_TYPE("config_type", true),
        CONFIG_CATEGORY("config_category", true),
        CONFIG_RANGE("config_range", true),
        CONFIG_MAX_LENGTH("config_max_length", true),
        DO_NOT_TREND("don_not_trend", false);

        private final String name;
        private final boolean isMetadata;

        private Attribute(String name, boolean isMetadata) {
            this.name = name;
            this.isMetadata = isMetadata;
        }

        public String getName() {
            return this.name;
        }

        public boolean isMetadata() {
            return this.isMetadata;
        }
    }

    public static enum Type {
        TRENDING,
        MONITORING,
        CONFIGURATION,
        STATE;

    }
}

