/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.persist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.services.persist.Creator;
import org.lsst.ccs.gconsole.services.persist.CreatorFromDescriptor;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;
import org.lsst.ccs.gconsole.util.tree.SModel;
import org.lsst.ccs.gconsole.util.tree.STree;

public final class CreationDialog
extends JDialog {
    private Persistable out;
    private Creator factory;
    private Creator.Descriptor descriptor;
    private Map<String, Creator> path2factory;
    private final STree<Creator> tree;
    private final Box rightPanel;
    private final JButton okButton;
    private final JButton saveButton;
    private final JButton deleteButton;
    private List<ParPanel> parPanels;
    private boolean instantiate = true;
    private final Pattern fullToSimpleClassName = Pattern.compile("(\\w+\\.)+");

    public CreationDialog(String path, String[] parameters, String title, Component parentComponent, Collection<? extends Creator> factories) {
        super(parentComponent == null ? Console.getConsole().getWindow() : SwingUtilities.getWindowAncestor(parentComponent), title, Dialog.ModalityType.APPLICATION_MODAL);
        this.path2factory = factories.stream().collect(Collectors.toMap(f -> f.getPath(), f -> f));
        SModel<Creator> m = new SModel<Creator>(this.path2factory);
        this.tree = new STree<Creator>(m);
        this.tree.expandLevel(3);
        this.tree.setShowsRootHandles(true);
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        this.rightPanel = Box.createVerticalBox();
        JScrollPane rightScrollPane = new JScrollPane(this.rightPanel);
        JSplitPane splitPane = new JSplitPane(1, treeScrollPane, rightScrollPane);
        splitPane.setDividerLocation(300);
        treeScrollPane.setMinimumSize(new Dimension(100, 50));
        rightScrollPane.setMinimumSize(new Dimension(100, 50));
        splitPane.setPreferredSize(new Dimension(850, 500));
        this.add((Component)splitPane, "Center");
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        buttonBox.add(Box.createRigidArea(Const.HDIM));
        this.saveButton = new JButton("Save...");
        buttonBox.add(this.saveButton);
        this.saveButton.addActionListener(e -> {
            if (this.factory != null) {
                Persistable.Descriptor d = null;
                if (this.factory instanceof CreatorFromDescriptor) {
                    d = ((CreatorFromDescriptor)this.factory).getDescriptor();
                } else {
                    Persistable instance = this.createInstance();
                    if (instance != null) {
                        d = instance.getDescriptor();
                    }
                }
                if (d != null) {
                    Console.getConsole().getSingleton(PersistenceService.class).saveAs(d, "Saving...", this);
                    this.path2factory.put(d.getPath(), new CreatorFromDescriptor(d));
                    this.reloadFactories();
                }
            }
        });
        buttonBox.add(Box.createRigidArea(Const.HDIM));
        this.deleteButton = new JButton("Delete");
        buttonBox.add(this.deleteButton);
        this.deleteButton.addActionListener(e -> {
            if (this.factory instanceof CreatorFromDescriptor) {
                Persistable.Descriptor d = ((CreatorFromDescriptor)this.factory).getDescriptor();
                Console.getConsole().getSingleton(PersistenceService.class).delete(d);
                this.path2factory.remove(d.getPath());
                this.reloadFactories();
            }
        });
        buttonBox.add(Box.createRigidArea(Const.HDIM));
        buttonBox.add(Box.createHorizontalGlue());
        JButton b = new JButton("Cancel");
        b.addActionListener(e -> {
            this.out = null;
            this.factory = null;
            this.descriptor = null;
            this.dispose();
        });
        buttonBox.add(b);
        buttonBox.add(Box.createRigidArea(Const.HDIM));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(e -> {
            if (this.factory != null) {
                if (this.instantiate) {
                    this.out = this.createInstance();
                    if (this.out != null) {
                        this.dispose();
                    }
                } else {
                    this.dispose();
                }
            }
        });
        buttonBox.add(this.okButton);
        buttonBox.add(Box.createRigidArea(Const.HDIM));
        this.add((Component)buttonBox, "South");
        try {
            Creator f2 = this.path2factory.get(path);
            this.tree.setSelectedPath(path);
            this.showFactory(f2, parameters);
        }
        catch (NullPointerException x) {
            this.showFactory(null, null);
        }
        this.tree.addTreeSelectionListener(e -> {
            Creator selection = this.tree.getSelectedUserObject();
            this.saveButton.setEnabled(selection != null);
            this.deleteButton.setEnabled(selection instanceof CreatorFromDescriptor);
            this.showFactory(selection, null);
        });
    }

    public static Persistable make(String path, String[] parameters, String title, Component parentComponent, Collection<? extends Creator> factories) {
        CreationDialog dialog = new CreationDialog(path, parameters, title, parentComponent, factories);
        dialog.setSize(dialog.getPreferredSize());
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.setVisible(true);
        if (dialog.out == null) {
            throw new CancellationException();
        }
        return dialog.out;
    }

    public static Persistable make(Creator.Descriptor desc, String title, Component parentComponent, Collection<? extends Creator> factories) {
        String[] parameters;
        String path;
        if (desc == null) {
            path = null;
            parameters = null;
        } else {
            path = desc.getPath();
            parameters = desc.getParameters();
        }
        return CreationDialog.make(path, parameters, title, parentComponent, factories);
    }

    public static Persistable make(Persistable.Descriptor descriptor, String title, Component parentComponent, Collection<? extends Creator> factories) {
        if (descriptor == null) {
            return CreationDialog.make(null, null, title, parentComponent, factories);
        }
        String path = descriptor.getPath();
        if (path == null) {
            return CreationDialog.make(descriptor.getCreator(), title, parentComponent, factories);
        }
        return CreationDialog.make(path, null, title, parentComponent, factories);
    }

    public static Creator select(String title, Component parentComponent, Collection<? extends Creator> factories) {
        CreationDialog dialog = new CreationDialog(null, null, title, parentComponent, factories);
        dialog.instantiate = false;
        dialog.setSize(dialog.getPreferredSize());
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.setVisible(true);
        return dialog.factory;
    }

    public Creator.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private void showFactory(Creator fact, String[] parameters) {
        this.factory = fact;
        this.rightPanel.removeAll();
        this.parPanels = Collections.emptyList();
        if (fact != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>Path: <b>").append(fact.getPath()).append("</b><br>");
            sb.append("Name: <b>").append(fact.getName()).append("</b><p>");
            String descr = fact.getDescription();
            if (descr != null && !descr.isEmpty()) {
                sb.append("<b>Description:</b><br>").append(descr).append("<p>");
            }
            sb.append("</html>");
            JEditorPane ep = new JEditorPane("text/html", sb.toString());
            ep.setOpaque(true);
            ep.setEditable(false);
            this.rightPanel.add(ep);
            Parameter[] pars = fact.getParameters();
            this.parPanels = new ArrayList<ParPanel>(pars.length);
            if (pars.length > 0) {
                if (parameters != null && parameters.length != pars.length) {
                    parameters = null;
                }
                Box parBox = Box.createVerticalBox();
                parBox.setBorder(BorderFactory.createTitledBorder("Parameters"));
                parBox.add(Box.createRigidArea(Const.VDIM));
                for (int i = 0; i < pars.length; ++i) {
                    ParPanel panel = new ParPanel(pars[i], parameters == null ? null : parameters[i]);
                    parBox.add(panel);
                    this.parPanels.add(panel);
                    parBox.add(Box.createRigidArea(new Dimension(10, 10)));
                }
                this.rightPanel.add(Box.createRigidArea(Const.VDIM));
                this.rightPanel.add(parBox);
                this.rightPanel.add(Box.createRigidArea(Const.VDIM));
            }
            this.rightPanel.add(Box.createVerticalGlue());
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
    }

    private Persistable createInstance() {
        Persistable instance;
        block6: {
            instance = null;
            int n = this.parPanels.size();
            Object[] pars = new Object[n];
            boolean parsValid = true;
            for (int i = 0; i < n; ++i) {
                try {
                    pars[i] = this.parPanels.get(i).getValue();
                    continue;
                }
                catch (IllegalStateException x) {
                    parsValid = false;
                }
            }
            if (parsValid) {
                try {
                    instance = this.factory.make(pars);
                }
                catch (Exception x) {
                    if (x instanceof InvocationTargetException && x.getCause() instanceof CancellationException) break block6;
                    Console.getConsole().error("Unable to create", x);
                }
            }
        }
        return instance;
    }

    private void reloadFactories() {
        STree.Descriptor d = this.tree.save();
        this.tree.setModel(new SModel<Creator>(this.path2factory));
        this.tree.restore(d);
    }

    private final class DescriptionPane
    extends JEditorPane {
        DescriptionPane(String s) {
            super("text/html", s);
            this.setEditable(false);
            this.setOpaque(true);
            this.setBackground(new Color(255, 255, 255, 0));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = new Dimension(super.getPreferredSize());
            d.width = 200;
            return d;
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension p = super.getPreferredSize();
            Dimension m = super.getMaximumSize();
            m.height = p.height;
            return m;
        }
    }

    private final class ParPanel
    extends JPanel {
        private final Parameter par;
        private JComponent selector;
        private String stringValue;

        ParPanel(Parameter parameter, String value) {
            Box hBox;
            this.par = parameter;
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
            Par an = this.par.getAnnotation(Par.class);
            if (an != null) {
                String def;
                hBox = Box.createHorizontalBox();
                DescriptionPane descrPanel = new DescriptionPane(an.desc());
                hBox.add(Box.createRigidArea(Const.HDIM));
                hBox.add(descrPanel);
                this.add(hBox);
                this.add(Box.createRigidArea(Const.VDIM));
                if (value == null && !"_nodef_".equals(def = an.def())) {
                    value = def;
                }
            }
            hBox = Box.createHorizontalBox();
            this.add(hBox);
            hBox.add(Box.createRigidArea(Const.HDIM));
            String s = this.par.getParameterizedType().getTypeName() + " " + this.par.getName();
            s = CreationDialog.this.fullToSimpleClassName.matcher(s).replaceAll("");
            JLabel label = new JLabel(s);
            Font f = label.getFont();
            label.setFont(f.deriveFont(f.getStyle() | 1));
            hBox.add(label);
            hBox.add(Box.createRigidArea(Const.HDIM));
            Class<?> pc = this.par.getType();
            if (Enum.class.isAssignableFrom(pc)) {
                try {
                    Object[] enumValues = (Object[])pc.getMethod("values", new Class[0]).invoke(null, new Object[0]);
                    Object[] comboValues = new Object[enumValues.length + 1];
                    comboValues[0] = null;
                    System.arraycopy(enumValues, 0, comboValues, 1, enumValues.length);
                    JComboBox<Object> comboBox = new JComboBox<Object>(comboValues);
                    if (value != null) {
                        try {
                            Object v = Creator.decode(value, this.par.getParameterizedType());
                            comboBox.setSelectedItem(v);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.selector = comboBox;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException t) {
                    this.selector = new JLabel("<html><font color=red>Failed to create selector for " + pc);
                }
            } else if (Boolean.TYPE.equals(pc) || Boolean.class.equals(pc)) {
                JCheckBox checkBox = new JCheckBox();
                if ("true".equalsIgnoreCase(value)) {
                    checkBox.setSelected(true);
                }
                this.selector = checkBox;
            } else {
                JTextField field = new JTextField();
                field.setColumns(30);
                field.setMaximumSize(field.getPreferredSize());
                if (value != null) {
                    field.setText(value);
                }
                this.selector = field;
            }
            hBox.add(this.selector);
            hBox.add(Box.createHorizontalGlue());
        }

        Object getValue() {
            Object out = null;
            Type type = this.par.getParameterizedType();
            try {
                if (this.selector instanceof JTextField) {
                    JTextField field = (JTextField)this.selector;
                    out = Creator.decode(field.getText(), type);
                } else if (this.selector instanceof JCheckBox) {
                    JCheckBox b = (JCheckBox)this.selector;
                    out = b.isSelected();
                } else if (this.selector instanceof JComboBox) {
                    JComboBox cb = (JComboBox)this.selector;
                    out = cb.getSelectedItem();
                }
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
                this.stringValue = Creator.encode(out, type);
            }
            catch (Throwable t) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.RED), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
                this.stringValue = null;
                throw new IllegalStateException(t);
            }
            return out;
        }

        String getStringValue() {
            return this.stringValue;
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension p = super.getPreferredSize();
            Dimension m = super.getMaximumSize();
            m.height = p.height;
            return m;
        }
    }
}

