/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.gconsole.plugins.trending.RestSource;
import org.lsst.ccs.gconsole.plugins.trending.SimulatedRestService;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.services.rest.LsstRestService;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.StateChange;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.server.TrendingResult;

public class RestSourceTest {
    private static RestSource source;
    private static Trend trendS0;
    private static Trend trendS1;
    private static Trend trendS2;
    private static Trend trendS3;
    private static Trend trendS4;
    private static Trend trendR0;
    private static Trend trendB0;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.out.println("Starting RestSource tests.");
        source = new RestSource((LsstRestService)new SimulatedRestService());
        source.refresh();
        RestSourceTest.clearTrends();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        source = null;
        trendS0 = null;
        trendS1 = null;
        trendS2 = null;
        trendS3 = null;
        trendS4 = null;
        trendR0 = null;
        trendB0 = null;
        System.out.println("Finished RestSource tests.");
    }

    @Before
    public void setUp() throws Exception {
        RestSourceTest.clearTrends();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGet_5args_2() {
        long[] times = new long[]{10L, 11L, 12L, 13L, 14L, 16L, 17L, 18L, 19L, 20L};
        HashMap<String, double[]> values = new HashMap<String, double[]>();
        values.put("value", new double[]{10.0, 11.0, 12.0, 13.0, 14.0, 16.0, 17.0, 18.0, 19.0, 20.0});
        values.put("onpoint", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 6.0, 7.0, 8.0, 9.0, 10.0});
        HashMap meta = new HashMap();
        ArrayList<TrendData.MetaValue> offD = new ArrayList<TrendData.MetaValue>();
        offD.add(new TrendData.MetaValue(10L, 13L, "1"));
        offD.add(new TrendData.MetaValue(13L, 15L, "2"));
        offD.add(new TrendData.MetaValue(15L, 20L, "3"));
        meta.put("offD", offD);
        ArrayList<TrendData.MetaValue> offS1 = new ArrayList<TrendData.MetaValue>();
        offS1.add(new TrendData.MetaValue(10L, 20L, "S1"));
        meta.put("offS1", offS1);
        TrendData td = new TrendData(times, values, meta, new long[]{10L, 20L}, true, 0);
        TrendData tdNew = RestSource.cut((TrendData)td, (long)12L, (long)15L);
        Assert.assertArrayEquals((String)"cut times", (long[])new long[]{12L, 13L, 14L}, (long[])tdNew.getTimes());
        Assert.assertArrayEquals((String)"cut times key", (long[])new long[]{12L, 13L, 14L}, (long[])tdNew.getTimes("value"));
        Assert.assertArrayEquals((String)"cut values", (double[])new double[]{12.0, 13.0, 14.0}, (double[])tdNew.getValues(), (double)0.01);
        Assert.assertArrayEquals((String)"cut onpoint", (double[])new double[]{2.0, 3.0, 4.0}, (double[])tdNew.getValues("onpoint"), (double)0.01);
        Assert.assertArrayEquals((String)"cut offD times", (long[])new long[]{12L, 13L, 13L, 15L}, (long[])tdNew.getTimes("offD"));
        Assert.assertArrayEquals((String)"cut offD strings", (Object[])new String[]{"1", "1", "2", "2"}, (Object[])tdNew.getMetadata("offD"));
        Assert.assertArrayEquals((String)"cut offD double", (double[])new double[]{1.0, 1.0, 2.0, 2.0}, (double[])tdNew.getValues("offD"), (double)0.01);
        Assert.assertArrayEquals((String)"cut offS1 times", (long[])new long[]{12L, 15L}, (long[])tdNew.getTimes("offS1"));
        Assert.assertArrayEquals((String)"cut offS1 strings", (Object[])new String[]{"S1", "S1"}, (Object[])tdNew.getMetadata("offS1"));
        TrendingData[] data = new TrendingData[4];
        TrendingData d = new TrendingData();
        TrendingData.AxisValue t = new TrendingData.AxisValue("", 21L);
        d.setAxisValue(t);
        TrendingData.DataValue v = new TrendingData.DataValue("value", 21.0);
        TrendingData.DataValue v1 = new TrendingData.DataValue("onpoint", 11.0);
        d.setDataValue(new TrendingData.DataValue[]{v, v1});
        data[0] = d;
        d = new TrendingData();
        t = new TrendingData.AxisValue("", 22L);
        d.setAxisValue(t);
        v = new TrendingData.DataValue("value", 22.0);
        v1 = new TrendingData.DataValue("onpoint", 12.0);
        d.setDataValue(new TrendingData.DataValue[]{v, v1});
        data[1] = d;
        d = new TrendingData();
        t = new TrendingData.AxisValue("", 23L);
        d.setAxisValue(t);
        v = new TrendingData.DataValue("value", 23.0);
        v1 = new TrendingData.DataValue("onpoint", 13.0);
        d.setDataValue(new TrendingData.DataValue[]{v, v1});
        data[2] = d;
        d = new TrendingData();
        t = new TrendingData.AxisValue("", 24L);
        d.setAxisValue(t);
        v = new TrendingData.DataValue("value", 24.0);
        v1 = new TrendingData.DataValue("onpoint", 14.0);
        d.setDataValue(new TrendingData.DataValue[]{v, v1});
        data[3] = d;
        ArrayList<ChannelMetaData> metaList = new ArrayList<ChannelMetaData>();
        metaList.add(new ChannelMetaData("offD", "4", -1L, 22L));
        metaList.add(new ChannelMetaData("offD", "4", 23L, -1L));
        metaList.add(new ChannelMetaData("offS1", "S1", 21L, 30L));
        metaList.add(new ChannelMetaData("offS2", "S2", 15L, 22L));
        TrendingResult tr = new TrendingResult();
        tr.setTrendingDataArray(data);
        tr.setChannelMetadata(metaList);
        Trend trend = new Trend(new Trend.Descriptor("agent/path"));
        trend.setData(td);
        RestSource.Result r = new RestSource.Result("agent/path", 21L, 24L, true, 0, (Object)tr);
        tdNew = source.mergeDouble(trend, r, 17L, 24L, true, 0);
        Assert.assertArrayEquals((String)"merge times", (long[])new long[]{17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L}, (long[])tdNew.getTimes());
        Assert.assertArrayEquals((String)"merge times key", (long[])new long[]{17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L}, (long[])tdNew.getTimes("value"));
        Assert.assertArrayEquals((String)"merge values", (double[])new double[]{17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0}, (double[])tdNew.getValues(), (double)0.01);
        Assert.assertArrayEquals((String)"merge onpoint", (double[])new double[]{7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0}, (double[])tdNew.getValues("onpoint"), (double)0.01);
        Assert.assertArrayEquals((String)"merge offD times", (long[])new long[]{17L, 20L, 20L, 24L}, (long[])tdNew.getTimes("offD"));
        Assert.assertArrayEquals((String)"merge offD strings", (Object[])new String[]{"3", "3", "4", "4"}, (Object[])tdNew.getMetadata("offD"));
        Assert.assertArrayEquals((String)"merge offD double", (double[])new double[]{3.0, 3.0, 4.0, 4.0}, (double[])tdNew.getValues("offD"), (double)0.01);
        Assert.assertArrayEquals((String)"merge offS1 times", (long[])new long[]{17L, 24L}, (long[])tdNew.getTimes("offS1"));
        Assert.assertArrayEquals((String)"merge offS1 strings", (Object[])new String[]{"S1", "S1"}, (Object[])tdNew.getMetadata("offS1"));
        Assert.assertArrayEquals((String)"merge offS2 times", (long[])new long[]{17L, 22L}, (long[])tdNew.getTimes("offS2"));
        Assert.assertArrayEquals((String)"merge offS2 strings", (Object[])new String[]{"S2", "S2"}, (Object[])tdNew.getMetadata("offS2"));
    }

    @Test
    public void testGetChannels() {
        TreeSet paths = new TreeSet(source.getChannels());
        TreeSet<String> expected = new TreeSet<String>(Arrays.asList("a0/state/s0", "a0/state/c00/c10/s1", "a0/state/c01/c10/s1", "a0/state/c00/c10/s2", "a1/state/s0", "a0/string0", "a1/b/b0"));
        Assert.assertEquals(expected, paths);
    }

    @Test
    public void testGet() {
        System.out.println("First query 105 - 130");
        ArrayList<TrendData> dd = RestSourceTest.update(Arrays.asList(trendS0), 105L, 130L, false, 10);
        long[] range = dd.get(0).getTimeRange();
        long[] times = dd.get(0).getTimes();
        double[] values = dd.get(0).getValues();
        Object[] names = dd.get(0).getNames();
        Assert.assertArrayEquals((long[])new long[]{105L, 130L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{110L, 130L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"0", "1"}, (Object[])names);
        System.out.println("Full query 80 - 220");
        dd = RestSourceTest.update(Arrays.asList(trendS0, trendS1, trendS2, trendS3, trendS4, trendR0, trendB0), 80L, 220L, false, 10);
        range = dd.get(0).getTimeRange();
        times = dd.get(0).getTimes();
        values = dd.get(0).getValues();
        names = dd.get(0).getNames();
        Assert.assertArrayEquals((long[])new long[]{80L, 220L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{100L, 110L, 110L, 130L, 130L, 200L, 220L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"0", "1"}, (Object[])names);
        range = dd.get(1).getTimeRange();
        times = dd.get(1).getTimes();
        values = dd.get(1).getValues();
        names = dd.get(1).getNames();
        Assert.assertArrayEquals((long[])new long[]{80L, 220L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{100L, 120L, 120L, 200L, 200L, 220L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, 2.0, 2.0, 0.0, 0.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"0", "1", "2", "3", "4", "5", "6"}, (Object[])names);
        range = dd.get(2).getTimeRange();
        times = dd.get(2).getTimes();
        values = dd.get(2).getValues();
        names = dd.get(2).getNames();
        Assert.assertArrayEquals((long[])new long[]{80L, 220L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{110L, 130L, 130L, 140L, 140L, 200L, 200L, 220L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{2.0, 2.0, 1.0, 1.0, 5.0, 5.0, 2.0, 2.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"0", "1", "2", "3", "4", "5", "6"}, (Object[])names);
        range = dd.get(5).getTimeRange();
        times = dd.get(5).getTimes();
        values = dd.get(5).getValues();
        names = dd.get(5).getNames();
        Assert.assertArrayEquals((long[])new long[]{80L, 220L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{100L, 120L, 140L, 150L, 160L, 180L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{0.0, 1.0, 2.0, 2.0, 2.0, 1.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"0", "1", "2"}, (Object[])names);
        range = dd.get(6).getTimeRange();
        times = dd.get(6).getTimes();
        values = dd.get(6).getValues();
        names = dd.get(6).getNames();
        Assert.assertArrayEquals((long[])new long[]{80L, 220L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{110L, 130L, 140L, 160L, 200L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, 1.0, 1.0, 1.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"false", "true"}, (Object[])names);
        System.out.println("Cache only 130 - 200");
        dd = RestSourceTest.update(Arrays.asList(trendS0, trendS1, trendS2, trendS3, trendS4, trendR0, trendB0), 130L, 200L, true, 10);
        range = dd.get(1).getTimeRange();
        times = dd.get(1).getTimes();
        values = dd.get(1).getValues();
        names = dd.get(1).getNames();
        Assert.assertArrayEquals((long[])new long[]{130L, 200L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{130L, 200L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{2.0, 2.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"0", "1", "2", "3", "4", "5", "6"}, (Object[])names);
        range = dd.get(2).getTimeRange();
        times = dd.get(2).getTimes();
        values = dd.get(2).getValues();
        names = dd.get(2).getNames();
        Assert.assertArrayEquals((long[])new long[]{130L, 200L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{130L, 130L, 140L, 140L, 200L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{2.0, 1.0, 1.0, 5.0, 5.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"0", "1", "2", "3", "4", "5", "6"}, (Object[])names);
        System.out.println("Query 120 - 130, cache 130 - 145");
        dd = RestSourceTest.update(Arrays.asList(trendS0, trendS1, trendS2, trendS3, trendS4, trendR0, trendB0), 120L, 145L, true, 10);
        range = dd.get(0).getTimeRange();
        times = dd.get(0).getTimes();
        values = dd.get(0).getValues();
        names = dd.get(0).getNames();
        Assert.assertArrayEquals((long[])new long[]{120L, 145L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{120L, 130L, 130L, 145L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, 1.0, 1.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"0", "1"}, (Object[])names);
        range = dd.get(1).getTimeRange();
        times = dd.get(1).getTimes();
        values = dd.get(1).getValues();
        names = dd.get(1).getNames();
        Assert.assertArrayEquals((long[])new long[]{120L, 145L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{120L, 130L, 145L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{2.0, 2.0, 2.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"0", "1", "2", "3", "4", "5", "6"}, (Object[])names);
        range = dd.get(4).getTimeRange();
        times = dd.get(4).getTimes();
        values = dd.get(4).getValues();
        names = dd.get(4).getNames();
        Assert.assertArrayEquals((long[])new long[]{120L, 145L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{120L, 130L, 130L, 140L, 140L, 145L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, 1.0, 1.0, 0.0, 0.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"x", "y", "z"}, (Object[])names);
        System.out.println("Cache 135 - 145, query 145 - 195");
        dd = RestSourceTest.update(Arrays.asList(trendS0, trendS1, trendS2, trendS3, trendS4, trendR0, trendB0), 135L, 195L, true, 10);
        range = dd.get(0).getTimeRange();
        times = dd.get(0).getTimes();
        values = dd.get(0).getValues();
        names = dd.get(0).getNames();
        Assert.assertArrayEquals((long[])new long[]{135L, 195L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{135L, 195L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{1.0, 1.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"0", "1"}, (Object[])names);
        range = dd.get(1).getTimeRange();
        times = dd.get(1).getTimes();
        values = dd.get(1).getValues();
        names = dd.get(1).getNames();
        Assert.assertArrayEquals((long[])new long[]{135L, 195L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{135L, 195L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{2.0, 2.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"0", "1", "2", "3", "4", "5", "6"}, (Object[])names);
        range = dd.get(2).getTimeRange();
        times = dd.get(2).getTimes();
        values = dd.get(2).getValues();
        names = dd.get(2).getNames();
        Assert.assertArrayEquals((long[])new long[]{135L, 195L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{135L, 140L, 140L, 195L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{1.0, 1.0, 5.0, 5.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"0", "1", "2", "3", "4", "5", "6"}, (Object[])names);
        range = dd.get(3).getTimeRange();
        times = dd.get(3).getTimes();
        values = dd.get(3).getValues();
        names = dd.get(3).getNames();
        Assert.assertArrayEquals((long[])new long[]{135L, 195L}, (long[])range);
        Assert.assertArrayEquals((long[])new long[]{135L, 190L, 190L, 195L}, (long[])times);
        Assert.assertArrayEquals((double[])new double[]{2.0, 2.0, 1.0, 1.0}, (double[])values, (double)0.1);
        Assert.assertArrayEquals((Object[])new String[]{"0", "1", "2"}, (Object[])names);
    }

    private String toString(RestSource.Result r) {
        StringBuilder sb = new StringBuilder("Result: ");
        sb.append(r.path).append(", ");
        sb.append(r.begin).append("-").append(r.end);
        sb.append(", raw ").append(r.raw).append(", bins ").append(r.bins).append(".");
        if (r.data instanceof List) {
            for (StateChange sc : r.getStateChanges()) {
                sb.append(sc.getTime()).append(" : ").append(sc.getState("", "s0")).append("\n");
            }
        }
        return sb.toString();
    }

    private static void clearTrends() {
        trendS0 = new Trend(new Trend.Descriptor("a0/state/s0"));
        trendS1 = new Trend(new Trend.Descriptor("a0/state/c00/c10/s1"));
        trendS2 = new Trend(new Trend.Descriptor("a0/state/c01/c10/s1"));
        trendS3 = new Trend(new Trend.Descriptor("a0/state/c00/c10/s2"));
        trendS4 = new Trend(new Trend.Descriptor("a1/state/s0"));
        trendR0 = new Trend(new Trend.Descriptor("a0/string0"));
        trendB0 = new Trend(new Trend.Descriptor("a1/b/b0"));
    }

    private static ArrayList<TrendData> update(List<Trend> trends, long begin, long end, Boolean raw, Integer nBins) {
        ArrayList dd = source.get(trends, begin, end, raw, nBins);
        int i = 0;
        for (Trend trend : trends) {
            trend.setData((TrendData)dd.get(i++));
        }
        return dd;
    }
}

