package org.lsst.ccs.gconsole.util.swing;

import javax.swing.JComboBox;

/**
 * Augmented {@code JComboBox} and related static utilities.
 *
 * @author onoprien
 */
public class SComboBox extends JComboBox {

// -- Fields : -----------------------------------------------------------------

// -- Life cycle : -------------------------------------------------------------
    
// -- Static utilities : -------------------------------------------------------
    
    static public void setPrototypeDisplayValue(JComboBox box) {
        String prototype = "";
        int prototypeLength = 0;
        for (int i = box.getItemCount(); i>0; ) {
            Object item = box.getItemAt(--i);
            if (item != null) {
                String s = item.toString();
                int n = s.length();
                if (n > prototypeLength) {
                    prototypeLength = n;
                    prototype = s;
                }
            }
        }
        box.setPrototypeDisplayValue(" "+ prototype);
    }

}
