package org.lsst.ccs.gconsole.util;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

/**
 * 
 *
 * @author onoprien
 */
public class ThreadUtil {

    static public void invokeLater(Runnable run) {
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }
    
    static public void invokeAndWait(Runnable run) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                run.run();
            } catch (Throwable t) {
                throw new InvocationTargetException(t);
            }
        } else {
            SwingUtilities.invokeAndWait(run);
        }
    }
    
}
