package org.lsst.ccs.gconsole.util;

import java.util.function.Predicate;
import java.util.regex.Pattern;

/**
 * Predicate that compiles a regular expression and returns true for strings that match it.
 * When we switch to Java 11+, we can use {@code Pattern.asMatchPredicate()} instead. // FIXME
 * 
 * @author onoprien
 */
public class MatchPredicate implements Predicate<String> {

// -- Fields : -----------------------------------------------------------------
    
    private final Pattern p;

// -- Life cycle : -------------------------------------------------------------
    
    public MatchPredicate(String regex) {
        p = Pattern.compile(regex);
    }
    
// -- Implement Predicate : ----------------------------------------------------

    @Override
    public boolean test(String t) {
        return p.matcher(t).matches();
    }

}
