/**
 * The CCS graphical console plugin and infrastructure classes that support displaying monitoring data.
 * 
 * <h2>Monitoring GUI framework</h2>
 * 
 * {@link org.lsst.ccs.gconsole.plugins.monitor.LsstMonitorPlugin} enables menus and provides methods
 * for opening new monitoring view, exporting their content into files, saving and restoring its state.
 * <p>
 * {@link org.lsst.ccs.gconsole.plugins.monitor.MonitorView} is the interface to be implemented by any
 * software component that needs to manage a graphical console page displaying monitoring data. It 
 * registers itself with the {@link org.lsst.ccs.gconsole.agent.AgentStatusAggregator} and updates 
 * in response to status change events. A view has an 
 * {@link org.lsst.ccs.gconsole.agent.AgentChannelsFilter} associated with it.
 * <p>
 * {@link org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView1} is the first level adapter
 * designed to simplify implementing {@link org.lsst.ccs.gconsole.plugins.monitor.MonitorView}. It
 * provides machinery for listening to status aggregator events and allows the developer to update
 * the view by implementing responses to addition, removal, and modification of data channels. 
 * Channels are added along with the display path string as defined by the filter associated with
 * the view. The same channel might be added multiple times with different paths.
 * <p>
 * {@link org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView2} is the second level adapter
 * built on top of {@link org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView1}. It wraps each
 * added channel into {@link org.lsst.ccs.gconsole.plugins.monitor.ChannelHandle} and maintains a
 * map of display paths to channel handles. For minimal functionality, the developer only needs to
 * implement a single method
 * ({@link org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView2#resetChannels() resetChannels()})
 * that rebuilds the view based on that map whenever channels are added or removed. The view is 
 * updated automatically as long as the correct {@link org.lsst.ccs.gconsole.plugins.monitor.Updatable}
 * is set for each {@link org.lsst.ccs.gconsole.plugins.monitor.ChannelHandle}.
 * <p>
 * The package contains several concrete views - 
 * {@link org.lsst.ccs.gconsole.plugins.monitor.TreeView}, 
 * {@link org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView}, 
 * {@link org.lsst.ccs.gconsole.plugins.monitor.ConfigView} - 
 * as well as two utility views designed to combine several concrete views into a single view
 * that can be managed by the graphical console: 
 * {@link org.lsst.ccs.gconsole.plugins.monitor.TabbedView} and
 * {@link org.lsst.ccs.gconsole.plugins.monitor.CompoundView}.
 * <p>
 * The base class for most monitoring tables used by various views is
 * {@link org.lsst.ccs.gconsole.plugins.monitor.MonitorTable}.
 * This class implements a table model as a 2-dimensional list of 
 * {@link org.lsst.ccs.gconsole.plugins.monitor.MonitorCell},
 * handles mouse events, and provides a basic implementation of the
 * {@link org.lsst.ccs.gconsole.plugins.monitor.Updatable} interface.
 * {@link org.lsst.ccs.gconsole.plugins.monitor.MonitorTableCellRenderer} class provides the default
 * renderer for {@link org.lsst.ccs.gconsole.plugins.monitor.FormattedValue}.
 * Several concrete subclasses of the {@link org.lsst.ccs.gconsole.plugins.monitor.MonitorTable}
 * are available for use in views: 
 * {@link org.lsst.ccs.gconsole.plugins.monitor.SectionedTable},
 * {@link org.lsst.ccs.gconsole.plugins.monitor.MeshTable},
 * {@link org.lsst.ccs.gconsole.plugins.monitor.TreeTable}.
 * <p>
 * Formatting of table cells is done by {@link org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat}.
 * It can be subclassed to customize formatting.
 * 
 * 
 */
package org.lsst.ccs.gconsole.plugins.monitor;
