package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;

/**
 * Default {@link MonitorView}.
 * Displays pages in tabs and configuration view at the bottom.
 *
 * @author onoprien
 */
public final class DefaultView extends CompoundView {

// -- Fields : -----------------------------------------------------------------
    
    static public final String CREATOR_PATH = "Built-In/Default";
    static public final String CREATOR_PATH_CONF = "Built-In/Default, Configurable";
    
    private final AbstractMonitorView dataView;
    private final ConfigView controlView;

// -- Life cycle : -------------------------------------------------------------
    
    @Create(category = MonitorView.CATEGORY,
            name = "Default",
            path = CREATOR_PATH,
            description = "Default monitoring data view.")
    public DefaultView() {
        this(true, null);
        getDescriptor().setName("Default");
    }
    
    @Create(category = MonitorView.CATEGORY,
            name = "Default, Configurable",
            path = CREATOR_PATH_CONF,
            description = "Default monitoring data view, configurable at creation time.")
    public DefaultView(
            @Par(def = "true", desc = "Show groups of channels in separate tabs. The filter is assumed to provide display paths in group//rest/of/path format. If no group names are present, no tabs are displayed.") boolean groupTabs,
            @Par(def = Par.NULL, desc = "List of fields to display. If not specified, the set of fields provided by the filter is used. Available standard fields: VALUE, UNITS, LOW_WARN, LOW_ALARM, ALERT_LOW, HIGH_WARN, HIGH_ALARM, ALERT_HIGH, DESCR") List<String> fields
    ) {
        super(new JPanel(new BorderLayout()));
        descriptor = new Descriptor();
        getDescriptor().setName("Default, Configurable");
        if (groupTabs) {
            dataView = new TabbedGroupView(0, false);
        } else {
            dataView = new LazyTreeView();
        }
        if (fields != null) {
            dataView.getDescriptor().setFields(fields.toArray(new String[0]));
        }
        addView(dataView, Mode.INDEPENDENT);
        getPanel().add(dataView.getPanel(), BorderLayout.CENTER);
        controlView = new ConfigView();
        addView(controlView, Mode.INDEPENDENT);
        getPanel().add(controlView.getPanel(), BorderLayout.SOUTH);
    }

    @Override
    public void setFormatter(MonitorFormat formatter) {
        dataView.setFormatter(formatter);
    }

    @Override
    public MonitorFormat getFormater() {
        return dataView.getFormater();
    }
    
    
// -- Saving/restoring : -------------------------------------------------------
    
    static public class Descriptor extends CompoundView.Descriptor {
        
    }

}
