package org.lsst.ccs.gconsole.plugins.demo.swing;
    
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.SwingUtilities;
import javax.swing.JFrame;

/**
 * 
 *
 * @author onoprien
 */
public class Tester {

// -- Fields : -----------------------------------------------------------------

// -- Life cycle : -------------------------------------------------------------

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> createAndShowGUI());
    }

    private static void createAndShowGUI() {
        System.out.println("Created GUI on EDT? " + SwingUtilities.isEventDispatchThread());
        JFrame f = new JFrame("Swing Paint Demo");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);


        Panel p1 = new Panel();
        p1.setName("p1");
        p1.setLayout(new LayMan(new BorderLayout()));
        
        f.add(p1);

        Panel p2 = new Panel();
        p2.setName("p2");
        p2.setLayout(new LayMan(new BorderLayout()));
        p2.setPreferredSize(new Dimension(200, 200));
        p1.add(p2, BorderLayout.CENTER);

        System.out.println("Packing frame...");

        f.pack();
        f.setVisible(true);
    }
}
