/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.gconsole.plugins.demo.monitor.image;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTableCellRenderer;

/**
 * 
 *
 * @author onoprien
 */
public class Test {

// -- Fields : -----------------------------------------------------------------
    
    static private final Model model = new Model();

// -- Life cycle : -------------------------------------------------------------

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> createAndShowGUI());
    }

    private static void createAndShowGUI() {
        
        System.out.println("Starting... ");
        JFrame f = new JFrame("Test");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        Table table = new Table(model);
//        table.setBorder(BorderFactory.createLineBorder(Color.BLUE));
//        MonitorTableCellRenderer renderer = new MonitorTableCellRenderer();
//        renderer.setEnsureWidth(true);
//        renderer.setEnsureHeight(true);
//        setDefaultRenderer(Object.class, renderer);
        table.setDefaultRenderer(Object.class, new Renderer());
//        table.setFillsViewportHeight(false);
//        table.setRowHeight(40);
//        table.setRowMargin(10);

        f.add(table, BorderLayout.CENTER);
        
        JTextField field = new JTextField();
        field.addActionListener(e -> {
            String[] ss = field.getText().trim().split(" ");
            int row = Integer.parseInt(ss[0]);
            int col = Integer.parseInt(ss[1]);
            model.data[row][col] = ss[2];
            model.fireTableCellUpdated(row, col);
//            model.fireTableStructureChanged();
        });
        f.add(field, BorderLayout.SOUTH);
        
        f.pack();
        f.setVisible(true);

    }
    
    static private class Table extends JTable {
        
        Table(TableModel model) {
            super(model);
        }

        @Override
        public void doLayout() {
            System.out.println("layout: "+ this.getSize());
            System.out.println("RH: "+ this.getRowHeight() +", RM: "+ this.getRowMargin());
            super.doLayout();
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            System.out.println("Table setBounds "+ x +" "+ y +" "+ width +" "+ height);
            for (int row=0; row<getRowCount(); row++) {
                System.out.println(" "+ this.getRowHeight(row));
            }
            System.out.println("");
            super.setBounds(x, y, width, height);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            System.out.println("Table getMinimumSize = "+ d);
            return d;
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension d = super.getMaximumSize();
            System.out.println("Table getMaximumSize = "+ d);
            return d;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            System.out.println("Table getPreferredSize = "+ d);
            return d;
        }
        
    }
    
    static private class Renderer extends DefaultTableCellRenderer {

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int w = c.getMinimumSize().width+1;
            if (w > table.getColumnModel().getColumn(column).getMinWidth()) {
                table.getColumnModel().getColumn(column).setMinWidth(w);
            }
            int h = c.getMinimumSize().height;
            if (h > table.getRowHeight(row)) {
                table.setRowHeight(row, h);
                System.out.println("--- Setting row height "+ h);
            }
//            setBorder(BorderFactory.createLineBorder(Color.RED));
            return c;
        }

        @Override
        public int getHorizontalAlignment() {
            return SwingUtilities.CENTER;
        }

        @Override
        public int getVerticalAlignment() {
            return super.getVerticalAlignment();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            System.out.println("pref size "+ d);
            return d;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = super.getPreferredSize();
            System.out.println("min size = "+ d);
            return d;
        }

        @Override
        public Dimension getMaximumSize() {
            System.out.println("max size");
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public void setBounds(Rectangle r) {
//            System.out.println("setBounds "+ r);
            super.setBounds(r);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
//            System.out.println("setBounds "+ x +" "+ y +" "+ width +" "+ height);
            super.setBounds(x, y, width, height);
        }

        @Override
        public void setSize(Dimension d) {
            System.out.println("setSize "+ d);
            super.setSize(d);
        }

        @Override
        public void setSize(int width, int height) {
            System.out.println("setSize "+ width +" "+ height);
            super.setSize(width, height);
        }
        
    }
    
    static private class Model extends AbstractTableModel {
        
        String[][] data = new String[2][2];
        
        Model() {
            data[1][1] = "<html>1234567890<br>987654321";
        }

        @Override
        public int getRowCount() {
            return data.length;
        }

        @Override
        public int getColumnCount() {
            return data[0].length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return data[rowIndex][columnIndex];
        }
        
    }

}
