package org.lsst.ccs.gconsole.plugins.demo.monitor;

import java.awt.event.ActionEvent;
import java.util.*;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusAggregator;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusListener;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

/**
 * 
 *
 * @author onoprien
 */

@Plugin(name ="Status Aggregator Demo",
        id="aggregator-demo",
        description="Status Aggregator test plugin",
        loadAtStart=false)
public class AggregatorTest extends ConsolePlugin {

// -- Fields : -----------------------------------------------------------------
    
    private Action actDemo1, actDemo2;
    private Listener listener1, listener2;

// -- Life cycle : -------------------------------------------------------------

    @Override
    public void initialize() {
        
        actDemo1 = new AbstractAction("Listener 1") {
            @Override
            public void actionPerformed(ActionEvent e) {
                if ((Boolean)getValue(Action.SELECTED_KEY)) {
                    startDemo1();
                } else {
                    stopDemo(listener1);
                }
            }
        };
        actDemo1.putValue(Action.SELECTED_KEY, false);
        getServices().addMenu(actDemo1, "Demo", "Status Aggregator");

        
        actDemo2 = new AbstractAction("Listener 2") {
            @Override
            public void actionPerformed(ActionEvent e) {
                if ((Boolean)getValue(Action.SELECTED_KEY)) {
                    startDemo2();
                } else {
                    stopDemo(listener2);
                }
            }
        };
        actDemo2.putValue(Action.SELECTED_KEY, false);
        getServices().addMenu(actDemo2, "Demo", "Status Aggregator");

    }

    @Override
    public void start() {        
    }

    @Override
    public void stop() {
    }
 
    @Override
    public void shutdown() {
    }
    
    
// -- Addidng/removing listeners : ---------------------------------------------
    
    private void startDemo1() {
        List<String> agents = Collections.singletonList("demo-subsystem-with-monitoring");
        List<String> channels = Collections.singletonList("/state/");
        getConsole().getStatusAggregator().addListener(listener1 = new Listener("1"), agents, channels);
    }
    
    private void startDemo2() {
        List<String> agents = Collections.singletonList("demo-subsystem-with-monitoring");
        List<String> channels = Collections.singletonList(AgentChannel.Key.STATE);
        getConsole().getStatusAggregator().addListener(listener2 = new Listener("2"), agents, channels);
    }
    
    private void stopDemo(Listener listener) {
        getConsole().getStatusAggregator().removeListener(listener);
    }
   
}


// -- Printing AgentStatusListener: --------------------------------------------

class Listener implements AgentStatusListener {
    
    private final String name;
    
    Listener(String name) {
        this.name = name;
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
        System.out.println("Listener "+ name +": change : "+ event);
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        System.out.println("Listener "+ name +": disconnect : "+ event);
    }

    @Override
    public void configure(AgentStatusEvent event) {
        System.out.println("Listener "+ name +": config : "+ event);
    }

    @Override
    public void connect(AgentStatusEvent event) {
        System.out.println("Listener "+ name +": connect : "+ event);
    }

}
