package org.lsst.ccs.gconsole.plugins.demo.lock;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.command.CommandService;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentLockService.AgentLockUpdateListener;

/**
 * Plugin for testing lock management.
 *
 * @author onoprien
 */
@Plugin(name = "Lock Management Test Plugin",
        id = "lock-test",
        description = "Test for lock management.",
        loadAtStart = false)
public class LockPlugin extends ConsolePlugin {

// -- Fields : -----------------------------------------------------------------
    
// -- Life cycle : -------------------------------------------------------------
    
    @Override
    public void initialize() {
        
        Console.getConsole().getAgentService(AgentLockService.class).addAgentLockUpdateListener(new AgentLockUpdateListener() {
            @Override
            public void onAgentHeldLockUpdate(String agentName, AgentLock lock) {
                System.out.println("Lock held: agent "+ agentName +", lock "+ AgentLockInfo.asString(lock));
            }
            @Override
            public void onAgentLockUpdate(String agentName, String owner, AgentLock lock) {
                System.out.println("Lock self: agent "+ agentName +", owner "+ owner +", lock "+ AgentLockInfo.asString(lock));
            }
            @Override
            public void onGlobalLockUpdate(String agentName, String owner, AgentLock lock) {
                System.out.println("Lock global: agent "+ agentName +", owner "+ owner +", lock "+ AgentLockInfo.asString(lock));
            }
            @Override
            public void onAgentLevelChange(String agentName, int level) {
                System.out.println("Lock level: agent "+ agentName +", level "+ level);
            }
        });
        
        getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(new AgentPresenceListener() {

            @Override
            public void connected(AgentInfo... agents) {
                for (AgentInfo ai : agents) {
                    if (ai.getName().equals("demo-subsystem")) {
                        Action act = new AbstractAction("Send level 1 command") {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                try {
                                    CommandService.getService().sendEncoded("demo-subsystem", "testUserQuery1");
                                } catch (RuntimeException x) {
                                }
                            }
                        };
                        getServices().addMenu(act, "CCS Subsystems", ai.getName());
                    }
                }
            }
            @Override
            public void disconnected(AgentInfo... agents) {
            }
            
        });
    }
    
// -- Local methods : ----------------------------------------------------------
        
}
