package org.lsst.ccs.gconsole.base.filter;

import java.util.*;
import java.util.regex.Pattern;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;

/**
 * Regular expression based channels filter.
 * The filter selects channels that match a regular expression and leaves the paths unchanged.
 *
 * @author onoprien
 */
public class RegExFilter extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    static public final String CREATOR_PATH = "Built-In/Basic/Regular Expression";
    
    private final String name;
    private final String regex;

// -- Life cycle : -------------------------------------------------------------
    
    @Create(category = AgentChannelsFilter.CATEGORY,
            name = "Regular expression filter",
            path = CREATOR_PATH,
            description = "Channels filter that uses a regular expression to select channels and leaves their paths unchanged.")
    public RegExFilter(
            @Par(def = "RegEx", desc = "Filter name.") String name,
            @Par(desc = "Regular expression to be applied to the channel path.") String regex,
            @Par(def = "false", desc = "Match the whole path. If checked, a channel is accepted only if the provided regular expression matches its entire path. Otherwise, a channel is accepted if the regular expression matches any part of the path.") boolean wholePath)
    {
        this.name = name;
        if (regex == null || regex.isEmpty()) throw new IllegalArgumentException("The regular expression cannot be empty");
        if (!wholePath) {
            regex = ".*"+ regex +".*";
        }
        Pattern.compile(regex); // check regex validity
        this.regex = regex;
    }
    
    
// -- Implementing filter : ----------------------------------------------------

    @Override
    public String getName() {
        return name;
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList(regex);
    }
    
}
