/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Header;
import org.jgroups.util.Util;

public class SaslHeader
extends Header {
    private Type type;
    private byte[] payload;

    public SaslHeader() {
    }

    public SaslHeader(Type type, byte[] payload) {
        this.type = type;
        this.payload = payload;
    }

    @Override
    public short getMagicId() {
        return 85;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public SaslHeader payload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public byte[] token() {
        return this.payload;
    }

    public SaslHeader type(Type type) {
        this.type = type;
        return this;
    }

    @Override
    public Supplier<? extends Header> create() {
        return SaslHeader::new;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.type.ordinal());
        Util.writeByteBuffer(this.payload, out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        this.type = Type.values()[in.readByte()];
        this.payload = Util.readByteBuffer(in);
    }

    @Override
    public int serializedSize() {
        return Util.size(this.payload);
    }

    @Override
    public String toString() {
        return "SaslHeader{type=" + (Object)((Object)this.type) + ", serializedSize=" + this.serializedSize() + ", prot_id=" + this.prot_id + '}';
    }

    public static enum Type {
        CHALLENGE,
        RESPONSE;

    }
}

