/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.MenuElement;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTableCellRenderer;
import org.lsst.ccs.gconsole.plugins.monitor.Updatable;
import org.lsst.ccs.gconsole.plugins.trending.TrendingService;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.command.CommandService;
import org.lsst.ccs.gconsole.services.lock.Lock;
import org.lsst.ccs.gconsole.util.swing.BoxedTextField;

public abstract class MonitorTable
extends AbstractTableModel
implements Updatable {
    public static final MonitorFormat DEFAULT_FORMAT = new MonitorFormat();
    public static final List<MonitorField> DEFAULT_FIELDS = Collections.unmodifiableList(Arrays.asList(MonitorField.VALUE, MonitorField.UNITS, MonitorField.ALERT_LOW, MonitorField.LOW_ALARM, MonitorField.LOW_WARN, MonitorField.HIGH_WARN, MonitorField.HIGH_ALARM, MonitorField.ALERT_HIGH, MonitorField.DESCR));
    public static final List<MonitorField> DEFAULT_COMPACT_FIELDS = Collections.unmodifiableList(Arrays.asList(MonitorField.VALUE, MonitorField.DESCR));
    protected int nRows;
    protected int nColumns;
    protected ArrayList<ArrayList<MonitorCell>> cells;
    protected MonitorFormat format = DEFAULT_FORMAT;
    protected boolean limitMaxWidth = false;
    protected Listener listener;
    protected final Event CELLS_EVENT = new Event(this, Event.Reason.CELLS);
    protected final Event TABLE_EVENT = new Event(this, Event.Reason.TABLE);

    protected MonitorTable() {
    }

    protected MonitorTable(MonitorCell[][] cells) {
        this.nRows = cells.length;
        this.nColumns = cells[0].length;
        this.cells = new ArrayList(this.nRows);
        for (MonitorCell[] row : cells) {
            this.cells.add(new ArrayList<MonitorCell>(Arrays.asList(row)));
        }
    }

    public void destroy() {
    }

    public void setFormat(MonitorFormat format) {
        this.format = format;
        if (this.cells != null) {
            boolean change = false;
            for (ArrayList<MonitorCell> row : this.cells) {
                for (MonitorCell cell : row) {
                    if (cell == null || cell.getField() == null || !cell.getField().isUpdatable() || cell.getField().equals(MonitorField.NULL)) continue;
                    change = format.format(cell);
                }
            }
            if (change) {
                this.fireChangeEvent(this.CELLS_EVENT);
            }
        }
    }

    public void setLimitMaxWidth(boolean limitMaxWidth) {
        this.limitMaxWidth = limitMaxWidth;
    }

    @Override
    public int getRowCount() {
        return this.nRows;
    }

    @Override
    public int getColumnCount() {
        return this.nColumns;
    }

    @Override
    public FormattedValue getValueAt(int row, int column) {
        return this.cells.get(row).get(column).getFormattedValue();
    }

    @Override
    public void update(DisplayChannel item, List<MonitorField> fields) {
        fields.forEach(field -> {
            List<int[]> affectedCells = this.getCells(item, (MonitorField)field);
            for (int[] index : affectedCells) {
                MonitorCell cell = this.cells.get(index[0]).get(index[1]);
                field = cell.getField();
                FormattedValue data = this.format.format((MonitorField)field, item);
                if (data.equals(cell.getFormattedValue())) continue;
                cell.setFormattedValue(data);
                this.fireTableCellUpdated(index[0], index[1]);
            }
        });
        this.fireChangeEvent(this.CELLS_EVENT);
    }

    @Override
    public void update(DisplayChannel channelHandle) {
        this.update(channelHandle, Collections.singletonList(null));
    }

    protected List<int[]> getCells(DisplayChannel item, MonitorField field) {
        ArrayList<int[]> out = new ArrayList<int[]>();
        for (int row = 0; row < this.nRows; ++row) {
            for (int col = 0; col < this.nColumns; ++col) {
                MonitorCell cell = this.cells.get(row).get(col);
                if (!cell.getChannels().contains(item) || field != null && !field.equals(cell.getField())) continue;
                out.add(new int[]{row, col});
            }
        }
        return out;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    protected void fireChangeEvent(Event.Reason reason) {
        this.fireChangeEvent(reason == Event.Reason.CELLS ? this.CELLS_EVENT : this.TABLE_EVENT);
    }

    protected void fireChangeEvent(Event event) {
        if (this.listener != null) {
            this.listener.stateChanged(event);
        }
    }

    public JTable getTable() {
        JTable table = this.makeTable();
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        TableCellRenderer headerRenderer = header.getDefaultRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setHorizontalAlignment(0);
        }
        MonitorTableCellRenderer renderer = new MonitorTableCellRenderer();
        renderer.setEnsureWidth(true);
        table.setDefaultRenderer(Object.class, renderer);
        table.setAutoResizeMode(3);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setRowHeight(table.getRowHeight() + 2);
        table.setShowGrid(true);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MonitorTable.this.tableMouseClicked(evt);
            }
        });
        for (int col = 0; col < this.nColumns; ++col) {
            TableColumn column = table.getColumnModel().getColumn(col);
            Component comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            int maxWidth = comp.getPreferredSize().width;
            for (int row = 0; row < this.nRows; ++row) {
                comp = renderer.getTableCellRendererComponent(table, this.getValueAt(row, col), false, false, row, col);
                maxWidth = Math.max(maxWidth, comp.getPreferredSize().width);
            }
            column.setPreferredWidth(maxWidth);
            if (!this.limitMaxWidth) continue;
            column.setMaxWidth(maxWidth);
        }
        return table;
    }

    protected JTable makeTable() {
        return new JTable(this);
    }

    protected void tableMouseClicked(MouseEvent evt) {
        int nClick = evt.getClickCount();
        JTable table = (JTable)evt.getSource();
        Point point = evt.getPoint();
        int row = table.rowAtPoint(point);
        int column = table.columnAtPoint(point);
        MonitorCell cc = this.cells.get(row).get(column);
        FormattedValue fv = cc.getFormattedValue();
        if (nClick == 1) {
            if (fv != null && fv.getClick1() != null) {
                fv.getClick1().accept(cc);
            }
        } else if (nClick == 2) {
            AgentChannel channel;
            if (fv != null && fv.value instanceof AgentLock) {
                this.editLock((AgentLock)fv.value, table);
                return;
            }
            MonitorField field = cc.getField();
            List<DisplayChannel> items = cc.getChannels();
            if (field != null && items.size() == 1 && (channel = items.get(0).getChannel()) != null) {
                Object published = field.getValue(channel);
                if (published instanceof ConfigurationParameterInfo) {
                    ConfigurationParameterInfo conf = (ConfigurationParameterInfo)published;
                    if (!(conf.isFinal() || conf.isReadOnly() || conf.isBuild())) {
                        MonitorTable.edit(evt.getComponent(), conf, field, channel);
                    }
                } else if (MonitorField.VALUE.equals(field)) {
                    String trendingKey = (String)channel.get("_key_");
                    if (trendingKey == null) {
                        trendingKey = channel.getLocalPath();
                    }
                    String[] path = new String[]{channel.getAgentName(), trendingKey};
                    TrendingService trending = (TrendingService)Console.getConsole().getConsoleLookup().lookup(TrendingService.class);
                    if (trending == null) {
                        return;
                    }
                    trending.show(path);
                }
            }
        }
    }

    public boolean showHeader() {
        return true;
    }

    private void editLock(AgentLock agentLock, JTable table) {
        Lock lock = new Lock(agentLock.getAgentName());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 2));
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10), BorderFactory.createEtchedBorder()));
        box.add(Box.createHorizontalGlue());
        box.add(lock);
        box.add(Box.createHorizontalGlue());
        panel.add(box);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(3, 1));
        lock.addListener(l -> {
            buttonPanel.removeAll();
            JPopupMenu menu = lock.getComponentPopupMenu();
            ArrayList<Action> actions = new ArrayList<Action>(3);
            for (MenuElement e : menu.getSubElements()) {
                if (!(e instanceof JMenuItem)) continue;
                actions.add(((JMenuItem)e).getAction());
            }
            actions.forEach(a -> buttonPanel.add(new JButton((Action)a)));
            panel.revalidate();
            panel.repaint();
        });
        panel.add(buttonPanel);
        JOptionPane.showOptionDialog(table, panel, "Lock / Unlock", -1, -1, null, new Object[]{"Done"}, "Done");
    }

    public static List<MonitorField> trimAbsentFields(List<MonitorField> fields, Collection<DisplayChannel> channels, Collection<MonitorField> exclude) {
        if (fields == null) {
            fields = Collections.emptyList();
        }
        LinkedHashSet<MonitorField> requestedFields = new LinkedHashSet<MonitorField>(fields);
        if (exclude != null) {
            requestedFields.removeAll(exclude);
        }
        HashSet<MonitorField> presentFields = new HashSet<MonitorField>();
        if (requestedFields.remove(MonitorField.VALUE)) {
            presentFields.add(MonitorField.VALUE);
        }
        block0: for (DisplayChannel ch : channels) {
            for (AgentChannel channel : ch.getChannels()) {
                Iterator it = requestedFields.iterator();
                while (it.hasNext()) {
                    MonitorField f = (MonitorField)it.next();
                    if (f.getValue(channel) == null) continue;
                    presentFields.add(f);
                    it.remove();
                }
                if (!requestedFields.isEmpty()) continue;
                continue block0;
            }
        }
        if (fields.size() == presentFields.size()) {
            return fields;
        }
        if (presentFields.contains(MonitorField.HIGH_WARN) || presentFields.contains(MonitorField.HIGH_ALARM)) {
            presentFields.add(MonitorField.ALERT_HIGH);
        }
        if (presentFields.contains(MonitorField.LOW_WARN) || presentFields.contains(MonitorField.LOW_ALARM)) {
            presentFields.add(MonitorField.ALERT_LOW);
        }
        ArrayList<MonitorField> out = new ArrayList<MonitorField>(presentFields.size());
        for (MonitorField f : fields) {
            if (!presentFields.contains(f)) continue;
            out.add(f);
        }
        return out;
    }

    public static void edit(Component parent, ConfigurationParameterInfo conf, MonitorField field, AgentChannel channel) {
        JPanel root = new JPanel(new BorderLayout());
        StringBuilder sb = new StringBuilder("<html>");
        sb.append("Subsystem: <b>").append(channel.getAgentName()).append("</b>.<br>");
        sb.append("Component: <b>").append(conf.getComponentName()).append("</b>.<br>");
        sb.append("Parameter: <b>").append(conf.getParameterName()).append("</b><p>");
        sb.append("Category: <b>").append(conf.getCategoryName()).append("</b><br>");
        String s = conf.getDescription();
        if (s != null && !s.trim().isEmpty()) {
            sb.append("Description: ").append(s).append("<p>");
        }
        sb.append("Current value: <b>").append(conf.getCurrentValue()).append("</b><br>");
        sb.append("Configured value: <b>").append(conf.getConfiguredValue()).append("</b><p>");
        sb.append("&nbsp; <p></html>");
        JEditorPane info = new JEditorPane("text/html", sb.toString());
        info.setEditable(false);
        info.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        info.setBackground(new Color(255, 255, 255, 0));
        root.add((Component)info, "Center");
        Box input = Box.createHorizontalBox();
        root.add((Component)input, "South");
        input.add(new JLabel("Enter new value: "));
        BoxedTextField textField = new BoxedTextField(30);
        input.add(textField);
        input.add(Box.createHorizontalGlue());
        int out = JOptionPane.showOptionDialog(parent, root, "Change configuration parameter", 2, -1, null, null, null);
        if (out == 0) {
            String value = textField.getText();
            value = value.trim();
            String component = conf.getComponentName();
            CommandService.getService().sendEncoded(channel.getAgentName(), "change", component, conf.getParameterName(), value);
        }
    }

    public Serializable save() {
        return null;
    }

    public void restore(Serializable storageBean) {
    }

    public static interface Listener {
        public void stateChanged(Event var1);
    }

    public static class Event
    extends EventObject {
        private final Reason reason;

        public Event(MonitorTable source, Reason reason) {
            super(source);
            this.reason = reason;
        }

        @Override
        public MonitorTable getSource() {
            return (MonitorTable)super.getSource();
        }

        public Reason getReason() {
            return this.reason;
        }

        public static enum Reason {
            CELLS,
            TABLE;

        }
    }
}

