package org.lsst.ccs.gconsole.plugins.trending;

/**
 * Service that allows clients to request that a particular trending quantity be displayed.
 * The implementation should guarantee that methods declared by this interface can be called on any thread.
 */
public interface TrendingService {
    
    /**
     * Displays the trending quantity corresponding to the specified path. 
     * @param path For example new String[]{"ccs-refrig","CmpSucPrs"}
     */
    default void show(String[] path) {
        show(String.join("/", path));
    }
    
    /**
     * Displays the trending quantity corresponding to the specified path. 
     * @param path Slash-separated path.
     */
    default void show(String path) {
        show(new Trend.Descriptor(path));
    }
    
    /**
     * Displays the plot defined by the specified descriptor.
     * @param trendDescriptor 
     */
    void show(Trend.Descriptor trendDescriptor);
    
    /**
     * Displays the plot defined by the specified descriptor.
     * @param plotterDescriptor 
     */
    void show(TrendPlotter.Descriptor plotterDescriptor);
    
    /**
     * Displays the trending page defined by the specified descriptor.
     * @param pageDescriptor 
     */
    void show(TrendPage.Descriptor pageDescriptor);
    
}
