/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.agent.command;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bootstrap.SubstitutionTokenUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentPropertyPredicate;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.gconsole.agent.command.CommandCode;
import org.lsst.ccs.gconsole.agent.command.CommandHandle;
import org.lsst.ccs.gconsole.agent.command.CommandSender;
import org.lsst.ccs.gconsole.agent.command.CommandTargetAgent;
import org.lsst.ccs.gconsole.agent.command.CommandTask;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.services.AgentStateService;

public class CommandSenderTest
extends CcsTestCaseTemplate {
    private static volatile StringBuilder sb;
    private static volatile CommandTargetAgent worker;
    private static volatile Agent console;

    @BeforeClass
    public static void setUpClass() throws Exception {
        SingleCategoryTag.resetDefaultSources();
        SubstitutionTokenUtils.resetSubstitutionTokens();
        System.out.println("Starting CommandSender test");
        worker = new CommandTargetAgent();
        worker.startAgent();
        console = new Agent("console", AgentInfo.AgentType.CONSOLE);
        console.startAgent();
        try {
            ((AgentStateService)console.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 120L, TimeUnit.SECONDS);
        }
        catch (TimeoutException x) {
            Assert.fail((String)x.getMessage());
        }
        try {
            ((AgentStateService)worker.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 120L, TimeUnit.SECONDS);
        }
        catch (TimeoutException x) {
            Assert.fail((String)x.getMessage());
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("agentName", "worker");
        AgentPropertyPredicate innerPredicate = new AgentPropertyPredicate(properties);
        try {
            console.getMessagingAccess().getAgentPresenceManager().waitForAgentPredicate(innerPredicate, 10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException x) {
            Assert.fail((String)x.getMessage());
        }
        System.out.println("Agents started");
        sb = new StringBuilder();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        worker.shutdownAgent();
        console.shutdownAgent();
        sb = null;
        System.out.println("Done with CommandSender test");
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        sb.delete(0, sb.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecute() throws Exception {
        try {
            CommandSenderTest commandSenderTest;
            Handle handle = new Handle();
            CommandSender sender = new CommandSender(console.getMessagingAccess(), null, null, console.getScheduler());
            CommandTask task1 = sender.execute((CommandHandle)handle, Duration.ofSeconds(10L), "worker/command", new Object[]{true, 2, 2, -1, false});
            CommandTask task = sender.execute((CommandHandle)handle, Duration.ofSeconds(10L), "worker/command", new Object[]{false, 0, 2, -1, false});
            task1.getResult();
            task.getResult();
            task = sender.execute((CommandHandle)handle, Duration.ofSeconds(3L), "worker/command", new Object[]{true, 2, 3, -1, false});
            task.getResult();
            task = sender.execute((CommandHandle)handle, Duration.ofSeconds(-3L), "worker/command", new Object[]{true, 1, 4, 10, false});
            task.getResult();
            task = sender.execute((CommandHandle)handle, Duration.ofSeconds(3L), "worker/command", new Object[]{true, 1, 4, 10, false});
            task.getResult();
            task = sender.execute((CommandHandle)handle, Duration.ofSeconds(1L), "worker/command", new Object[]{true, 3, 1, 10, false});
            task.getResult();
            task = sender.execute((CommandHandle)handle, Duration.ofSeconds(10L), "worker/command", new Object[]{true, 0, 1, -1, true});
            task.getResult();
            task = sender.execute((CommandHandle)handle, Duration.ofSeconds(10L), "worker/command", new Object[]{true, 0, 4, 10, false});
            try {
                commandSenderTest = this;
                synchronized (commandSenderTest) {
                    ((Object)((Object)this)).wait(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            task.cancel();
            task.getResult();
            task = sender.execute((CommandHandle)handle, Duration.ofSeconds(3L), "no/such/agent/command", new Object[]{true, 1, 4, 10, false});
            task.getResult();
            try {
                commandSenderTest = this;
                synchronized (commandSenderTest) {
                    ((Object)((Object)this)).wait(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertEquals((Object)"NAOATATAOTAFACS", (Object)sb.toString());
            sb.delete(0, sb.length());
            task1 = sender.sendRaw((CommandHandle)handle, Duration.ofSeconds(10L), "worker", "command", new Object[]{true, 2, 2, -1, false});
            task = sender.sendEncoded((CommandHandle)handle, Duration.ofSeconds(10L), "worker", "command", new String[]{"false", "0", "2", "-1", "false"});
            task1.getResult();
            task.getResult();
            task = sender.send((CommandHandle)handle, Duration.ofSeconds(3L), "worker", "command", "true 2 3 -1 false");
            task.getResult();
            task = sender.send((CommandHandle)handle, Duration.ofSeconds(-3L), "worker", "command true 1 4 10 false");
            task.getResult();
            task = sender.send((CommandHandle)handle, Duration.ofSeconds(3L), "worker command true 1 4 10 false");
            task.getResult();
            task = sender.send((CommandHandle)handle, Duration.ofSeconds(1L), "worker command true 3 \"1\" 10 false");
            task.getResult();
            task = sender.send((CommandHandle)handle, Duration.ofSeconds(10L), "worker", "command true 0 1 -1  true");
            task.getResult();
            task = sender.send((CommandHandle)handle, Duration.ofSeconds(10L), "worker", "command", "\"true\" 0 4 10 false");
            try {
                commandSenderTest = this;
                synchronized (commandSenderTest) {
                    ((Object)((Object)this)).wait(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            task.cancel();
            task.getResult();
            task = sender.sendRaw((CommandHandle)handle, Duration.ofSeconds(3L), "no", "such/agent/command", new Object[]{true, 1, 4, 10, false});
            task.getResult();
            try {
                commandSenderTest = this;
                synchronized (commandSenderTest) {
                    ((Object)((Object)this)).wait(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertEquals((Object)"NAOATATAOTAFACS", (Object)sb.toString());
            sb.delete(0, sb.length());
        }
        catch (InterruptedException x) {
            Assert.fail((String)"Test interrupted.");
        }
    }

    @Test
    public void testSendRaw() {
        CommandSender sender = new CommandSender(console.getMessagingAccess(), null, null, console.getScheduler());
        CommandTask task = sender.sendRaw((CommandHandle)null, Duration.ofSeconds(10L), "worker", "commandWithOptions", new Object[]{Arrays.asList("A", "B"), "C"});
        try {
            Assert.assertEquals((Object)"A++B=C", (Object)task.getResult().toString());
        }
        catch (Exception x) {
            Assert.fail((String)x.toString());
        }
        Options opts = new Options();
        opts.withOption("space");
        task = sender.sendRaw("worker", "commandWithOptions", new Object[]{opts, Arrays.asList("A", "B"), "C"});
        try {
            Assert.assertEquals((Object)"A+S+B=C", (Object)task.getResult().toString());
        }
        catch (Exception x) {
            Assert.fail((String)x.toString());
        }
    }

    @Test
    public void testSendEncoded() {
        CommandSender sender = new CommandSender(console.getMessagingAccess(), null, null, console.getScheduler());
        CommandTask task = sender.sendEncoded("worker", "commandWithOptions", new String[]{"[A,B]", "C"});
        try {
            Assert.assertEquals((Object)"A++B=C", (Object)task.getResult().toString());
        }
        catch (Exception x) {
            Assert.fail((String)x.toString());
        }
        task = sender.sendEncoded("worker", "commandWithOptions", new String[]{"[A, B]", "-u", "C", "--space"});
        try {
            Assert.assertEquals((Object)"A+US+B=C", (Object)task.getResult().toString());
        }
        catch (Exception x) {
            Assert.fail((String)x.toString());
        }
    }

    @Test
    public void testSend_String() {
        CommandSender sender = new CommandSender(console.getMessagingAccess(), null, null, console.getScheduler());
        CommandTask task = sender.send("worker commandWithOptions [A,B] C");
        try {
            Assert.assertEquals((Object)"A++B=C", (Object)task.getResult().toString());
        }
        catch (Exception x) {
            Assert.fail((String)x.toString());
        }
        task = sender.send("worker", "commandWithOptions \"[A,B]\" C");
        try {
            Assert.assertEquals((Object)"A++B=C", (Object)task.getResult().toString());
        }
        catch (Exception x) {
            Assert.fail((String)x.toString());
        }
        task = sender.send("worker", "commandWithOptions", "\"[A, B]\" C");
        try {
            Assert.assertEquals((Object)"A++B=C", (Object)task.getResult().toString());
        }
        catch (Exception x) {
            Assert.fail((String)x.toString());
        }
        task = sender.send("worker commandWithOptions --uppercase [A,B] C");
        try {
            Assert.assertEquals((Object)"A+U+B=C", (Object)task.getResult().toString());
        }
        catch (Exception x) {
            Assert.fail((String)x.toString());
        }
        task = sender.send("worker", "commandWithOptions", "\"[A, B]\"  --uppercase C --space");
        try {
            Assert.assertEquals((Object)"A+US+B=C", (Object)task.getResult().toString());
        }
        catch (Exception x) {
            Assert.fail((String)x.toString());
        }
        task = sender.send("worker", "commandWithOptions", "[A, B] \"--uppercase\" C --space");
        try {
            Assert.assertEquals((Object)"A+US+B=C", (Object)task.getResult().toString());
        }
        catch (Exception x) {
            Assert.fail((String)x.toString());
        }
    }

    private class Handle
    implements CommandHandle {
        private Handle() {
        }

        public void onSendingFailure(Throwable exception, CommandTask source) {
            sb.append("S");
        }

        public void onAck(CommandAck ack, CommandTask source) {
            sb.append("A");
        }

        public void onNack(CommandNack nack, CommandTask source) {
            sb.append("N");
        }

        public void onSuccess(Object result, CommandTask source) {
            sb.append("O");
        }

        public void onExecutionFailure(Throwable exception, CommandTask source) {
            sb.append("F");
        }

        public void onTimeout(TimeoutException exception, CommandTask source) {
            sb.append("T");
        }

        public void onCancel(CancellationException exception, CommandTask source) {
            sb.append("C");
        }

        public void onResult(CommandCode code, Object result, CommandTask source) {
            sb.append("R");
        }
    }
}

