/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import org.jgroups.View;
import org.lsst.ccs.bus.definition.Bus;

public class JGroupsMonitor {
    private final int MAX_RECORDS = 100;
    private EnumMap<Bus, LinkedList<Record>> records;
    private final ExecutorService exec = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "JGroups monitor");
        t.setDaemon(true);
        return t;
    });

    public void addRecord(Bus bus, String message, Exception exception) {
        try {
            this.exec.execute(() -> this.doAddRecord(bus, message, exception));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void addRecord(Bus bus, View oldView, View view) {
        try {
            this.exec.execute(() -> this.doAddRecord(bus, oldView, view));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private void doAddRecord(Bus bus, String message, Exception exception) {
    }

    private void doAddRecord(Bus bus, View oldView, View view) {
    }

    public void getRecords(Consumer<List<Record>> consumer, Bus bus) {
    }

    public static class Record {
        public final long time = System.currentTimeMillis();
        public final String message;
        public final Exception exception;

        Record(String message, Exception exception) {
            this.message = message;
            this.exception = exception;
        }

        public String toString() {
            if (this.exception == null) {
                return this.message;
            }
            return this.message + "\n" + this.exception;
        }
    }
}

