/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.Collections;
import java.util.Map;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.messaging.DummyLock;
import org.lsst.ccs.services.AbstractAgentLockServiceDelegate;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;

public class LocalAgentLockService
extends AbstractAgentLockServiceDelegate {
    public LocalAgentLockService(AgentLockService svc) {
        super(svc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLevelForAgent(String agentName, int level) throws UnauthorizedLevelException, UnauthorizedLockException {
        Object object = this.listenerUpdatesLock;
        synchronized (object) {
            AgentLock lock = (AgentLock)this.heldLocks.get(agentName);
            if (lock == null) {
                this.lockAgent(agentName);
            }
            this.setLevelInternal(agentName, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockAgent(String agentName) throws UnauthorizedLockException {
        DummyLock lock;
        if ("lockmanager".equals(agentName)) {
            throw new UnauthorizedLockException("cannot lock the lock manager");
        }
        Object object = this.listenerUpdatesLock;
        synchronized (object) {
            if (this.heldLocks.get(agentName) != null) {
                return;
            }
            log.fine((Object)("acquiring lock for " + agentName));
            lock = new DummyLock(agentName, this.svc.getUserId());
            this.addHeldLock((AgentLock)lock);
            this.allLocks.put(lock.getAgentName(), lock);
            log.finest((Object)(lock.getOwner() + " acquired a lock for agent " + agentName));
        }
        this.notifyGlobalLockListeners(lock.getAgentName(), (AgentLock)lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachLock(String agentName) throws UnauthorizedLockException {
        Object object = this.listenerUpdatesLock;
        synchronized (object) {
            if (this.heldLocks.get(agentName) == null) {
                throw new UnauthorizedLockException("no held lock on " + agentName);
            }
        }
    }

    @Override
    public void detachLock(String agentName) throws UnauthorizedLockException {
        this.unlockAgent(agentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockAgent(String agentName) {
        Object object = this.listenerUpdatesLock;
        synchronized (object) {
            try {
                this.setLevelInternal(agentName, 0);
                this.removeHeldLock(agentName, null);
                this.allLocks.remove(agentName);
            }
            catch (UnauthorizedLevelException | UnauthorizedLockException ex) {
                log.warning((Object)"Something went really wrong as we should not get these exceptions when unlocking.", (Throwable)ex);
            }
            String owner = "".equals(this.svc.getUserId()) ? this.getAgent().getName() : this.svc.getUserId();
            log.finest((Object)(owner + " released a lock for agent " + agentName));
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo a : agents) {
            log.fine((Object)("disconnect " + a.getName()));
            try {
                this.removeHeldLock(a.getName(), null);
            }
            catch (UnauthorizedLockException e) {
                e.printStackTrace();
            }
            this.allLocks.remove(a.getName());
        }
    }

    @Override
    public Map<String, AgentLock> getLocks() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public void preStart() {
    }

    @Override
    public void preInit() {
        super.preInit();
        this.getAgent().getAgentInfo().getAgentProperties().setProperty("lockable", "false");
    }

    @Override
    public boolean validateLock(AgentLock lock) {
        return true;
    }

    @Override
    public void destroyLock(String agentName, String userId) {
    }
}

