/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.print.table;

import javax.swing.table.TableModel;
import org.freehep.swing.print.table.CellPrinter;
import org.freehep.swing.print.table.DefaultCellPrinter;
import org.freehep.swing.print.table.NumberCellPrinter;
import org.freehep.swing.print.table.PrintableTableModel;

public class PrintModelAdapter
implements PrintableTableModel {
    private TableModel model;
    private String title;
    private CellPrinter headerPrinter = new DefaultCellPrinter(1);
    private CellPrinter textPrinter = new DefaultCellPrinter(0);
    private CellPrinter numberPrinter = new NumberCellPrinter();

    public PrintModelAdapter(TableModel model, String title) {
        this.model = model;
        this.title = title;
    }

    @Override
    public CellPrinter getCellPrinter(int column) {
        return Number.class.isAssignableFrom(this.model.getColumnClass(column)) ? this.numberPrinter : this.textPrinter;
    }

    @Override
    public CellPrinter getHeaderPrinter(int column) {
        return this.headerPrinter;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Object headerForColumn(int i) {
        return this.model.getColumnName(i);
    }

    @Override
    public boolean hideColumn(int i) {
        return false;
    }

    @Override
    public int numberOfColumns() {
        return this.model.getColumnCount();
    }

    @Override
    public int numberOfRows() {
        return this.model.getRowCount();
    }

    @Override
    public Object valueAt(int i, int j) {
        return this.model.getValueAt(i, j);
    }
}

