/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.DataDictionary;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AgentHandleWrapper;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusListener;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class AgentChannelsTest
extends CcsTestCaseTemplate {
    private Subsystem demoWithMonitoring = null;
    private Agent console = null;

    @Before
    public void setUpTest() throws Exception {
        this.demoWithMonitoring = BootUtils.getSubsystemFromFile((String)"DemoSubsystemWithMonitoring");
        this.demoWithMonitoring.startAgent();
        this.console = new Agent("c", AgentInfo.AgentType.CONSOLE);
        this.console.startAgent();
    }

    @After
    public void tearDownTest() throws Exception {
        if (this.demoWithMonitoring != null) {
            this.demoWithMonitoring.shutdownAgent();
        }
        if (this.console != null) {
            this.console.shutdownAgent();
        }
    }

    @Test
    public void testAgentDictionary() throws Exception {
        AgentHandleWrapper agentHandle = new AgentHandleWrapper(this.demoWithMonitoring.getAgentInfo());
        agentHandle.aggregator.getAgents();
        DataProviderDictionary dictionary = ((DataProviderDictionaryService)this.demoWithMonitoring.getAgentService(DataProviderDictionaryService.class)).getDataProviderDictionary();
        agentHandle.onDictionary(dictionary);
        LinkedHashMap allChannels = agentHandle.channels;
        List<AgentChannel> trendingChannels = AgentChannelsTest.getAgentChannelListByType(agentHandle, DataProviderInfo.Type.TRENDING);
        List<AgentChannel> monitoringChannels = AgentChannelsTest.getAgentChannelListByType(agentHandle, DataProviderInfo.Type.MONITORING);
        List<AgentChannel> stateChannels = AgentChannelsTest.getAgentChannelListByType(agentHandle, DataProviderInfo.Type.STATE);
        List<AgentChannel> configurationChannels = AgentChannelsTest.getAgentChannelListByType(agentHandle, DataProviderInfo.Type.CONFIGURATION);
        List<DataProviderInfo> trendingData = AgentChannelsTest.getDataListByType(dictionary, DataProviderInfo.Type.TRENDING);
        List<DataProviderInfo> monitoringData = AgentChannelsTest.getDataListByType(dictionary, DataProviderInfo.Type.MONITORING);
        List<DataProviderInfo> stateData = AgentChannelsTest.getDataListByType(dictionary, DataProviderInfo.Type.STATE);
        List<DataProviderInfo> configurationData = AgentChannelsTest.getDataListByType(dictionary, DataProviderInfo.Type.CONFIGURATION);
        Assert.assertEquals((long)dictionary.getDataProviderInfos().size(), (long)(trendingData.size() + monitoringData.size() + stateData.size() + configurationData.size()));
        Assert.assertEquals((long)(dictionary.getDataProviderInfos().size() + 1), (long)allChannels.size());
        ConfigurationInfo configInfo = ((ConfigurationService)this.demoWithMonitoring.getAgentService(ConfigurationService.class)).getConfigurationInfo();
        int nConfigs = configInfo.getAllParameterInfo().size();
        Assert.assertEquals((long)nConfigs, (long)configurationChannels.size());
        Assert.assertEquals((long)nConfigs, (long)configurationData.size());
        StatusConfigurationInfo statusConfig = new StatusConfigurationInfo(configInfo);
        agentHandle.readConfiguration(statusConfig);
        StateBundle stateBundle = ((AgentStateService)this.demoWithMonitoring.getAgentService(AgentStateService.class)).getState();
        int nStates = stateBundle.getAllStatesAsStrings().size();
        Assert.assertEquals((long)nStates, (long)stateChannels.size());
        Assert.assertEquals((long)nStates, (long)stateData.size());
        StatusStateChangeNotification stateMsg = new StatusStateChangeNotification(CCSTimeStamp.currentTime(), stateBundle);
        stateMsg.setState(stateBundle);
        agentHandle.readState(stateMsg);
        int nTrendMonData = trendingData.size() + monitoringData.size();
        Assert.assertEquals((long)nTrendMonData, (long)trendingChannels.size());
        Assert.assertEquals((long)nTrendMonData, (long)monitoringChannels.size());
        WrapperStatusMessageListener listener = new WrapperStatusMessageListener(agentHandle);
        this.console.getMessagingAccess().addStatusMessageListener((StatusMessageListener)listener);
        ((ConfigurationService)this.demoWithMonitoring.getAgentService(ConfigurationService.class)).publishConfigurationInfo();
        while (listener.getMessageCount() < 5) {
            Thread.sleep(100L);
        }
        this.console.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)listener);
        int numberOfMissedData = agentHandle.orphanedData.size();
        Assert.assertEquals((String)"Expecting zero ", (long)0L, (long)numberOfMissedData);
        KeyValueDataList dataList = new KeyValueDataList("nonExpectedData");
        dataList.addData("anInt", (Serializable)Integer.valueOf(1));
        dataList.addData("aDoub", (Serializable)Double.valueOf(1.1));
        StatusSubsystemData dataMsg = new StatusSubsystemData((KeyValueData)dataList);
        agentHandle.readTrendingData((StatusMessage)dataMsg);
        Assert.assertEquals((String)"Expecting two more missed data", (long)(2 + numberOfMissedData), (long)agentHandle.orphanedData.size());
    }

    private static List<DataProviderInfo> getDataListByType(DataProviderDictionary dict, DataProviderInfo.Type type) {
        ArrayList<DataProviderInfo> result = new ArrayList<DataProviderInfo>();
        for (DataProviderInfo info : dict.getDataProviderInfos()) {
            if (DataProviderInfo.Type.valueOf((String)info.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE)) != type) continue;
            result.add(info);
        }
        return result;
    }

    private static List<AgentChannel> getAgentChannelListByType(AgentHandleWrapper handle, DataProviderInfo.Type type) {
        ArrayList<AgentChannel> result = new ArrayList<AgentChannel>();
        String prefix = handle.getAgentChannelPrevixByType(type);
        block3: for (AgentChannel channel : handle.channels.values()) {
            String path = channel.getPath();
            if (path.startsWith(handle.TIME_PATH)) continue;
            switch (type) {
                case TRENDING: 
                case MONITORING: {
                    String configPrefix = handle.getAgentChannelPrevixByType(DataProviderInfo.Type.CONFIGURATION);
                    String statePrefix = handle.getAgentChannelPrevixByType(DataProviderInfo.Type.STATE);
                    if (!path.startsWith(configPrefix) && !path.startsWith(statePrefix)) break;
                    continue block3;
                }
            }
            if (!path.startsWith(prefix)) continue;
            result.add(channel);
        }
        return result;
    }

    @Test
    public void testDataDictionary() throws Exception {
        DataProviderDictionary dictionary = ((DataProviderDictionaryService)this.demoWithMonitoring.getAgentService(DataProviderDictionaryService.class)).getDataProviderDictionary();
        DataDictionary dict = new DataDictionary(dictionary);
        TreeMap expResult = new TreeMap();
        dictionary.getDataProviderInfos().forEach(d -> expResult.put(d.getFullPath(), d));
        TreeMap result = new TreeMap();
        dict.getDataProviderInfos().forEach(d -> result.put(d.getFullPath(), d));
        Assert.assertEquals((long)expResult.size(), (long)result.size());
        Assert.assertEquals(expResult, result);
    }

    private class AgentHandleListener
    implements AgentStatusListener {
        private AgentHandleListener() {
        }

        public void statusChanged(AgentStatusEvent event) {
            System.out.println("Status Changed event " + event);
        }
    }

    private class WrapperStatusMessageListener
    implements StatusMessageListener {
        private final AgentHandleWrapper handle;
        private volatile int msgCount = 0;

        public WrapperStatusMessageListener(AgentHandleWrapper handle) {
            this.handle = handle;
        }

        public void onStatusMessage(StatusMessage msg) {
            if (!msg.getOriginAgentInfo().getName().equals(this.handle.getAgent().getName())) {
                return;
            }
            if (msg instanceof StatusHeartBeat) {
                return;
            }
            ++this.msgCount;
            this.handle.readTrendingData(msg);
            if (msg instanceof StatusStateChangeNotification) {
                this.handle.readState((StatusStateChangeNotification)msg);
            }
            if (msg instanceof StatusConfigurationInfo) {
                this.handle.readConfiguration((StatusConfigurationInfo)msg);
            }
        }

        public int getMessageCount() {
            return this.msgCount;
        }
    }
}

