package org.lsst.ccs.gconsole.base.filter;

import java.util.*;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;

/**
 * {@code AbstractChannelsFilter} that selects channels from the specified subsystem.
 * Strips the subsystem name, but leaves the channel path otherwise unchanged.
 *
 * @author onoprien
 */
public class SubsystemSelectorFilter extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    static public final String CREATOR_PATH = "Built-In/Basic/Subsystem Selector";
    
    private final String agent;
    private final String prefix;
    private final int index;

// -- Life cycle : -------------------------------------------------------------
    
    @Create(category = AgentChannelsFilter.CATEGORY,
            name = "Subsystem Selector",
            path = CREATOR_PATH,
            description = "Selects channels from the specified subsystem only. Strips the subsystem name, but leaves the channel path otherwise unchanged.")
    public SubsystemSelectorFilter(
            @Par(desc = "Subsystem name.") String subsystem)
    {
        agent = subsystem;
        prefix = agent +"/";
        index = prefix.length();
    }


// -- Implement AgentChannelsFilter : ------------------------------------------

    @Override
    public List<String> getAgents() {
        return Collections.singletonList(agent);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return prefix + displayPath;
    }

    @Override
    public String getDisplayPath(String originPath) {
        return originPath.startsWith(prefix) ? originPath.substring(index) : null;
    }

    @Override
    public String getName() {
        return agent;
    }
     
}
