package org.lsst.ccs.gconsole.base.filter;

import java.util.*;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

/**
 * Demo filter that selects key data from subsystems for displaying in a {@code GroupView}.
 *
 * @author onoprien
 */
public class KeyDataAllSubsystemsFilter extends AbstractChannelsFilter {
    
    static public final String CREATOR_PATH = "Built-In/Whole Camera/Subsystems";

// -- Life cycle : -------------------------------------------------------------
    
    @Create(category = "AgentChannelsFilter",
            name = "Subsystems",
            path = CREATOR_PATH,
            description = "Key data for all subsystems.")
    public KeyDataAllSubsystemsFilter() {
    }
    
// -- Implementing filter : ----------------------------------------------------
    
    @Override
    public List<String> getDisplayPaths(AgentChannel channel) {
        String path = channel.getLocalPath();
        ArrayList<String> out = new ArrayList<>(2);
        if (path.startsWith("configuration/") || path.startsWith("state/")) {
            out.add(channel.getAgentName() + "/" + path.replaceFirst("/", "//"));
        } else {
            out.add(channel.getAgentName() + "/data//" + path);
        }
        if (channel.getAgentName().startsWith("d")) {
            out.add("image handlers/" + out.get(0));
        }
        return out;
    }

    @Override
    public String getName() {
        return "Subsystems";
    }

    @Override
    public List<String> getFields(boolean compact) {
       return Collections.singletonList("VALUE");
    }

}

