/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty;

import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.WeakHashMap;

public class Style
implements Cloneable {
    static int count = 1;
    static final ChosenColor FOREGROUND = new ChosenColor(Color.BLACK);
    static final ChosenColor BACKGROUND = new ChosenColor(Color.WHITE);
    public static final Style EMPTY = new Style();
    private static final WeakHashMap<Style, WeakReference<Style>> styles = new WeakHashMap();
    private Color foreground;
    private Color background;
    private EnumSet<Option> options;
    private int number = count++;

    public static Style getCanonicalStyle(Style currentStyle) {
        Style canonStyle;
        WeakReference<Style> canonRef = styles.get(currentStyle);
        if (canonRef != null && (canonStyle = (Style)canonRef.get()) != null) {
            return canonStyle;
        }
        styles.put(currentStyle, new WeakReference<Style>(currentStyle));
        return currentStyle;
    }

    Style() {
        this.foreground = FOREGROUND;
        this.background = BACKGROUND;
        this.options = EnumSet.noneOf(Option.class);
    }

    Style(Color foreground, Color background, EnumSet<Option> options) {
        this.foreground = foreground;
        this.background = background;
        this.options = options.clone();
    }

    void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getForeground() {
        return this.foreground;
    }

    void setBackground(Color background) {
        this.background = background;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setOption(Option opt, boolean val) {
        if (val) {
            this.options.add(opt);
        } else {
            this.options.remove((Object)opt);
        }
    }

    public Style clone() {
        return new Style(this.getForeground(), this.getBackground(), this.options);
    }

    public int getNumber() {
        return this.number;
    }

    public boolean hasOption(Option bold) {
        return this.options.contains((Object)bold);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.background == null ? 0 : this.background.hashCode());
        result = 31 * result + (this.foreground == null ? 0 : this.foreground.hashCode());
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Style other = (Style)obj;
        if (this.background == null ? other.background != null : !this.background.equals(other.background)) {
            return false;
        }
        if (this.foreground == null ? other.foreground != null : !this.foreground.equals(other.foreground)) {
            return false;
        }
        return !(this.options == null ? other.options != null : !this.options.equals(other.options));
    }

    public Color getBackgroundForRun() {
        return this.options.contains((Object)Option.REVERSE) ? this.foreground : this.background;
    }

    public Color getForegroundForRun() {
        return this.options.contains((Object)Option.REVERSE) ? this.background : this.foreground;
    }

    public void clearOptions() {
        this.options.clear();
    }

    public static enum Option {
        BOLD,
        BLINK,
        DIM,
        REVERSE,
        UNDERSCORE,
        HIDDEN;

    }

    static class ChosenColor
    extends Color {
        private static final long serialVersionUID = 7492667732033832704L;

        public ChosenColor(Color def) {
            super(def.getRGB());
        }
    }
}

