/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.gconsole.plugins.trending.RestSource;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.server.TrendingResult;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class RestSourceTest
extends CcsTestCaseTemplate {
    @Test
    public void testGet_5args_2() {
        System.out.println("starting test");
        long[] times = new long[]{10L, 11L, 12L, 13L, 14L, 16L, 17L, 18L, 19L, 20L};
        HashMap<String, double[]> values = new HashMap<String, double[]>();
        values.put("value", new double[]{10.0, 11.0, 12.0, 13.0, 14.0, 16.0, 17.0, 18.0, 19.0, 20.0});
        values.put("onpoint", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 6.0, 7.0, 8.0, 9.0, 10.0});
        HashMap meta = new HashMap();
        ArrayList<TrendData.MetaValue> offD = new ArrayList<TrendData.MetaValue>();
        offD.add(new TrendData.MetaValue(10L, 13L, "1"));
        offD.add(new TrendData.MetaValue(13L, 15L, "2"));
        offD.add(new TrendData.MetaValue(15L, 20L, "3"));
        meta.put("offD", offD);
        ArrayList<TrendData.MetaValue> offS1 = new ArrayList<TrendData.MetaValue>();
        offS1.add(new TrendData.MetaValue(10L, 20L, "S1"));
        meta.put("offS1", offS1);
        TrendData td = new TrendData(times, values, meta, new long[]{10L, 20L}, true);
        TrendData tdNew = RestSource.cut((TrendData)td, (long)12L, (long)15L);
        Assert.assertArrayEquals((String)"cut times", (long[])new long[]{12L, 13L, 14L}, (long[])tdNew.getTimes());
        Assert.assertArrayEquals((String)"cut times key", (long[])new long[]{12L, 13L, 14L}, (long[])tdNew.getTimes("value"));
        Assert.assertArrayEquals((String)"cut values", (double[])new double[]{12.0, 13.0, 14.0}, (double[])tdNew.getValues(), (double)0.01);
        Assert.assertArrayEquals((String)"cut onpoint", (double[])new double[]{2.0, 3.0, 4.0}, (double[])tdNew.getValues("onpoint"), (double)0.01);
        Assert.assertArrayEquals((String)"cut offD times", (long[])new long[]{12L, 13L, 13L, 15L}, (long[])tdNew.getTimes("offD"));
        Assert.assertArrayEquals((String)"cut offD strings", (Object[])new String[]{"1", "1", "2", "2"}, (Object[])tdNew.getMetadata("offD"));
        Assert.assertArrayEquals((String)"cut offD double", (double[])new double[]{1.0, 1.0, 2.0, 2.0}, (double[])tdNew.getValues("offD"), (double)0.01);
        Assert.assertArrayEquals((String)"cut offS1 times", (long[])new long[]{12L, 15L}, (long[])tdNew.getTimes("offS1"));
        Assert.assertArrayEquals((String)"cut offS1 strings", (Object[])new String[]{"S1", "S1"}, (Object[])tdNew.getMetadata("offS1"));
        TrendingData[] data = new TrendingData[4];
        TrendingData d = new TrendingData();
        TrendingData.AxisValue t = new TrendingData.AxisValue("", 21L);
        d.setAxisValue(t);
        TrendingData.DataValue v = new TrendingData.DataValue("value", 21.0);
        TrendingData.DataValue v1 = new TrendingData.DataValue("onpoint", 11.0);
        d.setDataValue(new TrendingData.DataValue[]{v, v1});
        data[0] = d;
        d = new TrendingData();
        t = new TrendingData.AxisValue("", 22L);
        d.setAxisValue(t);
        v = new TrendingData.DataValue("value", 22.0);
        v1 = new TrendingData.DataValue("onpoint", 12.0);
        d.setDataValue(new TrendingData.DataValue[]{v, v1});
        data[1] = d;
        d = new TrendingData();
        t = new TrendingData.AxisValue("", 23L);
        d.setAxisValue(t);
        v = new TrendingData.DataValue("value", 23.0);
        v1 = new TrendingData.DataValue("onpoint", 13.0);
        d.setDataValue(new TrendingData.DataValue[]{v, v1});
        data[2] = d;
        d = new TrendingData();
        t = new TrendingData.AxisValue("", 24L);
        d.setAxisValue(t);
        v = new TrendingData.DataValue("value", 24.0);
        v1 = new TrendingData.DataValue("onpoint", 14.0);
        d.setDataValue(new TrendingData.DataValue[]{v, v1});
        data[3] = d;
        ArrayList<ChannelMetaData> metaList = new ArrayList<ChannelMetaData>();
        metaList.add(new ChannelMetaData("offD", "4", -1L, 22L));
        metaList.add(new ChannelMetaData("offD", "4", 23L, -1L));
        metaList.add(new ChannelMetaData("offS1", "S1", 21L, 30L));
        metaList.add(new ChannelMetaData("offS2", "S2", 15L, 22L));
        TrendingResult tr = new TrendingResult();
        tr.setTrendingDataArray(data);
        tr.setChannelMetadata(metaList);
        tdNew = RestSource.merge((TrendData)td, (TrendingResult)tr, (long)17L, (long)24L, (boolean)true);
        Assert.assertArrayEquals((String)"merge times", (long[])new long[]{17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L}, (long[])tdNew.getTimes());
        Assert.assertArrayEquals((String)"merge times key", (long[])new long[]{17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L}, (long[])tdNew.getTimes("value"));
        Assert.assertArrayEquals((String)"merge values", (double[])new double[]{17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0}, (double[])tdNew.getValues(), (double)0.01);
        Assert.assertArrayEquals((String)"merge onpoint", (double[])new double[]{7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0}, (double[])tdNew.getValues("onpoint"), (double)0.01);
        Assert.assertArrayEquals((String)"merge offD times", (long[])new long[]{17L, 20L, 20L, 24L}, (long[])tdNew.getTimes("offD"));
        Assert.assertArrayEquals((String)"merge offD strings", (Object[])new String[]{"3", "3", "4", "4"}, (Object[])tdNew.getMetadata("offD"));
        Assert.assertArrayEquals((String)"merge offD double", (double[])new double[]{3.0, 3.0, 4.0, 4.0}, (double[])tdNew.getValues("offD"), (double)0.01);
        Assert.assertArrayEquals((String)"merge offS1 times", (long[])new long[]{17L, 24L}, (long[])tdNew.getTimes("offS1"));
        Assert.assertArrayEquals((String)"merge offS1 strings", (Object[])new String[]{"S1", "S1"}, (Object[])tdNew.getMetadata("offS1"));
        Assert.assertArrayEquals((String)"merge offS2 times", (long[])new long[]{17L, 22L}, (long[])tdNew.getTimes("offS2"));
        Assert.assertArrayEquals((String)"merge offS2 strings", (Object[])new String[]{"S2", "S2"}, (Object[])tdNew.getMetadata("offS2"));
    }
}

