package org.lsst.ccs.gconsole.base.filter;

import java.util.ArrayList;
import java.util.*;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;

/**
 * Filter that selects subsystem state channels.
 *
 * @author onoprien
 */
public class States extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    static public final String CREATOR_PATH = "Built-In/Special/States";
    
    private final String name;
    private final List<String> agents;

// -- Life cycle : -------------------------------------------------------------
    
    @Create(category = AgentChannelsFilter.CATEGORY,
            name = "States",
            path = CREATOR_PATH,
            description = "Channels filter that selects subsystem state channels.")
    public States(
            @Par(def = "States", desc = "Filter name.") String name,
            @Par(def = Par.NULL, desc = "List of subsystems accepted by this filter. If null, all subsystems are accepted.") List<String> agents)
    {
        this.name = name;
        this.agents = agents == null ? null : new ArrayList<>(agents);
    }
    
// -- Implementing filter : ----------------------------------------------------

    @Override
    public List<String> getDisplayPaths(String originPath) {
        String displayPath = originPath.replaceFirst("/state/", "/");
        return Collections.singletonList(displayPath);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return displayPath.replaceFirst("/", "/state/");
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList("/state/");
    }

    @Override
    public List<String> getAgents() {
        return agents == null ? null : Collections.unmodifiableList(agents);
    }

    @Override
    public String getName() {
        return name;
    }

}

