package org.lsst.ccs.gconsole.util.swing;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

/**
 * {@link JSpinner} that limits its maximum height to its preferred height.
 * Intended for use with {@link BoxLayout}.
 *
 * @author onoprien
 */
public class BoxedSpinner extends JSpinner {

// -- Life cycle : -------------------------------------------------------------

    /**
     * Constructs a spinner for the given model. The spinner has a set of
     * previous/next buttons, and an editor appropriate for the model.
     *
     * @param model Model to be used by this spinner.
     * @throws NullPointerException if the model is {@code null}
     */
    public BoxedSpinner(SpinnerModel model) {
        super(model);
    }

    /**
     * Constructs a spinner with an Integer {@code SpinnerNumberModel}
     * with initial value 0 and no minimum or maximum limits.
     */
    public BoxedSpinner() {
        super();
    }

// -- Limit max size : ---------------------------------------------------------

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }
    
}
