package org.lsst.ccs.gconsole.base.filter;

import org.lsst.ccs.gconsole.services.persist.Persistable;

/**
 * {@code AgentChannelsFilter} that can be saved and restored through the persistence service.
 *
 * @author onoprien
 */
public interface PersistableAgentChannelsFilter extends AgentChannelsFilter, Persistable {

    
    /**
     * Returns the name of this filter.
     * The default implementation forwards the call to Persistable's descriptor.
     * 
     * @return 
     */
    @Override
    public default String getName() {
        return getDescriptor().getName();
    }
    
}
