package org.lsst.ccs.gconsole.base.filter;

import java.util.*;
import java.util.stream.Collectors;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

/**
 * Filter to be associated with a view that handles a single page of a multi-page parent view.
 *
 * // FIXME: Only used by deprecated TabbedView. Will be removed in future releases. 
 * @author onoprien
 */
public class PageFilter extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    private final AgentChannelsFilter filter;
    private final String prefix;

// -- Life cycle : -------------------------------------------------------------
    
    public PageFilter(AgentChannelsFilter filter, String page) {
        this.filter = filter;
        prefix = page == null || page.isEmpty() ? "" : page +"//";
    }

    
// -- Forward methods : --------------------------------------------------------

    @Override
    public String getName() {
        String name = filter.getName();
        if (name != null) {
            name += ":";
            if (!prefix.isEmpty()) {
                name += prefix.substring(0, prefix.length()-2);
            }
        }
        return name;
    }

    @Override
    public List<String> getAgents() {
        return filter.getAgents();
    }

    @Override
    public List<String> getOriginChannels() {
        return filter.getOriginChannels();
    }

    @Override
    public List<String> getDisplayChannels() {
        List<String> cc = filter.getDisplayChannels();
        if (cc == null) return null;
        return filterPage(cc);
        
    }

    @Override
    public String getOriginPath(String displayPath) {
        return filter.getOriginPath(prefix + displayPath);
    }

    @Override
    public List<String> getDisplayPaths(AgentChannel channel) {
        return filterPage(filter.getDisplayPaths(channel));
    }

    @Override
    public List<String> getDisplayPaths(String originPath) {
        return filterPage(filter.getDisplayPaths(originPath));
    }

    @Override
    public List<String> getFields(boolean compact) {
        return filter.getFields(compact);
    }
    
    
// -- Local methods : ----------------------------------------------------------
    
    List<String> filterPage(List<String> in) {
        if (prefix.isEmpty()) {
            return in.stream().filter(dp -> !dp.contains("//")).collect(Collectors.toList());
        } else {
            int i = prefix.length();
            return in.stream().filter(dp -> dp.startsWith(prefix)).map(dp -> dp.substring(i)).collect(Collectors.toList());
        }        
    }
    
    
    
    
}
