package org.lsst.ccs.gconsole.util.diagnostics;

import java.util.HashMap;

/**
 * 
 *
 * @author onoprien
 */
public class Profiler {
    
    static private final HashMap<String,Profiler> instances = new HashMap<>(2);
    static public final Profiler timer = new Profiler();
    
    private long time = System.currentTimeMillis();
    private final StringBuilder sb;
    
    public Profiler() {
        sb = new StringBuilder("\nDefault Timer:\n");
    }
    
    public Profiler(String name) {
        sb = new StringBuilder("\nTimer ").append(name).append(":\n");
    }
    
    public void mark() {
        mark("");
    }
    
    public void mark(String message) {
        long current = System.currentTimeMillis();
        sb.append(current-time).append(" : ").append(message).append("\n");
        time = current;
    }
    
    public void print() {
        System.out.println(sb.toString());
    }
    
    static public Profiler getInstance() {
        return timer;
    }
    
    static public Profiler getInstance(String name) {
        Profiler out = instances.get(name);
        if (out == null) {
            out = new Profiler(name);
            instances.put(name, out);
        }
        return out;
    }

}
