
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Problem {
    
    static final Object lock = new Object();
    static CountDownLatch latch;
    static int n;
    static int result[];
    static int firstNumber;
    static volatile boolean done;
    
    static final int[] test = {33,23,10,13,7,6,1,29,27,2,25,21,4,17,15,19,11,8,3,5,31,9,22,14,30,26,34,18,16,20,12,28,32,24};
    
    static public void main(String... args) {
        int N_THREADS = 7;
        ExecutorService exec = Executors.newFixedThreadPool(N_THREADS);
        n = 50;
        long time = System.currentTimeMillis();
        while (n <= 51) {
            result = null;
            firstNumber = 1;
            latch = new CountDownLatch(N_THREADS);
            done = false;
            for (int iThread=0; iThread<N_THREADS; iThread++) {
                exec.submit(() -> runSolver());
            }
            try {
                latch.await();
            } catch (InterruptedException x) {
            }
            long seconds = (System.currentTimeMillis() - time)/1000L;
            StringBuilder sb = new StringBuilder();
            if (seconds < 60) {
                sb.append(seconds).append(" seconds, ");
            } else {
                long minutes = seconds / 60;
                sb.append(minutes).append(" minutes, ");
            }
            if (result != null) {
                sb.append("Success for ").append(n).append(" : ");
                for (int k = 0; k < n; k++) {
                    sb.append(result[k]).append(",");
                }
            } else {
                sb.append("Failed: ").append(n);
            }
            System.out.println(sb.toString());
            time = System.currentTimeMillis();
            n++;
        }
        exec.shutdown();
        System.out.println("Done");
    }
    
    static void runSolver() {
        try {
            while (true) {
                int start;
                synchronized (lock) {
                    start = firstNumber++;
                    if (done || start > n) {
                        return;
                    }
                }
                int[] r = solve(start);
                if (r != null) {
                    synchronized (lock) {
                        result = r;
                        done = true;
                    }
                    return;
                }
            }
        } finally {
//            System.out.println("Thread done.");
            latch.countDown();
        }
    }
    
    static int[] solve(int start) {
//        long time = System.currentTimeMillis();
        boolean[] used = new boolean[n + 1];
        int[] solution = new int[n];
        int[] first = new int[n + 1];
        first[0] = start;
        int i = 0;
        int nOdd = (n+1)/2;

        while (i < n) {
            int a = i > 1 ? solution[i - 2] : 1;
            int candidate = solution[i];
            boolean even = i>0 && (solution[i-1] & 1) == 0;
            candidate = candidate == 0 ? first[i] : candidate + a;
            while (true) {
                if (candidate > n) {
                    used[solution[i]] = false;
                    if ((solution[i] & 1) != 0) nOdd++;
                    solution[i] = 0;
                    i--;
                    if (done) return null;
                    break;
                } else if (used[candidate] || (even && nOdd > 0 && ((candidate & 1) == 0))) {
                    candidate += a;
                } else {
                    used[solution[i]] = false;
                    solution[i] = candidate;
                    used[candidate] = true;
                    if ((candidate & 1) != 0) nOdd--;
                    if (i == 0) {
                        first[i + 1] = 1;
                    } else {
                        int prev = solution[i - 1];
                        first[i + 1] = prev - candidate % prev;
                    }
                    i++;
                    break;
                }
            }
            if (i < 1) break;
        }
//        System.out.println("Done for "+ start +" in "+ ((System.currentTimeMillis() - time)/1000) +" seconds");
        return (i == n) ? solution : null;
    }
    
//    static public void main1(String... args) {
//        int n = 59;
//        long time = System.currentTimeMillis();
//        while (n++ > 0) {
//            boolean[] used = new boolean[n+1];
//            used[12] = true;
//            used[24] = true;
//            used[36] = true;
//            used[48] = true;
//            used[60] = true;
//            int[] solution = new int[n];
//            int[] first = new int[n+1];
//            first[0] = 1;
//            int i = 0;
//            
//            while (i > -1 && i < n) {
//                int a = i > 1 ? solution[i-2] : 1;
//                int candidate = solution[i];
//                candidate = candidate == 0 ? first[i] : candidate + a;
//                while (true) {
//                    if (candidate > n) {
//                        used[solution[i]] = false;
//                        solution[i] = 0;
//                        if (i == n-5) {
//                            used[12] = true;
//                            used[24] = true;
//                            used[36] = true;
//                            used[48] = true;
//                            used[60] = true;
//                        }
//                        i--;
//                        break;
//                    } else if (used[candidate]) {
//                        candidate += a;
//                    } else {
//                        used[solution[i]] = false;
//                        solution[i] = candidate;
//                        used[candidate] = true;
//                        if (i == 0) {
//                            first[i+1] = 1;
//                        } else {
//                            int prev = solution[i-1];
//                            first[i+1] =  prev - candidate % prev;
//                        }
//                        i++;
//                        if (i == n-5) {
//                            used[12] = false;
//                            used[24] = false;
//                            used[36] = false;
//                            used[48] = false;
//                            used[60] = false;
//                        }
//                        break;
//                    }
//                }
//            }
//            
//            long seconds = (System.currentTimeMillis() - time)/1000L;
//            StringBuilder sb = new StringBuilder();
//            if (seconds < 60) {
//                sb.append(seconds).append(" seconds, ");
//            } else {
//                long minutes = seconds / 60;
//                sb.append(minutes).append(" minutes, ");
//            }
//            if (i == n) {
//                sb.append("Success for ").append(n).append(" : ");
//                for (int k = 0; k < n; k++) {
//                    sb.append(solution[k]).append(",");
//                }
//            } else {
//                sb.append("Failed: ").append(n);
//            }
//            System.out.println(sb.toString());
//            time = System.currentTimeMillis();
//        }
//    }
    
//    static public void main0(String... args) {
//        int n = 3;
//        long time = System.currentTimeMillis();
//        while (n++ > 0) {
//            boolean[] used = new boolean[n+1];
//            int[] solution = new int[n];
//            int[] first = new int[n+1];
//            first[0] = 1;
//            int i = 0;
//            
//            while (i > -1 && i < n) {
//                int a = i > 1 ? solution[i-2] : 1;
//                int candidate = solution[i];
//                candidate = candidate == 0 ? first[i] : candidate + a;
//                while (true) {
//                    if (candidate > n) {
//                        used[solution[i]] = false;
//                        solution[i] = 0;
//                        i--;
//                        break;
//                    } else if (used[candidate]) {
//                        candidate += a;
//                    } else {
//                        used[solution[i]] = false;
//                        solution[i] = candidate;
//                        used[candidate] = true;
//                        if (i == 0) {
//                            first[i+1] = 1;
//                        } else {
//                            int prev = solution[i-1];
//                            first[i+1] =  prev - candidate % prev;
//                        }
//                        i++;
//                        break;
//                    }
//                }
//            }
//            
//            long seconds = (System.currentTimeMillis() - time)/1000L;
//            StringBuilder sb = new StringBuilder();
//            if (seconds < 60) {
//                sb.append(seconds).append(" seconds, ");
//            } else {
//                long minutes = seconds / 60;
//                sb.append(minutes).append(" minutes, ");
//            }
//            if (i == n) {
//                sb.append("Success for ").append(n).append(" : ");
//                for (int k = 0; k < n; k++) {
//                    sb.append(solution[k]).append(",");
//                }
//            } else {
//                sb.append("Failed: ").append(n);
//            }
//            System.out.println(sb.toString());
//            time = System.currentTimeMillis();
//        }
//    }
    
}

/*
0 seconds, Success for 4 : 1,3,2,4,
0 seconds, Success for 5 : 1,2,3,5,4,
0 seconds, Success for 6 : 1,2,3,5,4,6,
0 seconds, Success for 7 : 1,5,7,3,4,2,6,
0 seconds, Success for 8 : 1,3,4,5,7,8,6,2,
0 seconds, Success for 9 : 1,3,8,7,9,5,4,6,2,
0 seconds, Success for 10 : 1,3,2,7,9,5,4,6,10,8,
0 seconds, Success for 11 : 1,2,11,3,8,7,9,5,4,6,10,
0 seconds, Success for 12 : 1,11,3,8,7,9,5,4,6,2,10,12,
0 seconds, Success for 13 : 1,3,11,13,9,4,5,7,8,6,2,10,12,
0 seconds, Success for 14 : 1,2,11,3,8,7,9,5,13,12,14,10,4,6,
0 seconds, Success for 15 : 3,14,13,15,11,4,7,5,9,1,8,6,2,10,12,
0 seconds, Success for 16 : 1,9,4,5,3,2,13,11,15,7,8,6,10,14,16,12,
0 seconds, Success for 17 : 1,5,2,3,11,7,15,13,17,9,8,10,6,14,16,12,4,
0 seconds, Success for 18 : 1,6,5,7,3,11,16,17,15,2,13,9,4,14,18,10,8,12,
0 seconds, Success for 19 : 1,8,15,17,13,4,9,7,2,19,3,16,11,5,6,14,10,18,12,
0 seconds, Success for 20 : 2,3,5,19,1,18,11,7,15,13,17,9,8,10,6,14,16,12,4,20,
0 seconds, Success for 21 : 1,16,9,7,2,5,21,4,17,15,19,11,8,3,13,20,6,14,10,18,12,
0 seconds, Success for 22 : 1,4,15,17,13,21,5,16,9,7,11,3,19,20,18,22,14,8,6,2,10,12,
0 seconds, Success for 23 : 1,17,13,21,5,16,9,7,11,3,19,23,15,8,22,2,20,6,14,4,10,18,12,
0 seconds, Success for 24 : 1,17,13,21,5,16,9,7,11,3,19,23,15,8,22,2,20,6,14,4,10,18,12,24,
0 seconds, Success for 25 : 1,21,4,17,19,15,23,7,16,5,11,9,13,14,25,3,22,20,2,18,8,10,6,24,12,
0 seconds, Success for 26 : 9,8,1,15,7,23,12,11,25,19,6,13,5,21,4,17,3,14,22,20,2,18,26,10,16,24,
0 seconds, Success for 27 : 9,19,17,2,15,7,23,12,11,1,21,16,5,27,13,14,25,3,22,26,18,8,10,6,4,20,24,
0 seconds, Success for 28 : 15,22,23,21,25,17,8,9,7,2,5,19,16,3,13,11,28,27,1,26,20,6,14,4,10,18,12,24,
0 seconds, Success for 29 : 21,20,1,19,15,4,11,13,9,17,28,23,5,18,7,29,27,2,25,3,22,8,14,26,16,10,6,24,12,
0 seconds, Failed: 30
1 seconds, Failed: 31
2 seconds, Failed: 32
3 seconds, Failed: 33
5 seconds, Success for 34 : 33,23,10,13,7,6,1,29,27,2,25,21,4,17,15,19,11,8,3,5,31,9,22,14,30,26,34,18,16,20,12,28,32,24,
7 seconds, Failed: 35
10 seconds, Failed: 36
5 seconds, Success for 37 : 6,1,17,10,7,13,15,11,19,3,16,23,9,37,35,2,33,5,28,27,29,25,4,21,31,32,30,34,26,8,18,14,22,20,24,36,12,
0 seconds, Success for 38 : 1,7,15,13,17,9,25,2,23,27,19,35,3,32,31,33,29,37,21,16,5,11,14,8,34,30,4,26,6,20,22,38,28,10,18,12,24,36,
32 seconds, Failed: 39
44 seconds, Failed: 40
1 minutes, Failed: 41
1 minutes, Failed: 42
2 minutes, Failed: 43
3 minutes, Failed: 44
4 minutes, Failed: 45
7 minutes, Failed: 46
12 minutes, Failed: 47
16 minutes, Failed: 48
24 minutes, Failed: 49
33 minutes, Failed: 50
40 minutes, Success for 51 : 46,45,1,44,49,39,10,29,21,37,5,32,23,41,51,31,20,11,9,2,43,35,8,27,13,14,25,3,47,40,7,33,16,17,15,19,26,50,28,22,6,38,34,4,30,18,42,48,36,12,24,
64 minutes, Failed: 52
103 minutes, Failed: 53
144 minutes, Failed: 54


105 minutes, Failed: 65
*/
