/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty;

import com.wittams.gritty.BackBuffer;
import com.wittams.gritty.ControlSequence;
import com.wittams.gritty.Mode;
import com.wittams.gritty.RequestOrigin;
import com.wittams.gritty.StoredCursor;
import com.wittams.gritty.Style;
import com.wittams.gritty.StyleState;
import com.wittams.gritty.TerminalDisplay;
import java.awt.Color;
import java.awt.Dimension;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.log4j.Logger;

public class TerminalWriter {
    private static final Logger logger = Logger.getLogger(TerminalWriter.class);
    private final int tab = 8;
    private int scrollRegionTop;
    private int scrollRegionBottom;
    private int cursorX = 0;
    private int cursorY = 1;
    private int termWidth = 80;
    private int termHeight = 24;
    private final TerminalDisplay display;
    private final BackBuffer backBuffer;
    private final StyleState styleState;
    private final EnumSet<Mode> modes = EnumSet.of(Mode.ANSI);
    static Color[] colors = new Color[]{Color.BLACK, Color.RED, Color.GREEN, Color.YELLOW, Color.BLUE, Color.MAGENTA, Color.CYAN, Color.WHITE};

    public TerminalWriter(TerminalDisplay term, BackBuffer buf, StyleState styleState) {
        this.display = term;
        this.backBuffer = buf;
        this.styleState = styleState;
        this.termWidth = term.getColumnCount();
        this.termHeight = term.getRowCount();
        this.scrollRegionTop = 1;
        this.scrollRegionBottom = this.termHeight;
    }

    public void setMode(Mode mode) {
        this.modes.add(mode);
        switch (mode) {
            case WideColumn: {
                this.resize(new Dimension(132, 24), RequestOrigin.Remote);
                this.clearScreen();
                this.restoreCursor(null);
            }
        }
    }

    public void unsetMode(Mode mode) {
        this.modes.remove((Object)mode);
        switch (mode) {
            case WideColumn: {
                this.resize(new Dimension(80, 24), RequestOrigin.Remote);
                this.clearScreen();
                this.restoreCursor(null);
            }
        }
    }

    private void wrapLines() {
        if (this.cursorX >= this.termWidth) {
            this.cursorX = 0;
            ++this.cursorY;
        }
    }

    private void finishText() {
        this.display.setCursor(this.cursorX, this.cursorY);
        this.scrollY();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeASCII(byte[] chosenBuffer, int start, int length) {
        this.backBuffer.lock();
        try {
            this.wrapLines();
            if (length != 0) {
                this.backBuffer.clearArea(this.cursorX, this.cursorY - 1, this.cursorX + length, this.cursorY);
                this.backBuffer.drawBytes(chosenBuffer, start, length, this.cursorX, this.cursorY);
            }
            this.cursorX += length;
            this.finishText();
        }
        finally {
            this.backBuffer.unlock();
        }
    }

    public void writeDoubleByte(byte[] bytesOfChar) throws UnsupportedEncodingException {
        this.writeString(new String(bytesOfChar, 0, 2, "EUC-JP"));
    }

    public void writeString(String string) {
        this.backBuffer.lock();
        try {
            this.wrapLines();
            this.backBuffer.clearArea(this.cursorX, this.cursorY - 1, this.cursorX + string.length(), this.cursorY);
            this.backBuffer.drawString(string, this.cursorX, this.cursorY);
            this.cursorX += string.length();
            this.finishText();
        }
        finally {
            this.backBuffer.unlock();
        }
    }

    public void writeUnwrappedString(String string) {
        int amountInLine;
        int length = string.length();
        for (int off = 0; off < length; off += amountInLine) {
            amountInLine = Math.min(this.distanceToLineEnd(), length - off);
            this.writeString(string.substring(off, off + amountInLine));
            this.wrapLines();
            this.scrollY();
        }
    }

    public void scrollY() {
        this.backBuffer.lock();
        try {
            if (this.cursorY > this.scrollRegionBottom) {
                int dy = this.scrollRegionBottom - this.cursorY;
                this.cursorY = this.scrollRegionBottom;
                this.scrollArea(this.scrollRegionTop, this.scrollRegionBottom - this.scrollRegionTop, dy);
                this.backBuffer.clearArea(0, this.cursorY - 1, this.termWidth, this.cursorY);
                this.display.setCursor(this.cursorX, this.cursorY);
            }
        }
        finally {
            this.backBuffer.unlock();
        }
    }

    public void newLine() {
        ++this.cursorY;
        this.display.setCursor(this.cursorX, this.cursorY);
        this.scrollY();
    }

    public void backspace() {
        --this.cursorX;
        if (this.cursorX < 0) {
            --this.cursorY;
            this.cursorX = this.termWidth - 1;
        }
        this.display.setCursor(this.cursorX, this.cursorY);
    }

    public void carriageReturn() {
        this.cursorX = 0;
        this.display.setCursor(this.cursorX, this.cursorY);
    }

    public void horizontalTab() {
        this.cursorX = (this.cursorX / 8 + 1) * 8;
        if (this.cursorX >= this.termWidth) {
            this.cursorX = 0;
            ++this.cursorY;
        }
        this.display.setCursor(this.cursorX, this.cursorY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseInDisplay(ControlSequence args) {
        this.backBuffer.lock();
        try {
            int endY;
            int beginY;
            int arg = args.getArg(0, 0);
            switch (arg) {
                case 0: {
                    if (this.cursorX < this.termWidth) {
                        this.backBuffer.clearArea(this.cursorX, this.cursorY - 1, this.termWidth, this.cursorY);
                    }
                    beginY = this.cursorY;
                    endY = this.termHeight;
                    break;
                }
                case 1: {
                    this.backBuffer.clearArea(0, this.cursorY - 1, this.cursorX + 1, this.cursorY);
                    beginY = 0;
                    endY = this.cursorY - 1;
                    break;
                }
                case 2: {
                    beginY = 0;
                    endY = this.termHeight;
                    break;
                }
                default: {
                    logger.error((Object)("Unsupported erase in display mode:" + arg));
                    beginY = 1;
                    endY = 1;
                }
            }
            if (beginY != endY) {
                this.clearLines(beginY, endY);
            }
        }
        finally {
            this.backBuffer.unlock();
        }
    }

    public void clearLines(int beginY, int endY) {
        this.backBuffer.lock();
        try {
            this.backBuffer.clearArea(0, beginY, this.termWidth, endY);
        }
        finally {
            this.backBuffer.unlock();
        }
    }

    public void clearScreen() {
        this.clearLines(0, this.termHeight);
    }

    public void eraseInLine(ControlSequence args) {
        int arg = args.getArg(0, 0);
        this.eraseInLine(arg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void eraseInLine(int arg) {
        this.backBuffer.lock();
        try {
            switch (arg) {
                case 0: {
                    if (this.cursorX >= this.termWidth) return;
                    this.backBuffer.clearArea(this.cursorX, this.cursorY - 1, this.termWidth, this.cursorY);
                    return;
                }
                case 1: {
                    int extent = Math.min(this.cursorX + 1, this.termWidth);
                    this.backBuffer.clearArea(0, this.cursorY - 1, extent, this.cursorY);
                    return;
                }
                case 2: {
                    this.backBuffer.clearArea(0, this.cursorY - 1, this.termWidth, this.cursorY);
                    return;
                }
                default: {
                    logger.error((Object)("Unsupported erase in line mode:" + arg));
                    return;
                }
            }
        }
        finally {
            this.backBuffer.unlock();
        }
    }

    public void cursorUp(ControlSequence args) {
        this.backBuffer.lock();
        try {
            int arg = args.getArg(0, 0);
            arg = arg == 0 ? 1 : arg;
            this.cursorY -= arg;
            this.cursorY = Math.max(this.cursorY, 1);
            this.display.setCursor(this.cursorX, this.cursorY);
        }
        finally {
            this.backBuffer.unlock();
        }
    }

    public void cursorDown(ControlSequence args) {
        this.backBuffer.lock();
        try {
            int arg = args.getArg(0, 0);
            arg = arg == 0 ? 1 : arg;
            this.cursorY += arg;
            this.cursorY = Math.min(this.cursorY, this.termHeight);
            this.display.setCursor(this.cursorX, this.cursorY);
        }
        finally {
            this.backBuffer.unlock();
        }
    }

    public void index() {
        this.backBuffer.lock();
        try {
            if (this.cursorY == this.termHeight) {
                this.scrollArea(this.scrollRegionTop, this.scrollRegionBottom - this.scrollRegionTop, -1);
                this.backBuffer.clearArea(0, this.scrollRegionBottom - 1, this.termWidth, this.scrollRegionBottom);
            } else {
                ++this.cursorY;
                this.display.setCursor(this.cursorX, this.cursorY);
            }
        }
        finally {
            this.backBuffer.unlock();
        }
    }

    private void scrollArea(int y, int h, int dy) {
        this.display.scrollArea(y, h, dy);
        this.backBuffer.scrollArea(y, h, dy);
    }

    public void nextLine() {
        this.backBuffer.lock();
        try {
            this.cursorX = 0;
            if (this.cursorY == this.termHeight) {
                this.scrollArea(this.scrollRegionTop, this.scrollRegionBottom - this.scrollRegionTop, -1);
                this.backBuffer.clearArea(0, this.scrollRegionBottom - 1, this.termWidth, this.scrollRegionBottom);
            } else {
                ++this.cursorY;
            }
            this.display.setCursor(this.cursorX, this.cursorY);
        }
        finally {
            this.backBuffer.unlock();
        }
    }

    public void reverseIndex() {
        this.backBuffer.lock();
        try {
            if (this.cursorY == 1) {
                this.scrollArea(this.scrollRegionTop - 1, this.scrollRegionBottom - this.scrollRegionTop, 1);
                this.backBuffer.clearArea(this.cursorX, this.cursorY - 1, this.termWidth, this.cursorY);
            } else {
                --this.cursorY;
                this.display.setCursor(this.cursorX, this.cursorY);
            }
        }
        finally {
            this.backBuffer.unlock();
        }
    }

    public void cursorForward(ControlSequence args) {
        int arg = args.getArg(0, 1);
        arg = arg == 0 ? 1 : arg;
        this.cursorX += arg;
        this.cursorX = Math.min(this.cursorX, this.termWidth - 1);
        this.display.setCursor(this.cursorX, this.cursorY);
    }

    public void cursorBackward(ControlSequence args) {
        int arg = args.getArg(0, 1);
        arg = arg == 0 ? 1 : arg;
        this.cursorX -= arg;
        this.cursorX = Math.max(this.cursorX, 0);
        this.display.setCursor(this.cursorX, this.cursorY);
    }

    public void cursorPosition(ControlSequence args) {
        int argy = args.getArg(0, 1);
        int argx = args.getArg(1, 1);
        this.cursorX = argx - 1;
        this.cursorY = argy;
        this.display.setCursor(this.cursorX, this.cursorY);
    }

    public void setScrollingRegion(ControlSequence args) {
        int y1 = args.getArg(0, 1);
        int y2 = args.getArg(1, this.termHeight);
        this.scrollRegionTop = y1;
        this.scrollRegionBottom = y2;
    }

    public void setCharacterAttributes(ControlSequence args) {
        int argCount = args.getCount();
        if (argCount == 0) {
            this.styleState.reset();
        }
        block9: for (int i = 0; i < argCount; ++i) {
            int arg = args.getArg(i, -1);
            if (arg == -1) {
                logger.error((Object)("Error in processing char attributes, arg " + i));
                continue;
            }
            switch (arg) {
                case 0: {
                    this.styleState.reset();
                    continue block9;
                }
                case 1: {
                    this.styleState.setOption(Style.Option.BOLD, true);
                    continue block9;
                }
                case 2: {
                    this.styleState.setOption(Style.Option.DIM, true);
                    continue block9;
                }
                case 4: {
                    this.styleState.setOption(Style.Option.UNDERSCORE, true);
                    continue block9;
                }
                case 5: {
                    this.styleState.setOption(Style.Option.BLINK, true);
                    continue block9;
                }
                case 7: {
                    this.styleState.setOption(Style.Option.REVERSE, true);
                    continue block9;
                }
                case 8: {
                    this.styleState.setOption(Style.Option.HIDDEN, true);
                    continue block9;
                }
                default: {
                    if (arg >= 30 && arg <= 37) {
                        this.styleState.setCurrentForeground(colors[arg - 30]);
                        continue block9;
                    }
                    if (arg >= 40 && arg <= 47) {
                        this.styleState.setCurrentBackground(colors[arg - 40]);
                        continue block9;
                    }
                    logger.error((Object)("Unknown character attribute:" + arg));
                }
            }
        }
    }

    public void beep() {
        this.display.beep();
    }

    public int distanceToLineEnd() {
        return this.termWidth - this.cursorX;
    }

    public void storeCursor(StoredCursor storedCursor) {
        storedCursor.x = this.cursorX;
        storedCursor.y = this.cursorY;
    }

    public void restoreCursor(StoredCursor storedCursor) {
        this.cursorX = 0;
        this.cursorY = 1;
        if (storedCursor != null) {
            this.cursorX = storedCursor.x;
            this.cursorY = storedCursor.y;
        }
        this.display.setCursor(this.cursorX, this.cursorY);
    }

    public Dimension resize(Dimension pendingResize, RequestOrigin origin) {
        int oldHeight = this.termHeight;
        Dimension pixelSize = this.display.doResize(pendingResize, origin);
        this.termWidth = this.display.getColumnCount();
        this.termHeight = this.display.getRowCount();
        this.scrollRegionBottom += this.termHeight - oldHeight;
        this.cursorY += this.termHeight - oldHeight;
        this.cursorY = Math.max(1, this.cursorY);
        return pixelSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillScreen(char c) {
        this.backBuffer.lock();
        try {
            char[] chars = new char[this.termWidth];
            Arrays.fill(chars, c);
            String str = new String(chars);
            for (int row = 1; row <= this.termHeight; ++row) {
                this.backBuffer.drawString(str, 0, row);
            }
        }
        finally {
            this.backBuffer.unlock();
        }
    }
}

